/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.Block;
import sweetmagic.api.iitem.IWand;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.item.magic.MFStuff;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileWandPedastal;
import sweetmagic.util.RenderUtil;

public class RenderWandPedastal<T extends TileWandPedastal>
extends RenderAbstractTile<T> {
    private static final Block SQUARE_L = BlockInit.magic_square_l_blank;
    private static final Block SQUARE_S = BlockInit.magic_square_s_blank;

    public RenderWandPedastal(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        ItemStack stack = ((TileWandPedastal)tile).getInputItem(0);
        if (stack.m_41619_()) {
            return;
        }
        int data = ((TileWandPedastal)tile).getData();
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.5, 0.5);
        pose.m_252781_(Axis.f_252436_.m_252977_(((TileAbstractSM)tile).getRot()));
        switch (data) {
            case 0: {
                this.renderWandPedastal(stack, info);
                break;
            }
            case 1: {
                this.renderWallBoard(stack, info);
                break;
            }
            case 2: {
                this.renderShopBoard(stack, info);
                break;
            }
            case 3: {
                this.renderItemMenu(stack, info);
                break;
            }
            case 4: {
                this.renderDecorativeStand(tile, parTick, stack, info);
                break;
            }
            case 5: {
                this.renderWandStand(stack, info);
            }
        }
        pose.m_85849_();
        if (data == 4) {
            pose.m_85836_();
            pose.m_85837_(0.5, 0.5, 0.5);
            pose.m_252781_(Axis.f_252436_.m_252977_(((TileAbstractSM)tile).getRot()));
            this.renderDecorativeStandSquare(tile, parTick, stack, info);
            pose.m_85849_();
        }
    }

    public void renderWandPedastal(ItemStack stack, RenderUtil.RenderInfo info) {
        Item item = stack.m_41720_();
        PoseStack pose = info.pose();
        if (item instanceof IWand || item instanceof DiggerItem || item instanceof MFStuff) {
            pose.m_85837_(0.0, 0.15, 0.0);
            pose.m_252781_(Axis.f_252403_.m_252977_(-45.0f));
        } else if (item instanceof SwordItem) {
            pose.m_85837_(0.0, 0.1, 0.0);
            pose.m_252781_(Axis.f_252403_.m_252977_(135.0f));
        }
        info.itemRender(stack);
    }

    public void renderWallBoard(ItemStack stack, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85837_(0.0, 0.0, 0.45);
        pose.m_85841_(0.75f, 0.75f, 0.75f);
        info.itemRender(stack);
    }

    public void renderShopBoard(ItemStack stack, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85837_(0.0, -0.1, 0.0);
        pose.m_85841_(0.5f, 0.5f, 0.5f);
        pose.m_252781_(Axis.f_252392_.m_252977_(90.0f));
        info.itemRender(stack);
    }

    public void renderItemMenu(ItemStack stack, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85837_(0.0, 0.0, 0.475);
        pose.m_85841_(0.55f, 0.55f, 0.55f);
        info.itemRender(stack);
    }

    public void renderDecorativeStand(T tile, float parTick, ItemStack stack, RenderUtil.RenderInfo info) {
        Item item = stack.m_41720_();
        double shake = 0.05;
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        float rotY = ((float)gameTime + parTick) / 30.0f;
        PoseStack pose = info.pose();
        Objects.requireNonNull(this);
        pose.m_252781_(Axis.f_252436_.m_252977_(rotY * 57.295776f + 360.0f));
        pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 10.0f) * shake, 0.0);
        if (item instanceof IWand || item instanceof MFStuff) {
            pose.m_85837_(0.0, 0.25, 0.0);
            pose.m_252781_(Axis.f_252403_.m_252977_(-45.0f));
        } else if (item instanceof DiggerItem || item instanceof SwordItem) {
            pose.m_85837_(0.0, 0.45, 0.0);
            pose.m_252781_(Axis.f_252403_.m_252977_(-45.0f));
        } else if (item instanceof BlockItem) {
            pose.m_85837_(0.0, 0.15, 0.0);
        } else {
            pose.m_85841_(0.67f, 0.67f, 0.67f);
            pose.m_85837_(0.0, 0.25, 0.0);
        }
        info.itemRender(stack);
    }

    public void renderDecorativeStandSquare(T tile, float parTick, ItemStack stack, RenderUtil.RenderInfo info) {
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        PoseStack pose = info.pose();
        pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 15.0f) * 0.02 + 0.35, 0.0);
        pose.m_85841_(2.0f, 2.0f, 2.0f);
        float f = -((float)gameTime + parTick) / 20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_252781_(Axis.f_252436_.m_252977_(angle));
        pose.m_85837_(-0.25, -0.25, -0.25);
        pose.m_85841_(0.5f, 0.5f, 0.5f);
        RenderUtil.RenderColor color = RenderUtil.RenderColor.create(76.0f, 165.0f, 255.0f, info);
        RenderUtil.renderBlock(info, color, SQUARE_L);
        pose.m_85837_(0.3, 0.65, 0.3);
        pose.m_85841_(0.4f, 0.4f, 0.4f);
        RenderUtil.renderBlock(info, color, SQUARE_S);
    }

    public void renderWandStand(ItemStack stack, RenderUtil.RenderInfo info) {
        Item item = stack.m_41720_();
        PoseStack pose = info.pose();
        if (stack.m_150930_(ItemInit.cosmic_rifle)) {
            pose.m_85837_(0.53, -0.02, 0.0);
            pose.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        } else if (item instanceof IWand || item instanceof DiggerItem || item instanceof MFStuff) {
            pose.m_85837_(0.1, -0.02, 0.0);
            pose.m_252781_(Axis.f_252403_.m_252977_(-135.0f));
        } else if (item instanceof SwordItem) {
            pose.m_85837_(0.0, 0.1, 0.0);
            pose.m_252781_(Axis.f_252403_.m_252977_(135.0f));
        }
        info.itemRender(stack);
    }
}

