/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileWandReconstruct;
import sweetmagic.util.RenderUtil;

public class RenderWandReconstruct<T extends TileWandReconstruct>
extends RenderAbstractTile<T> {
    private static final Block SQUARE = BlockInit.magic_square_l;
    private static final Block SQUARE_BLANK = BlockInit.magic_square_l_blank;

    public RenderWandReconstruct(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        ItemStack sub;
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        boolean isCraft = ((TileWandReconstruct)tile).isCraft;
        ItemStack stack = !isCraft ? ((TileWandReconstruct)tile).getInputItem() : ((TileWandReconstruct)tile).copyMagic;
        ItemStack main = !isCraft ? ((TileWandReconstruct)tile).getSubItem(0) : ((TileWandReconstruct)tile).mainMagic;
        ItemStack itemStack = sub = !isCraft ? ((TileWandReconstruct)tile).getSubItem(1) : ((TileWandReconstruct)tile).subMagic;
        if (stack.m_41619_() && !isCraft) {
            stack = ((TileWandReconstruct)tile).getOutItem();
        }
        this.renderStack(tile, info, main, gameTime, 0.25f, -0.375, -0.2, 0.375);
        this.renderStack(tile, info, sub, gameTime, 0.25f, -0.375, -0.2, -0.375);
        this.renderStack(tile, info, stack, gameTime, 0.5f, 0.1, -0.3, 0.0);
        if (isCraft) {
            float progress = Math.min(1.0f, (float)((TileWandReconstruct)tile).nowTick * 1.25f / ((float)((TileWandReconstruct)tile).maxCraftTime * 20.0f));
            float f = (float)gameTime / -20.0f;
            Objects.requireNonNull(this);
            float angle = f * 57.295776f;
            float size = Math.min(1.0f, 0.25f + 0.875f * progress);
            PoseStack pose = info.pose();
            pose.m_85836_();
            pose.m_85837_(0.625, 0.8 + 0.6 * (double)progress, 0.5);
            pose.m_85841_(size, size, size);
            pose.m_252781_(Axis.f_252436_.m_252977_(-angle));
            pose.m_85837_(-0.5, 0.0, -0.5);
            RenderUtil.renderBlock(info, new RenderUtil.RenderColor(0.28235295f, 1.0f, 1.0f, info.light(), info.overlay()), SQUARE_BLANK);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_85837_(0.625, 0.8, 0.5);
            pose.m_85841_(size, size, size);
            pose.m_252781_(Axis.f_252436_.m_252977_(angle));
            pose.m_85837_(-0.5, 0.0, -0.5);
            RenderUtil.renderBlock(info, new RenderUtil.RenderColor(0.28235295f, 1.0f, 1.0f, info.light(), info.overlay()), SQUARE);
            pose.m_85849_();
        }
    }

    public void renderStack(T tile, RenderUtil.RenderInfo info, ItemStack stack, int gameTime, float scale, double x, double y, double z) {
        if (stack.m_41619_()) {
            return;
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5 + x, 1.4 + y + Math.sin((double)gameTime * 0.1) * 0.05, 0.5 + z);
        float rotY = (float)gameTime * 0.05f;
        Objects.requireNonNull(this);
        pose.m_252781_(Axis.f_252436_.m_252977_(rotY * 57.295776f));
        pose.m_85841_(scale, scale, scale);
        info.itemRenderNo(stack);
        pose.m_85849_();
    }
}

