/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.monster.boss.DemonsBelial;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.DemonsBelialModel;
import sweetmagic.util.RenderUtil;

public class DemonsBelialLayer<T extends DemonsBelial, M extends DemonsBelialModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final Block FLAME = BlockInit.belial_flame;
    private static final ItemStack STACK = new ItemStack((ItemLike)ItemInit.angel_wing_b);

    public DemonsBelialLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
        this.setModel(new DemonsBelialModel(this.getModel(con, DemonsBelialModel.LAYER)));
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity) {
        if (!entity.m_6084_()) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            this.renderAngelWingBig(entity, pose, buf, light, i == 0);
            this.renderAngelWingSmall(entity, pose, buf, light, i == 0);
            this.renderFlame(entity, pose, buf, light, i == 0);
        }
    }

    public void renderAngelWingBig(T entity, PoseStack pose, MultiBufferSource buf, int light, boolean isReverse) {
        float scale = 2.5f;
        float reverseRate = isReverse ? -1.0f : 1.0f;
        pose.m_85836_();
        DemonsBelialModel model = (DemonsBelialModel)this.m_117386_();
        model.translateAndRotate(model.body, pose);
        pose.m_252880_(-0.15f * reverseRate, -0.75f, 0.4f);
        pose.m_252781_(Axis.f_252392_.m_252977_((60.0f + 20.0f * Mth.m_14031_((float)((float)((DemonsBelial)entity).f_19797_ * 0.1f))) * reverseRate));
        pose.m_85841_(scale, -scale, scale);
        this.renderItemFix(entity, STACK, pose, buf, light);
        pose.m_85849_();
    }

    public void renderAngelWingSmall(T entity, PoseStack pose, MultiBufferSource buf, int light, boolean isReverse) {
        float scale = 1.85f;
        float reverseRate = isReverse ? -1.0f : 1.0f;
        pose.m_85836_();
        DemonsBelialModel model = (DemonsBelialModel)this.m_117386_();
        model.translateAndRotate(model.body, pose);
        pose.m_252880_(-0.25f * reverseRate, -0.25f, 0.45f);
        pose.m_252781_(Axis.f_252392_.m_252977_((60.0f - 20.0f * Mth.m_14031_((float)((float)((DemonsBelial)entity).f_19797_ * 0.1f))) * reverseRate));
        pose.m_252781_(Axis.f_252529_.m_252977_(-50.0f));
        pose.m_85841_(scale, -scale, scale);
        this.renderItemFix(entity, STACK, pose, buf, light);
        pose.m_85849_();
    }

    public void renderFlame(T entity, PoseStack pose, MultiBufferSource buf, int light, boolean isLeft) {
        if (((DemonsBelial)entity).getNoMove() || !entity.isHalfHealth(entity)) {
            return;
        }
        float scale = 0.55f;
        pose.m_85836_();
        DemonsBelialModel model = (DemonsBelialModel)this.m_117386_();
        model.translateAndRotate(isLeft ? model.leftArm : model.rightArm, pose);
        pose.m_85841_(scale, -scale * 1.5f, scale);
        pose.m_252880_(isLeft ? 1.0f : -2.0f, -1.5f, -0.35f);
        RenderUtil.renderBlock(pose, buf, new RenderUtil.RenderColor(1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_), FLAME);
        pose.m_85849_();
    }
}

