/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.util.RenderUtil;

public class MagicCycleLayer<T extends LivingEntity, M extends EntityModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final Block SQUARE = BlockInit.magic_square_l_blank;

    public MagicCycleLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        if (((LivingEntity)entity).f_19797_ > 100 || !entity.m_21023_(PotionInit.magic_array)) {
            return;
        }
        float maxSize = 3.0f;
        float addValue = 0.0875f;
        int tickCount = ((LivingEntity)entity).f_19797_;
        float size = Math.min(maxSize, 0.3f + (float)tickCount * addValue);
        if (tickCount >= 90) {
            size -= (float)(tickCount - 90) * 0.225f;
        }
        pose.m_85836_();
        pose.m_85837_(0.0, 1.5, 0.0);
        pose.m_85841_(size, size, size);
        float f = ((float)tickCount + parTick) / 10.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_252781_(Axis.f_252436_.m_252977_(angle));
        pose.m_85837_(-0.5, 0.0, -0.5);
        float rgb = (float)Math.sin(((float)tickCount + parTick) / 10.0f) * 40.0f;
        RenderUtil.renderBlock(pose, buf, new RenderUtil.RenderColor((72.0f + rgb) / 255.0f, (200.0f + rgb) / 255.0f, (200.0f + rgb) / 255.0f, light, OverlayTexture.f_118083_), SQUARE);
        pose.m_85849_();
    }
}

