/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.render.entity.model.SMBaseModel;

public class AncientFairyModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public static final ModelLayerLocation LAYER = AncientFairyModel.getLayer("ancientfairy");
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public AncientFairyModel(ModelPart root) {
        super(root);
        this.f_102814_.f_104207_ = false;
        this.f_102809_.f_104207_ = false;
        this.rightWing = root.m_171324_("right_wing");
        this.leftWing = root.m_171324_("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition part = mesh.m_171576_();
        part.m_171599_("right_leg", SMBaseModel.getCubeList(32, 0).m_171481_(-1.0f, -1.0f, -2.0f, 6.0f, 10.0f, 4.0f), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        part.m_171599_("right_wing", SMBaseModel.getCubeList(0, 32).m_171481_(-20.0f, 0.0f, 0.0f, 20.0f, 12.0f, 1.0f), PartPose.f_171404_);
        part.m_171599_("left_wing", SMBaseModel.getCubeList(0, 32).m_171480_().m_171481_(0.0f, 0.0f, 0.0f, 20.0f, 12.0f, 1.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.rightWing, (Object)this.leftWing));
    }

    public void m_6973_(T entity, float swing, float swingAmount, float ageTick, float headYaw, float headPitch) {
        super.m_6973_(entity, swing, swingAmount, ageTick, headYaw, headPitch);
        this.f_102813_.f_104203_ += 0.62831855f;
        this.rightWing.f_104202_ = 2.0f;
        this.leftWing.f_104202_ = 2.0f;
        this.rightWing.f_104201_ = 1.0f;
        this.leftWing.f_104201_ = 1.0f;
        this.rightWing.f_104204_ = 0.47123894f + Mth.m_14089_((float)(ageTick * 45.836624f * ((float)Math.PI / 360))) * (float)Math.PI * 0.05f;
        this.leftWing.f_104204_ = -this.rightWing.f_104204_;
        this.leftWing.f_104205_ = -0.47123894f;
        this.leftWing.f_104203_ = 0.47123894f;
        this.rightWing.f_104203_ = 0.47123894f;
        this.rightWing.f_104205_ = 0.47123894f;
    }

    public static ModelLayerLocation getLayer(String name) {
        return new ModelLayerLocation(SweetMagicCore.getSRC(name), "main");
    }
}

