/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import sweetmagic.init.entity.monster.boss.IgnisKnight;
import sweetmagic.init.render.entity.model.SMBaseModel;

public class IgnisModel<T extends IgnisKnight>
extends SMBaseModel<T> {
    public static final ModelLayerLocation LAYER = IgnisModel.getLayer("sm_ignis");
    private final ModelPart body;
    private final ModelPart jacket;
    private final ModelPart legJacketLeft;
    private final ModelPart legJacketRight;
    private final ModelPart earLeft;
    private final ModelPart earRight;
    private final ModelPart tail;
    private final ModelPart skirt;
    private boolean isSwing = false;
    public int tickTime = 0;

    public IgnisModel(ModelPart root) {
        super(root);
        this.body = root.m_171324_("body");
        this.jacket = root.m_171324_("jacket");
        this.legJacketLeft = root.m_171324_("legJacketLeft");
        this.legJacketRight = root.m_171324_("legJacketRight");
        this.earLeft = root.m_171324_("earLeft");
        this.earRight = root.m_171324_("earRight");
        this.tail = root.m_171324_("tail");
        this.skirt = root.m_171324_("skirt");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        part.m_171599_("head", IgnisModel.getCubeList(0, 0).m_171488_(-4.0f, -7.0f, -4.0f, 8.0f, 8.0f, 8.0f, IgnisModel.getCube(-0.5f)), IgnisModel.getPose(0.0f, 0.0f, 0.0f));
        part.m_171599_("body", IgnisModel.getCubeList(16, 16).m_171488_(-3.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, IgnisModel.getCube(0.0f)), IgnisModel.getPose(-1.0f, 0.0f, 0.0f));
        part.m_171599_("jacket", IgnisModel.getCubeList(32, 0).m_171488_(-3.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, IgnisModel.getCube(0.35f)), IgnisModel.getPose(-1.0f, 0.3f, -0.15f));
        part.m_171599_("armLeft", IgnisModel.getCubeList(40, 32).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, IgnisModel.getCube(-0.2f)), IgnisModel.getPose(-5.75f, 1.8f, 0.0f));
        part.m_171599_("armRight", IgnisModel.getCubeList(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, IgnisModel.getCube(-0.2f)), IgnisModel.getPose(5.75f, 1.8f, 0.0f));
        part.m_171599_("armJacketLeft", IgnisModel.getCubeList(40, 48).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, IgnisModel.getCube(0.0f)), IgnisModel.getPose(-5.75f, 1.95f, 0.0f));
        part.m_171599_("armJacketRight", IgnisModel.getCubeList(40, 48).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, IgnisModel.getCube(0.0f)), IgnisModel.getPose(5.75f, 1.95f, 0.0f));
        part.m_171599_("legLeft", IgnisModel.getCubeList(0, 16).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, IgnisModel.getCube(-0.075f)), IgnisModel.getPose(1.0f, 14.0f, 0.0f));
        part.m_171599_("legRight", IgnisModel.getCubeList(0, 16).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, IgnisModel.getCube(-0.075f)), IgnisModel.getPose(-3.0f, 14.0f, 0.0f));
        part.m_171599_("legJacketLeft", IgnisModel.getCubeList(0, 32).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, IgnisModel.getCube(0.1f)), IgnisModel.getPose(1.0f, 14.0f, 0.0f));
        part.m_171599_("legJacketRight", IgnisModel.getCubeList(0, 32).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, IgnisModel.getCube(0.1f)), IgnisModel.getPose(-3.0f, 14.0f, 0.0f));
        part.m_171599_("skirt", IgnisModel.getCubeList(16, 45).m_171488_(-3.0f, 0.0f, -2.0f, 8.0f, 4.0f, 4.0f, IgnisModel.getCube(0.0f)), IgnisModel.getPose(-1.0f, 10.0f, -0.15f));
        part.m_171599_("earRight", IgnisModel.getCubeList(0, 57).m_171488_(-2.5f, -9.0f, -1.0f, 3.0f, 5.0f, 1.0f, IgnisModel.getCube(-0.2f)), IgnisModel.getPose(0.0f, 0.5f, -1.0f));
        part.m_171599_("earLeft", IgnisModel.getCubeList(8, 57).m_171488_(0.5f, -9.0f, -1.0f, 3.0f, 5.0f, 1.0f, IgnisModel.getCube(-0.2f)), IgnisModel.getPose(0.0f, 0.0f, -1.0f));
        part.m_171599_("tail", IgnisModel.getCubeList(16, 32).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 12.0f, 1.0f, IgnisModel.getCube(-0.2f)), IgnisModel.getPose(0.0f, 15.0f, 8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public void setupAnim(T entity, float swing, float swingAmount, float ageTick, float headYaw, float headPitch) {
        this.animHead(entity, ageTick, headYaw, headPitch);
        Vector3f vec = new Vector3f(Mth.m_14089_((float)(swing * 0.662f * 0.85f / entity.m_6134_())) * swingAmount, 0.0f, 0.0f);
        this.swingArms(entity, vec);
        this.swingLegs(vec);
        this.skirt.f_233553_ = 1.0f;
        this.skirt.f_104201_ = 12.0f;
        this.skirt.f_104202_ = 0.025f;
    }

    public void animHead(T entity, float ageTick, float headYaw, float headPitch) {
        Vector3f vec = new Vector3f(headPitch * ((float)Math.PI / 180), headYaw * ((float)Math.PI / 180), 0.0f);
        this.head.m_233569_();
        this.head.m_252899_(vec);
        this.head.m_171327_(headPitch * ((float)Math.PI / 180), headYaw * ((float)Math.PI / 180), 0.0f);
        this.earLeft.m_104315_(this.head);
        this.earLeft.f_104200_ -= 0.5f;
        this.earLeft.f_104201_ -= 1.0f;
        this.earRight.m_104315_(this.head);
        this.earRight.f_104200_ -= 0.5f;
        this.earRight.f_104201_ -= 1.0f;
        float headAngleX = this.head.f_104203_ * 1.0f;
        float ageCos1 = Mth.m_14089_((float)(ageTick * 0.11f)) * 0.045f;
        this.earRight.f_104203_ = -ageCos1 + headAngleX;
        this.earLeft.f_104203_ = ageCos1 + headAngleX;
        this.tail.f_104203_ = 0.9f;
        this.tail.f_104200_ = 0.0f;
        this.tail.f_104201_ = 10.0f;
        this.tail.f_104202_ = 0.0f;
        this.tail.f_233553_ = 1.25f;
        this.tail.f_233554_ = 0.75f;
        this.tail.f_233555_ = 1.25f;
        float ageCos2 = Mth.m_14089_((float)(ageTick * 0.06875f));
        this.tail.f_104205_ = -ageCos2 * 0.35f;
    }

    public void swingArms(T entity, Vector3f vec3f) {
        Vector3f base = this.copy(vec3f);
        base.mul(1.0471976f);
        Vector3f mirror = this.copy(base);
        mirror.mul(-1.0f);
        this.armLeft.m_233569_();
        this.armRight.m_233569_();
        this.armLeft.m_252899_(base);
        this.armRight.m_252899_(mirror);
        this.body.f_104204_ = 0.0f;
        int attackType = ((IgnisKnight)entity).getAttackType();
        switch (attackType) {
            case 0: {
                this.hammerAttack(entity);
                break;
            }
            case 1: {
                this.hammerGroundwork(entity);
                break;
            }
            case 2: {
                this.hammerBlast(entity);
            }
        }
        this.jacket.m_104315_(this.body);
        this.armJacketLeft.m_104315_(this.armLeft);
        this.armJacketRight.m_104315_(this.armRight);
    }

    public void hammerAttack(T entity) {
        if (!this.isSwing) {
            this.isSwing = ((IgnisKnight)entity).getSwing() && this.tickTime <= 0;
        }
        this.tickTime += this.isSwing ? 1 : -1;
        int maxtick = 30;
        this.tickTime = Math.max(Math.min(this.tickTime, maxtick), 0);
        float tickRate = Math.min(1.0f, (float)this.tickTime / (float)maxtick);
        if (this.tickTime >= maxtick) {
            this.isSwing = false;
        }
        this.armLeft.f_104200_ = -5.5f + 3.5f * tickRate;
        this.armLeft.f_104201_ = 2.25f;
        this.armLeft.f_104202_ = 2.25f - 5.0f * tickRate;
        this.armLeft.f_104203_ = -1.0f + 0.5f * tickRate;
        this.armLeft.f_104205_ = 0.5f - 2.0f * tickRate;
        this.armRight.f_104200_ = 4.0f;
        this.armRight.f_104202_ = -2.0f + 5.5f * tickRate;
        this.armRight.f_104201_ = 2.5f;
        this.armRight.f_104203_ = -0.5f - 1.35f * tickRate;
        this.armRight.f_104204_ = 0.0f - 0.5f * tickRate;
        this.armRight.f_104205_ = 0.85f + 0.5f * tickRate;
        this.body.f_104204_ = -(0.5f * tickRate);
    }

    public void hammerGroundwork(T entity) {
        if (!this.isSwing) {
            this.isSwing = ((IgnisKnight)entity).getSwing() && this.tickTime <= 0;
        }
        this.tickTime = this.isSwing ? this.tickTime + 1 : this.tickTime - 1;
        int maxtick = 20;
        this.tickTime = Math.max(Math.min(this.tickTime, maxtick), 0);
        float tickRate = (float)this.tickTime / (float)maxtick;
        if (this.tickTime >= maxtick) {
            this.isSwing = false;
        }
        this.armLeft.f_104200_ = -5.0f + 1.0f * tickRate;
        this.armLeft.f_104201_ = 1.5f + 2.0f * tickRate;
        this.armLeft.f_104202_ = 2.0f - 3.0f * tickRate;
        this.armLeft.f_104203_ = -2.25f + 1.75f * tickRate;
        this.armLeft.f_104204_ = 0.0f - 0.5f * tickRate;
        this.armLeft.f_104205_ = -0.25f;
        this.armRight.f_104200_ = 4.0f;
        this.armRight.f_104201_ = 2.5f - 0.5f * tickRate;
        this.armRight.f_104202_ = -2.0f;
        this.armRight.f_104203_ = -0.75f - 0.5f * tickRate;
        this.armRight.f_104204_ = 0.5f - 2.0f * tickRate;
        this.armRight.f_104205_ = 1.5f;
        this.body.f_104204_ = 0.5f - 0.5f * tickRate;
    }

    public void hammerBlast(T entity) {
        if (!this.isSwing) {
            this.isSwing = ((IgnisKnight)entity).getSwing() && this.tickTime <= 0;
        }
        this.tickTime = this.isSwing ? this.tickTime + 1 : this.tickTime - 1;
        int maxtick = 15;
        this.tickTime = Math.max(Math.min(this.tickTime, maxtick), 0);
        float tickRate = (float)this.tickTime / (float)maxtick;
        if (this.tickTime >= maxtick && !((IgnisKnight)entity).getBlast()) {
            this.isSwing = false;
        }
        this.armLeft.f_104200_ = -4.5f - 1.0f * tickRate;
        this.armLeft.f_104201_ = -2.5f + 7.0f * tickRate;
        this.armLeft.f_104202_ = -1.5f - 1.0f * tickRate;
        this.armLeft.f_104203_ = -1.35f + 0.5f * tickRate;
        this.armLeft.f_104204_ = -1.4f + 2.25f * tickRate;
        this.armLeft.f_104205_ = -1.25f;
        this.armRight.f_104200_ = 5.5f - 1.5f * tickRate;
        this.armRight.f_104201_ = -1.25f + 4.75f * tickRate;
        this.armRight.f_104202_ = -2.0f;
        this.armRight.f_104203_ = -1.0f - 0.5f * tickRate;
        this.armRight.f_104204_ = 1.0f - 2.5f * tickRate;
        this.armRight.f_104205_ = 1.75f;
    }

    @Override
    public void swingLegs(Vector3f vec) {
        super.swingLegs(vec);
        this.legJacketRight.m_104315_(this.legRight);
        this.legJacketRight.f_233553_ = 0.925f;
        this.legJacketRight.f_104200_ = -2.9375f;
        this.legJacketLeft.m_104315_(this.legLeft);
        this.legJacketLeft.f_233553_ = 0.925f;
        this.legJacketLeft.f_104200_ = 1.075f;
    }

    public void hammerBlastItem(PoseStack pose) {
        int maxtick = 15;
        float tickRate = (float)this.tickTime / (float)maxtick;
        pose.m_252781_(Axis.f_252529_.m_252977_(135.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(0.0f - 37.0f * tickRate));
        pose.m_252781_(Axis.f_252403_.m_252977_(270.0f));
        pose.m_85837_(-0.25, 0.1, 0.0);
    }
}

