/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;
import sweetmagic.SweetMagicCore;

public abstract class SMBaseModel<T extends LivingEntity>
extends EntityModel<T> {
    protected static final float TORADIAN = (float)Math.PI / 180;
    protected static final float ARM_SWING_AMOUNT = 1.0471976f;
    protected static final float LEG_SWING_AMOUNT = 1.134464f;
    protected static final float LIMB_SWING_WEIGHT = 0.85f;
    private static final Vector3f ANIMA_VEC = new Vector3f();
    protected final ModelPart root;
    public final ModelPart head;
    protected final ModelPart armLeft;
    protected final ModelPart armRight;
    protected final ModelPart armJacketLeft;
    protected final ModelPart armJacketRight;
    protected final ModelPart legLeft;
    protected final ModelPart legRight;

    public SMBaseModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.armLeft = root.m_171324_("armLeft");
        this.armRight = root.m_171324_("armRight");
        this.armJacketLeft = root.m_171324_("armJacketLeft");
        this.armJacketRight = root.m_171324_("armJacketRight");
        this.legLeft = root.m_171324_("legLeft");
        this.legRight = root.m_171324_("legRight");
    }

    public void setupAnim(T entity, float swing, float swingAmount, float ageTick, float headYaw, float headPitch) {
        this.animHead(headYaw, headPitch);
        Vector3f vec = new Vector3f(Mth.m_14089_((float)(swing * 0.662f * 0.85f / entity.m_6134_())) * swingAmount, 0.0f, 0.0f);
        this.swingArms(vec);
        this.swingLegs(vec);
        this.swingBody(vec);
    }

    public void animHead(float headYaw, float headPitch) {
        Vector3f vec = new Vector3f(headPitch * ((float)Math.PI / 180), headYaw * ((float)Math.PI / 180), 0.0f);
        this.head.m_233569_();
        this.head.m_252899_(vec);
        this.head.m_171327_(headPitch * ((float)Math.PI / 180), headYaw * ((float)Math.PI / 180), 0.0f);
    }

    public void swingArms(Vector3f vec) {
        Vector3f base = this.copy(vec);
        base.mul(1.0471976f);
        Vector3f mirror = this.copy(base);
        mirror.mul(-1.0f);
        this.armLeft.m_233569_();
        this.armRight.m_233569_();
        this.armLeft.m_252899_(base);
        this.armRight.m_252899_(mirror);
        this.armJacketLeft.m_233569_();
        this.armJacketRight.m_233569_();
        this.armJacketLeft.m_252899_(base);
        this.armJacketRight.m_252899_(mirror);
    }

    public void swingLegs(Vector3f vec3f) {
        Vector3f base = this.copy(vec3f);
        base.mul(1.134464f);
        Vector3f mirror = this.copy(base);
        mirror.mul(-1.0f);
        this.legRight.m_233569_();
        this.legLeft.m_233569_();
        this.legRight.m_252899_(base);
        this.legLeft.m_252899_(mirror);
    }

    public void swingBody(Vector3f vec) {
    }

    public void m_7695_(PoseStack pose, VertexConsumer ver, int light, int overlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(pose, ver, light, overlay, red, green, blue, alpha);
    }

    public ModelPart getArm(boolean isLeft) {
        return isLeft ? this.armRight : this.armLeft;
    }

    public void translateAndRotate(ModelPart arm, PoseStack pose) {
        pose.m_85837_((double)(arm.f_104200_ / 16.0f), (double)(arm.f_104201_ / 16.0f), (double)(arm.f_104202_ / 16.0f));
        if (arm.f_104205_ != 0.0f) {
            pose.m_252781_(Axis.f_252403_.m_252961_(arm.f_104205_));
        }
        if (arm.f_104204_ != 0.0f) {
            pose.m_252781_(Axis.f_252436_.m_252961_(arm.f_104204_));
        }
        if (arm.f_104203_ != 0.0f) {
            pose.m_252781_(Axis.f_252529_.m_252961_(arm.f_104203_));
        }
        if (arm.f_233553_ != 1.0f || arm.f_233554_ != 1.0f || arm.f_233555_ != 1.0f) {
            pose.m_85841_(arm.f_233553_, arm.f_233554_, arm.f_233555_);
        }
    }

    public ModelPart root() {
        return this.root;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void animate(AnimationState state, AnimationDefinition def, float par1) {
        state.m_216974_(par1, 1.0f);
        state.m_216979_(e -> this.animate(this, def, e.m_216981_(), 1.0f, ANIMA_VEC));
    }

    public static CubeListBuilder getCubeList(int x, int y) {
        return CubeListBuilder.m_171558_().m_171514_(x, y);
    }

    public static CubeDeformation getCube(float rate) {
        return new CubeDeformation(rate);
    }

    public static PartPose getPose(float x, float y, float z) {
        return PartPose.m_171419_((float)x, (float)y, (float)z);
    }

    public static ModelLayerLocation getLayer(String name) {
        return new ModelLayerLocation(SweetMagicCore.getSRC(name), "main");
    }

    public void animate(SMBaseModel<?> model, AnimationDefinition anime, long par1, float par2, Vector3f vec) {
        float f = this.getElapsedSeconds(anime, par1);
        for (Map.Entry entry : anime.f_232257_().entrySet()) {
            Optional<ModelPart> opti = model.getAnyDescendantWithName((String)entry.getKey());
            List list = (List)entry.getValue();
            opti.ifPresent(par3 -> list.forEach(par4 -> {
                Keyframe[] frame = par4.f_232212_();
                int i = Math.max(0, Mth.m_14049_((int)0, (int)frame.length, par5 -> f <= frame[par5].f_232283_()) - 1);
                int j = Math.min(frame.length - 1, i + 1);
                Keyframe keyframe = frame[i];
                Keyframe keyframe1 = frame[j];
                float f1 = f - keyframe.f_232283_();
                float f2 = Mth.m_14036_((float)(f1 / (keyframe1.f_232283_() - keyframe.f_232283_())), (float)0.0f, (float)1.0f);
                keyframe1.f_232285_().m_232222_(vec, f2, frame, i, j, par2);
                par4.f_232211_().m_232247_(par3, vec);
            }));
        }
    }

    public Optional<ModelPart> getAnyDescendantWithName(String par1) {
        return this.root().m_171331_().filter(par2 -> par2.m_233562_(par1)).findFirst().map(par2 -> par2.m_171324_(par1));
    }

    private float getElapsedSeconds(AnimationDefinition anima, long par1) {
        float f = (float)par1 / 1000.0f;
        return anima.f_232256_() ? f % anima.f_232255_() : f;
    }

    public Vector3f copy(Vector3f vec) {
        return new Vector3f(vec.x, vec.y, vec.z);
    }
}

