/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix4f;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.AquariumPotMenu;
import sweetmagic.init.tile.sm.TileAquariumPot;

public class GuiAquariumPot
extends GuiSMBase<AquariumPotMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_aquarium.png");
    private final TileAquariumPot tile;
    private final int data;

    public GuiAquariumPot(AquariumPotMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(176, 172);
        this.tile = menu.tile;
        this.data = this.tile.getData(this.tile.m_58899_());
        if (this.data == 3) {
            this.addButtonMap(0, new SMButton(TEX, 112, 22, 0, 194, 20, 12));
            this.addButtonMap(1, new SMButton(TEX, 133, 22, 0, 194, 20, 12));
        }
        this.addRenderTexList(new SMRenderTex(MISC, 7, 7, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(menu.tile, true)));
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        int progress;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        if (this.tile.getStackCount() > 0) {
            progress = this.tile.getProgress(31);
            this.blit(pose, x + 78, y + 75 - progress, 198, 82 - progress, 16, progress);
        }
        if (this.data == 3) {
            this.blit(pose, x + 112, y + 7, 0, 176, 41, 13);
            this.drawShadow(pose, (Component)this.getLabel("-1"), x + 116, y + 24, 0xEEEEEE);
            this.drawShadow(pose, (Component)this.getLabel("-10"), x + 135, y + 24, 0xEEEEEE);
            MutableComponent tip = this.getLabel(this.player.f_36078_);
            this.drawShadow(pose, (Component)tip, x + 114 + this.f_96547_.m_92895_(tip.getString()), y + 10, 7405421);
        } else if (this.data == 10) {
            this.blit(pose, x + 157, y + 7, 218, 7, 11, 77);
            progress = (int)this.tile.getFluidProgressScaled(75.0f);
            if (progress > 0) {
                int height = 75;
                int width = 10;
                FluidStack fluid = this.tile.getContent();
                IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType());
                ResourceLocation src = ext.getStillTexture(fluid);
                TextureAtlasSprite tex = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(src);
                int y1 = y + (height - progress);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                Matrix4f mat = pose.m_280168_().m_85850_().m_252922_();
                int hc = progress / 16;
                int hr = progress - hc * 16;
                if (hc > 0) {
                    for (int h = 0; h < hc; ++h) {
                        int y2 = y1 + hr + h * 16;
                        this.drawFluid(mat, x + 157, y2 + 8, width, 16, tex, 0);
                    }
                }
                if (hr > 0) {
                    this.drawFluid(mat, x + 157, y1 + 8, width, hr, tex, 16 - hr);
                }
                RenderSystem.setShader(GameRenderer::m_172814_);
                pose.m_280168_().m_85837_(0.0, 0.0, 100.0);
                this.blit(pose, x + 157, y + 7, 232, 7, 11, 77);
            }
        }
        pose.m_280480_(this.tile.getStack(), x + 125, y + 50);
    }

    @Override
    protected void m_280003_(GuiGraphics pose, int mouseX, int mouseY) {
        int yAxis;
        int xAxis;
        super.m_280003_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 78;
        int tipY = this.getHeight() + 43;
        if (this.isRender(tipX, tipY, mouseX, mouseY, 16, 30)) {
            xAxis = mouseX - this.getWidth();
            yAxis = mouseY - this.getHeight();
            boolean isMax = this.tile.isMaxStackCount();
            String tip = this.tile.getStackCount() + " / 8";
            ArrayList<Component> tipList = new ArrayList<Component>();
            tipList.add((Component)this.getTipArray(new Object[]{this.getText("stack_count"), ": ", this.getLabel(tip, isMax ? GOLD : WHITE)}).m_130940_(GREEN));
            if (!isMax) {
                tipList.add((Component)this.getTipArray(new Object[]{this.getText("stack_count_item"), ": "}).m_130940_(GOLD));
                tipList.add((Component)this.getTipArray(new Object[]{"-", this.tile.getStack().m_41786_()}));
            }
            this.renderComponentTooltip(pose, tipList, xAxis, yAxis);
        }
        if (this.isRender(tipX = this.getWidth() + 112, tipY = this.getHeight() + 7, mouseX, mouseY, 41, 13)) {
            xAxis = mouseX - this.getWidth();
            yAxis = mouseY - this.getHeight();
            this.renderTooltip(pose, (Component)this.getText("turkey_button").m_130940_(GOLD), xAxis, yAxis);
        }
        if (this.isRender(tipX = this.getWidth() + 115, tipY = this.getHeight() + 40, mouseX, mouseY, 36, 36)) {
            xAxis = mouseX - this.getWidth();
            yAxis = mouseY - this.getHeight();
            ArrayList<Component> tipList = new ArrayList<Component>();
            tipList.add((Component)this.getTipArray(new Object[]{this.getText("stack_count_item"), ": "}).m_130940_(GOLD));
            tipList.add((Component)this.getTipArray(new Object[]{"-", this.tile.getStack().m_41786_()}));
            this.renderComponentTooltip(pose, tipList, xAxis, yAxis);
        }
        tipX = this.getWidth() + 157;
        tipY = this.getHeight() + 7;
        if (this.data == 10 && this.isRender(tipX, tipY, mouseX, mouseY, 11, 76)) {
            float fluid = (float)this.tile.getFluidValue() * 0.001f;
            float maxFluid = (float)this.tile.getMaxFuildValue() * 0.001f;
            String par = " (" + this.tile.getFluidPercent() + ")";
            int xAxis2 = mouseX - this.getWidth();
            int yAxis2 = mouseY - this.getHeight();
            String tip = String.format("%,.1f", Float.valueOf(fluid)) + "B / " + String.format("%,.1f", Float.valueOf(maxFluid)) + "B" + par;
            this.renderTooltip(pose, (Component)this.getLabel(tip), xAxis2, yAxis2);
        }
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

