/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.menu.JuiceMakerMenu;
import sweetmagic.init.tile.sm.TileJuiceMaker;

public class GuiJuiceMaker
extends GuiSMBase<JuiceMakerMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_juicemaker.png");
    private final TileJuiceMaker tile;

    public GuiJuiceMaker(JuiceMakerMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(175, 184);
        this.tile = menu.tile;
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        int progress;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        if (this.tile.craftTime > 0) {
            progress = this.tile.getCraftProgress(22);
            pose.m_280218_(this.getTEX(), x + 99, y + 36, 211, 15, progress, 15);
        }
        if (!this.tile.isWaterEmpty()) {
            progress = this.tile.getWaterProgress(75);
            pose.m_280218_(this.getTEX(), x + 29, y + 94 - progress, 191, 76 - progress, 14, progress);
        }
    }

    @Override
    protected void m_280003_(GuiGraphics pose, int mouseX, int mouseY) {
        super.m_280003_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 28;
        int tipY = this.getHeight() + 18;
        if (!this.isRender(tipX, tipY, mouseX, mouseY, 15, 76)) {
            return;
        }
        int mf = this.tile.getFluidValue();
        int max = this.tile.getMaxFuildValue();
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        String tip = this.format(mf) + "mb / " + this.format(max) + "mb";
        this.renderTooltip(pose, (Component)this.getLabel(tip), xAxis, yAxis);
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

