/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.MFSpawnerMenu;
import sweetmagic.init.tile.sm.TileMFSpawner;

public class GuiMFSpawner
extends GuiSMBase<MFSpawnerMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_mfspawner.png");
    private final TileMFSpawner tile;

    public GuiMFSpawner(MFSpawnerMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.tile = menu.tile;
        this.setGuiSize(176, 178);
        SMButton.SMButtonTip tip = new SMButton.SMButtonTip("change_mob", -15, 20);
        this.addButtonMap(0, new SMButton(TEX, 158, 23, 176, 7, 11, 9));
        this.addButtonMap(1, new SMButton(TEX, 158, 32, 176, 16, 11, 9));
        this.addButtonMap(2, new SMButton(TEX, 158, 45, 176, 7, 11, 9, tip));
        this.addButtonMap(3, new SMButton(TEX, 158, 54, 176, 16, 11, 9, tip));
        this.addButtonMap(4, new SMButton(TEX, 91, 63, 176, 25, 14, 14, new SMButton.SMButtonTip("view_spawn", -18, 18)));
        this.addRenderTexList(new SMRenderTex(MISC, 12, 10, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(menu.tile, true)));
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int tipX = this.getWidth();
        int tipY = this.getHeight();
        this.drawFont(pose, (Component)this.getText("spawn_range", new Object[]{this.tile.getRange()}), 57.0f, tipX + 93, tipY + 27, 2868292, true);
        this.drawFont(pose, this.tile.getEntityName(), 60.0f, tipX + 93, tipY + 49, 2868292, true);
        int x = tipX + 57;
        int y = tipY + 82;
        float mX = x - mouseX;
        float mY = (float)(y - 30) - (float)mouseY;
        Quaternionf quat = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quat1 = new Quaternionf().rotateX((float)Math.PI / 180);
        quat.mul((Quaternionfc)quat1);
        LivingEntity entity = this.tile.getRenderEntity();
        float bodyRot = entity.f_20883_;
        float yRot = entity.m_146908_();
        float xRot = entity.m_146909_();
        float yHeadRotO = entity.f_20886_;
        float yHeadRot = entity.f_20885_;
        float maxXRot = Math.max(120.0f, Math.min(240.0f, 180.0f + mX));
        float maxXRot2 = Math.max(105.0f, Math.min(255.0f, 180.0f + mX));
        entity.f_20883_ = maxXRot;
        entity.m_146922_(maxXRot);
        entity.m_146926_(Math.max(-40.0f, Math.min(40.0f, -mY)));
        entity.f_20885_ = maxXRot2;
        entity.f_20886_ = maxXRot2;
        InventoryScreen.m_280432_((GuiGraphics)pose, (int)x, (int)y, (int)30, (Quaternionf)quat, (Quaternionf)quat1, (LivingEntity)entity);
        entity.f_20883_ = bodyRot;
        entity.m_146922_(yRot);
        entity.m_146926_(xRot);
        entity.f_20886_ = yHeadRotO;
        entity.f_20885_ = yHeadRot;
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

