/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.TagInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.ObMagiaMenu;
import sweetmagic.init.tile.sm.TileObMagia;

public class GuiObMagia
extends GuiSMBase<ObMagiaMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_obmagia.png");
    private final TileObMagia tile;
    private static final List<ItemStack> PAGE = ForgeRegistries.ITEMS.tags().getTag(TagInit.SM_PAGE).stream().map(Item::m_7968_).collect(Collectors.toList());
    private static final List<ItemStack> BASE = ForgeRegistries.ITEMS.tags().getTag(TagInit.SM_BASE).stream().map(Item::m_7968_).collect(Collectors.toList());

    public GuiObMagia(ObMagiaMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(219, 189);
        this.tile = menu.tile;
        SMButton.SMButtonTip buttonTip = new SMButton.SMButtonTip("", 30, 0, this.tile){

            public boolean isFlagText(TileObMagia tile) {
                return tile.canCraft;
            }

            @Override
            public String getTip() {
                return this.isFlagText(GuiObMagia.this.tile) ? "caraft_start" : "no_recipe";
            }
        };
        SMButton button = new SMButton(MISC, 137, 81, 114, 15, 32, 12, buttonTip){

            @Override
            public boolean isButtonRender() {
                return GuiObMagia.this.tile.canCraft;
            }
        };
        this.addButtonMap(0, button);
    }

    @Override
    protected void renderBGBase(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(pose, this.f_97735_ + 27, this.f_97736_, 0, 0, this.f_97726_ - 27, this.f_97727_);
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        if (!this.tile.canCraft) {
            pose.m_280218_(MISC, x + 137, y + 81, 20, 0, 32, 14);
        }
        this.blit(pose, x, y + 8, 228, 17, 27, 182);
        if (this.tile.craftTime > 0) {
            int progress = this.tile.getProgress(33);
            this.blit(pose, x + 132, y + 49, 193, 1, progress, 14);
        }
        this.renderSlotItem(((ObMagiaMenu)this.menu).baseSlot, this.getViewStack(BASE), pose);
        this.renderSlotItem(((ObMagiaMenu)this.menu).pageSlot, this.getViewStack(PAGE), pose);
        if (!this.tile.isCraft && this.tile.canCraft) {
            this.renderSlotItem(((ObMagiaMenu)this.menu).outSlot, this.tile.viewStack, pose, 0);
        }
    }

    @Override
    protected void m_280003_(GuiGraphics pose, int mouseX, int mouseY) {
        super.m_280003_(pose, mouseX, mouseY);
        ItemStack baseStack = this.getViewStack(BASE);
        ItemStack pageStack = this.getViewStack(PAGE);
        this.renderItemLabel(((ObMagiaMenu)this.menu).baseSlot, baseStack, pose, mouseX, mouseY, this.createTipList(baseStack, "slot_need"));
        this.renderItemLabel(((ObMagiaMenu)this.menu).pageSlot, pageStack, pose, mouseX, mouseY, this.createTipList(pageStack, "slot_need"));
        if (!this.tile.isCraft && this.tile.canCraft) {
            this.renderItemLabel(((ObMagiaMenu)this.menu).outSlot, this.tile.viewStack, pose, mouseX, mouseY, this.createTipList(this.tile.viewStack, "craft_out"));
        }
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

