/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import sweetmagic.api.iitem.IMagicBook;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.IRobe;
import sweetmagic.init.MenuInit;

public class SMBookMenu
extends RecipeBookMenu<CraftingContainer> {
    private final CraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer resultSlots = new ResultContainer();
    private final ContainerLevelAccess access;
    private final ItemStack stack;
    private final Player player;

    public SMBookMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, ContainerLevelAccess.m_39289_((Level)pInv.f_35978_.m_20193_(), (BlockPos)pInv.f_35978_.m_20183_()));
    }

    public SMBookMenu(int windowId, Inventory level) {
        this(windowId, level, ContainerLevelAccess.f_39287_);
    }

    public SMBookMenu(int windowId, Inventory inv, ContainerLevelAccess con) {
        super(MenuInit.bookMenu, windowId);
        int x;
        int y;
        this.access = con;
        this.player = inv.f_35978_;
        this.stack = this.player.m_21205_();
        this.m_38897_((Slot)new ResultSlot(inv.f_35978_, this.craftSlots, (Container)this.resultSlots, 0, 124, 65));
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.m_38897_(new Slot((Container)this.craftSlots, x + y * 3, 42 + x * 18, 46 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inv, x + y * 9 + 9, 8 + x * 18, 140 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)inv, x2, 8 + x2 * 18, 198));
        }
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu menu, Level world, Player player, CraftingContainer con, ResultContainer result) {
        CraftingRecipe recipe;
        if (world.m_5776_()) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        ItemStack stack = ItemStack.f_41583_;
        Optional opti = world.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)con, world);
        if (opti.isPresent() && result.m_40135_(world, sPlayer, (Recipe)(recipe = (CraftingRecipe)opti.get()))) {
            stack = recipe.m_5874_((Container)con, player.m_9236_().m_9598_());
        }
        result.m_6836_(0, stack);
        menu.m_150404_(0, stack);
        sPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(menu.f_38840_, menu.m_182425_(), 0, stack));
    }

    public void m_6199_(Container container) {
        this.access.m_39292_((par1, par2) -> SMBookMenu.slotChangedCraftingGrid((AbstractContainerMenu)this, par1, this.player, this.craftSlots, this.resultSlots));
    }

    public void m_5816_(StackedContents con) {
        this.craftSlots.m_5809_(con);
    }

    public void m_6650_() {
        this.craftSlots.m_6211_();
        this.resultSlots.m_6211_();
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> recipe) {
        return recipe.m_5818_((Container)this.craftSlots, this.player.m_9236_());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((par1, par2) -> this.m_150411_(player, (Container)this.craftSlots));
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return stack;
        }
        ItemStack stack1 = slot.m_7993_();
        stack = stack1.m_41777_();
        if (index == 0) {
            this.access.m_39292_((par1, par2) -> stack1.m_41720_().m_7836_(stack1, par1, player));
            if (!this.m_38903_(stack1, 10, 46, true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stack1, stack);
        } else if (index >= 10 && index < 46 ? !this.m_38903_(stack1, 1, 10, false) && (index < 37 ? !this.m_38903_(stack1, 37, 46, false) : !this.m_38903_(stack1, 10, 37, false)) : !this.m_38903_(stack1, 10, 46, false)) {
            return ItemStack.f_41583_;
        }
        if (stack1.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack1.m_41613_() == stack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack1);
        if (index == 0) {
            player.m_36176_(stack1, false);
        }
        return stack;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultSlots && super.m_5882_(stack, slot);
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return this.craftSlots.m_39347_();
    }

    public int m_6656_() {
        return this.craftSlots.m_39346_();
    }

    public int m_6653_() {
        return 10;
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int index) {
        return index != this.m_6636_();
    }

    public boolean m_6366_(Player player, int id) {
        switch (id) {
            case 0: {
                ItemStack robe = player.m_6844_(EquipmentSlot.CHEST);
                ((IRobe)robe.m_41720_()).openGui(player.m_9236_(), player, robe);
                break;
            }
            case 1: {
                ItemStack porch = player.m_6844_(EquipmentSlot.LEGS);
                ((IPorch)porch.m_41720_()).openGui(player.m_9236_(), player, porch);
                break;
            }
            case 2: {
                ItemStack hand = player.m_21205_();
                if (hand.m_41619_() || !(hand.m_41720_() instanceof IMagicBook)) break;
                ((IMagicBook)this.stack.m_41720_()).openGui(player.m_9236_(), player, this.stack);
            }
        }
        return true;
    }
}

