/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.antlr.v4.runtime.misc.NotNull;
import sweetmagic.init.MenuInit;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.slot.SMSlot;
import sweetmagic.init.tile.slot.SlotInput;
import sweetmagic.init.tile.sm.TileWandReconstruct;

public class WandReconstructMenu
extends BaseSMMenu {
    public final TileWandReconstruct tile;
    public List<Slot> subslotList = new ArrayList<Slot>();

    public WandReconstructMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, (TileWandReconstruct)MenuInit.getTile(TileWandReconstruct::new, pInv, data));
    }

    public WandReconstructMenu(int windowId, Inventory pInv, TileWandReconstruct tile) {
        super(MenuInit.wandReconstructMenu, windowId, pInv, tile);
        this.tile = tile;
        this.m_38897_((Slot)new SMSlot(this.tile.getInput(), 0, 51, 11, SlotInput.ISWAND));
        for (int x = 0; x < this.tile.getInvSize(); ++x) {
            this.subslotList.add(this.m_38897_((Slot)new WnadSlot(this.tile, this.tile.getSub(), x, 24 + x * 54, 22)));
        }
        this.m_38897_((Slot)new SMSlot(this.tile.getOutput(), 0, 51, 69, s -> false));
        this.setPInv(pInv, 52, 96, 0);
        this.setSlotSize(1 + this.tile.getInvSize() + 1);
    }

    public boolean m_6366_(Player player, int id) {
        if (this.tile.isCraft) {
            return false;
        }
        if (id > 15) {
            this.tile.subSelectId = id - 17;
        } else if (id > 0) {
            this.tile.mainSelectId = id - 2;
        } else {
            this.tile.craftStart(this.tile.getInputItem(), false);
        }
        this.tile.sendPKT();
        this.tile.clickButton();
        return true;
    }

    public class WnadSlot
    extends SMSlot {
        private final int index;
        public final TileWandReconstruct tile;

        public WnadSlot(TileWandReconstruct tile, IItemHandler handler, int index, int xPos, int yPos) {
            super(handler, index, xPos, yPos);
            this.tile = tile;
            this.index = index;
        }

        public boolean m_6659_() {
            return this.index == 0 && this.tile.mainSelectId != -1 || this.index == 1 && this.tile.subSelectId != -1;
        }

        @Override
        public boolean m_5857_(@NotNull ItemStack stack) {
            boolean isPlace = super.m_5857_(stack);
            if (this.index == 0) {
                return isPlace && stack.m_150930_(this.tile.getRequestStack(this.tile.mainSelectId).m_41720_());
            }
            return isPlace && stack.m_150930_(this.tile.getRequestStack(this.tile.subSelectId).m_41720_());
        }
    }
}

