/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import sweetmagic.api.iitem.IFood;
import sweetmagic.api.iitem.info.FoodInfo;
import sweetmagic.init.block.base.BaseCookBlock;
import sweetmagic.init.capability.icap.ICookingStatus;
import sweetmagic.init.tile.sm.TileAbstractSM;

public abstract class TileAbstractSMCook
extends TileAbstractSM {
    public boolean hasFork = false;
    private int foodAmount = 0;
    public Player player = null;
    private ItemStack foodStack = ItemStack.f_41583_;

    public TileAbstractSMCook(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract int getMaxCookTime();

    public abstract int getCookTime();

    public abstract void setCookTime(int var1);

    public abstract boolean isCook();

    public abstract boolean checkRecipe();

    public abstract void craftStart();

    public abstract void craftFinish();

    public abstract void clearInfo();

    public abstract List<ItemStack> getDropList();

    public void addCookTime() {
        this.setCookTime(this.getCookTime() + 1);
    }

    public boolean isFinishCook() {
        return this.getCookTime() >= this.getMaxCookTime();
    }

    public void setState(int data) {
        Block block = this.getBlock(this.m_58899_());
        if (block instanceof BaseCookBlock) {
            BaseCookBlock block2 = (BaseCookBlock)block;
            block2.setState(this.m_58904_(), this.m_58899_(), data);
        }
    }

    public int getCookData() {
        return (Integer)this.getState(this.m_58899_()).m_61143_((Property)BaseCookBlock.COOK);
    }

    public List<ItemStack> setCookQuality(Player player, List<ItemStack> stackList, int count) {
        float chance = this.getBaseChance();
        ArrayList<ItemStack> newStackList = new ArrayList<ItemStack>();
        HashMap<Item, Integer> qualityMap = new HashMap<Item, Integer>();
        FoodInfo info = null;
        for (ItemStack stack : stackList) {
            Item item = stack.m_41720_();
            if (!(item instanceof IFood)) {
                newStackList.add(stack);
                continue;
            }
            IFood food = (IFood)item;
            if (info == null) {
                info = new FoodInfo(stack);
            }
            if (qualityMap.get(item) != null) {
                food.setQualityValue(stack, (Integer)qualityMap.get(item));
            } else {
                int level = food.setQuality(this.m_58899_(), player, stack, chance);
                food.setQualityValue(stack, level);
                qualityMap.put(item, level);
            }
            newStackList.add(stack);
        }
        ItemStack food = (ItemStack)newStackList.get(0);
        if (!food.m_41619_() && food.m_41720_() instanceof IFood) {
            this.foodStack = food;
            this.foodAmount = count;
        }
        return newStackList;
    }

    public void getExpValue() {
        if (this.foodStack.m_41619_() || !(this.foodStack.m_41720_() instanceof IFood) || this.player == null) {
            return;
        }
        IFood.getExpValue(this.player, new FoodInfo(this.foodStack), this.foodAmount);
        ICookingStatus.sendPKT(this.player);
    }

    public abstract List<ItemStack> getCraftList();

    public float getBaseChance() {
        float chance = 0.0f;
        List<ItemStack> craftList = this.getCraftList();
        if (craftList.isEmpty()) {
            return chance;
        }
        for (ItemStack stack : craftList) {
            Item item = stack.m_41720_();
            if (!(item instanceof IFood)) continue;
            IFood food = (IFood)item;
            chance += (float)food.getQualityValue(stack) * 0.05f;
        }
        return chance;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("hasFork", this.hasFork);
        tag.m_128405_("foodAmount", this.foodAmount);
        tag.m_128365_("foodStack", (Tag)this.foodStack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.hasFork = tag.m_128471_("hasFork");
        this.foodAmount = tag.m_128451_("foodAmount");
        this.foodStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("foodStack"));
    }
}

