/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.api.iitem.info.AcceInfo;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.AccessoryTableMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileAccessoryTable
extends TileSMMagic {
    public int craftTime = 0;
    public int maxCraftTime = 10;
    public int maxMagiaFlux = 100000;
    public boolean isCraft = false;
    public ItemStack outStack = ItemStack.f_41583_;
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());
    protected final TileAbstractSM.StackHandler acceInv = new TileAbstractSM.MagiaHandler(this.getInvSize());
    protected final TileAbstractSM.StackHandler starInv = new TileAbstractSM.MagiaHandler(this.getInvSize());
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileAccessoryTable(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileAccessoryTable(BlockPos pos, BlockState state) {
        super(TileInit.accessoryProcessing, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.isCraft && this.tickTime % 30 == 12 && this.craftTime < this.maxCraftTime - 2) {
            this.playSound(pos, SoundInit.IRON, 0.25f, 1.0f);
        }
        if (this.tickTime % 10 != 0) {
            return;
        }
        if (this.isCraft) {
            if (this.craftTime++ >= this.maxCraftTime) {
                this.craftFinish();
            }
            this.sendPKT();
        }
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (!this.isCraft || this.tickTime % 30 != 12 || this.craftTime >= this.maxCraftTime - 3) {
            return;
        }
        this.craftParticle(world, pos, 0.45f, 0.0f);
        this.craftParticle(world, pos, 0.0f, 0.45f);
        this.craftParticle(world, pos, -0.45f, 0.0f);
        this.craftParticle(world, pos, 0.0f, -0.45f);
        float x = (float)pos.m_123341_() + 0.5f;
        float y = (float)pos.m_123342_() + 1.025f;
        float z = (float)pos.m_123343_() + 0.5f;
        for (int i = 0; i < 8; ++i) {
            float xSpeed = this.getRandFloat(0.1f);
            float ySpeed = this.getRandFloat(0.05f);
            float zSpeed = this.getRandFloat(0.1f);
            this.addParticle((ParticleOptions)ParticleInit.NORMAL, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public void craftParticle(Level world, BlockPos pos, float posX, float posZ) {
        float x = (float)pos.m_123341_() + 0.5f + posX;
        float y = (float)pos.m_123342_() + 1.025f;
        float z = (float)pos.m_123343_() + 0.5f + posZ;
        float xSpeed = -posX * 0.08f;
        float ySpeed = 0.0f;
        float zSpeed = -posZ * 0.08f;
        this.addParticle((ParticleOptions)ParticleInit.TWILIGHTLIGHT, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public boolean canCraft(int starCount) {
        ItemStack input = this.getInputItem();
        if (input.m_41619_()) {
            return false;
        }
        ItemStack sub = this.getAcceItem();
        if (sub.m_41619_()) {
            return false;
        }
        ItemStack out = this.getOutputItem();
        if (this.changeOutput && (!out.m_41619_() || input.m_41720_() != sub.m_41720_())) {
            return false;
        }
        AcceInfo info = new AcceInfo(input);
        int stackCount = info.getAcce().getStackCount(info);
        return stackCount <= starCount && stackCount * 10000 <= this.getMF();
    }

    public void craftStart() {
        ItemStack input = this.getInputItem();
        AcceInfo acceInfo = new AcceInfo(input);
        int stackCount = acceInfo.getAcce().getStackCount(acceInfo);
        acceInfo.getAcce().addStackCount(acceInfo);
        this.outStack = input.m_41777_();
        input.m_41774_(1);
        this.getAcceItem().m_41774_(1);
        this.isCraft = true;
        this.craftTime = 0;
        this.tickTime = 0;
        this.maxCraftTime = stackCount * 4;
        this.setMF(this.getMF() - stackCount * 10000);
        this.getStarItem().m_41774_(stackCount);
        this.sendPKT();
        this.clickButton();
    }

    public void craftFinish() {
        boolean isChange = this.changeOutput && this.getInputItem().m_41619_();
        ItemHelper.insertStack(isChange ? this.getInput() : this.getOutput(), this.outStack.m_41777_(), false);
        this.clearInfo();
        this.playSound(this.m_58899_(), SoundEvents.f_11671_, 0.1f, 1.0f);
    }

    public void clearInfo() {
        this.craftTime = 0;
        this.maxCraftTime = 10;
        this.isCraft = false;
        this.outStack = ItemStack.f_41583_;
        this.sendPKT();
    }

    public String getTip() {
        String tip = "";
        ItemStack input = this.getInputItem();
        ItemStack sub = this.getAcceItem();
        if (input.m_41619_() || sub.m_41619_()) {
            return "acce_noacce";
        }
        if (input.m_41720_() != sub.m_41720_()) {
            return "acce_noequal";
        }
        ItemStack star = this.getStarItem();
        AcceInfo inputInfo = new AcceInfo(input);
        int starCount = star.m_41613_();
        int stackCount = inputInfo.getAcce().getStackCount(inputInfo) + 1;
        if (star.m_41619_() || stackCount > starCount) {
            return "acce_nostar";
        }
        ItemStack out = this.getOutputItem();
        if (!out.m_41619_()) {
            return "acce_noempty";
        }
        return stackCount * 10000 > this.getMF() ? "acce_nomf" : tip;
    }

    @Override
    public int getInvSize() {
        return 1;
    }

    @Override
    public int getMaxStackSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 10000;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getAcce() {
        return this.acceInv;
    }

    public ItemStack getAcceItem() {
        return this.getAcce().getStackInSlot(0);
    }

    public IItemHandler getStar() {
        return this.starInv;
    }

    public ItemStack getStarItem() {
        return this.getStar().getStackInSlot(0);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutputItem() {
        return this.getOutput().getStackInSlot(0);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("acceInv", (Tag)this.acceInv.serializeNBT());
        tag.m_128365_("starInv", (Tag)this.starInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("maxCraftTime", this.maxCraftTime);
        tag.m_128365_("outPutStack", (Tag)this.outStack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setInv(this.inputInv, tag, "inputInv");
        this.setInv(this.acceInv, tag, "acceInv");
        this.setInv(this.starInv, tag, "starInv");
        this.setInv(this.outputInv, tag, "outputInv");
        this.isCraft = tag.m_128471_("isCraft");
        this.craftTime = tag.m_128451_("craftTime");
        this.maxCraftTime = tag.m_128451_("maxCraftTime");
        this.outStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("outPutStack"));
    }

    public void setInv(TileAbstractSM.StackHandler inv, CompoundTag tags, String name) {
        CompoundTag tag = tags.m_128469_(name);
        if (tag == null) {
            return;
        }
        inv.deserializeNBT(tag);
    }

    public int getProgress(int value) {
        return this.getProgress(value, this.craftTime, this.maxCraftTime);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AccessoryTableMenu(windowId, inv, this);
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getInputItem());
        this.addStackList(stackList, this.getAcceItem());
        this.addStackList(stackList, this.getStarItem());
        this.addStackList(stackList, this.getOutputItem());
        return stackList;
    }
}

