/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.AetherLamplightMenu;
import sweetmagic.init.tile.sm.TileAetherLanp;
import sweetmagic.init.tile.sm.TileMFTank;
import sweetmagic.init.tile.sm.TileSMMagic;

public class TileAetherLamplight
extends TileSMMagic {
    public int order = 0;
    public int selectId = -1;
    public int range = 12;
    public int maxMagiaFlux = 70000;
    private static final int MIN_RANGE = 1;
    private static final int MAX_RANGE = 64;
    public boolean isRangeView = false;
    public BlockOrder blockOrder = new BlockOrder();

    public TileAetherLamplight(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileAetherLamplight(BlockPos pos, BlockState state) {
        super(TileInit.aetheLamplight, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 20 == 0 && !this.isRSPower()) {
            if (this.tickTime % 40 == 0) {
                this.tickTime = 0;
            }
            this.roundMFTransmit();
        }
    }

    public void roundMFTransmit() {
        if (this.isMFEmpty()) {
            return;
        }
        Iterable<BlockPos> posList = this.getRangePos(this.m_58899_(), this.range);
        HashMap<Block, ArrayList<BlockTile>> posBlockMap = new HashMap<Block, ArrayList<BlockTile>>();
        for (BlockPos pos : posList) {
            TileSMMagic tile;
            BlockEntity blockEntity = this.getTile(pos);
            if (!(blockEntity instanceof TileSMMagic) || !(tile = (TileSMMagic)blockEntity).getReceive() || tile.isMaxMF() || tile instanceof TileAetherLamplight || tile instanceof TileAetherLanp || tile instanceof TileMFTank) continue;
            Block block = this.getBlock(pos);
            BlockTile bTile = new BlockTile(block, tile);
            ArrayList<BlockTile> tileMap = (ArrayList<BlockTile>)posBlockMap.get(block);
            if (tileMap == null || tileMap.isEmpty()) {
                tileMap = new ArrayList<BlockTile>();
                tileMap.add(bTile);
                posBlockMap.put(block, tileMap);
                continue;
            }
            tileMap.add(bTile);
        }
        BlockOrder blockOrder = this.blockOrder;
        ArrayList<Block> orderBlock = new ArrayList<Block>();
        if (!blockOrder.getBlockList().isEmpty()) {
            Map<Integer, List<Block>> orderBlockMap = blockOrder.getOrderBlockMap();
            List<Integer> orderNumerList = this.getOrderNumber();
            for (int order : orderNumerList) {
                List<Block> orderBlockList = orderBlockMap.get(order);
                if (order < 0) {
                    orderBlock.addAll(orderBlockList);
                    continue;
                }
                for (Block block : orderBlockList) {
                    List tileMap = (List)posBlockMap.get(block);
                    if (tileMap == null) continue;
                    for (BlockTile bTile : tileMap) {
                        this.insertMF(bTile.tile(), this, this.getTickTime());
                        orderBlock.add(bTile.block());
                        if (!this.isMFEmpty()) continue;
                        return;
                    }
                }
            }
            if (!this.isMFEmpty()) {
                for (List tileList : posBlockMap.values()) {
                    for (BlockTile bTile : tileList) {
                        if (orderBlock.contains(bTile.block())) continue;
                        this.insertMF(bTile.tile(), this, this.getTickTime());
                        if (!this.isMFEmpty()) continue;
                        return;
                    }
                }
            }
        } else {
            for (List tileList : posBlockMap.values()) {
                for (BlockTile bTile : tileList) {
                    this.insertMF(bTile.tile(), this, this.getTickTime());
                    if (!this.isMFEmpty()) continue;
                    return;
                }
            }
        }
        this.sendPKT();
    }

    public void addRange(int id) {
        int addValue = 0;
        switch (id) {
            case 0: {
                addValue = 1;
                break;
            }
            case 1: {
                addValue = 10;
                break;
            }
            case 2: {
                addValue = -1;
                break;
            }
            case 3: {
                addValue = -10;
                break;
            }
            case 6: {
                this.isRangeView = !this.isRangeView;
            }
        }
        this.range = Math.min(64, Math.max(1, this.range + addValue));
        this.clickButton();
        this.sendPKT();
    }

    public void addOrder(int id) {
        int addValue = 0;
        switch (id) {
            case 4: {
                addValue = 1;
                break;
            }
            case 5: {
                addValue = -1;
            }
        }
        this.order = Math.min(9, Math.max(-1, this.order + addValue));
        this.clickButton();
        this.sendPKT();
    }

    public void setOrder() {
        if (this.selectId == -1) {
            return;
        }
        this.blockOrder.registerMap(this.order, (Block)this.getRangeBlockSet().stream().toList().get(this.selectId));
        this.clickButton();
        this.sendPKT();
    }

    public void registerBlock() {
        if (this.selectId == -1) {
            return;
        }
        List<Block> blockList = this.getRangeBlockList();
        if (blockList.isEmpty() || this.selectId >= blockList.size()) {
            return;
        }
        this.blockOrder.registerMap(this.order, blockList.get(this.selectId));
    }

    public List<Block> getRangeBlockList() {
        ArrayList<Block> blockList = new ArrayList<Block>();
        Iterable<BlockPos> posList = this.getRangePos(this.m_58899_(), this.range);
        for (BlockPos pos : posList) {
            TileSMMagic tile;
            BlockEntity blockEntity = this.getTile(pos);
            if (!(blockEntity instanceof TileSMMagic) || !(tile = (TileSMMagic)blockEntity).getReceive() || tile instanceof TileAetherLamplight || tile instanceof TileAetherLanp || tile instanceof TileMFTank) continue;
            blockList.add(this.getBlock(pos));
        }
        return blockList;
    }

    public Set<Block> getRangeBlockSet() {
        LinkedHashSet<Block> blockList = new LinkedHashSet<Block>();
        LinkedHashSet<Block> orderBlockSet = new LinkedHashSet<Block>();
        List<Integer> orderNumerList = this.getOrderNumber();
        Iterable<BlockPos> posList = this.getRangePos(this.m_58899_(), this.range);
        for (BlockPos pos : posList) {
            TileSMMagic tile;
            BlockEntity blockEntity = this.getTile(pos);
            if (!(blockEntity instanceof TileSMMagic) || !(tile = (TileSMMagic)blockEntity).getReceive() || tile instanceof TileAetherLamplight || tile instanceof TileAetherLanp || tile instanceof TileMFTank) continue;
            blockList.add(this.getBlock(pos));
        }
        if (!orderNumerList.isEmpty()) {
            Integer order;
            List<Block> orderBlockList;
            Iterator<Object> iterator = orderNumerList.iterator();
            while (iterator.hasNext() && (orderBlockList = this.blockOrder.orderBlockMap.get(order = (Integer)iterator.next())) != null && !orderBlockList.isEmpty()) {
                for (Block block : blockList) {
                    if (!orderBlockList.contains(block)) continue;
                    orderBlockSet.add(block);
                }
            }
        }
        blockList.forEach(b -> orderBlockSet.add((Block)b));
        return orderBlockSet;
    }

    @Override
    public int getReceiveMF() {
        return 70000;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    public int getUserMF() {
        return 5000;
    }

    @Override
    public IItemHandler getInput() {
        return null;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("range", this.range);
        tag.m_128405_("order", this.order);
        tag.m_128405_("selectId", this.selectId);
        tag.m_128379_("isRangeView", this.isRangeView);
        this.saveBLockOrder(tag, this.blockOrder, "blockOrder");
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.range = tag.m_128451_("range");
        this.order = tag.m_128451_("order");
        this.selectId = tag.m_128451_("selectId");
        this.isRangeView = tag.m_128471_("isRangeView");
        this.blockOrder = this.loadBlockOrder(tag, "blockOrder");
    }

    public CompoundTag saveBLockOrder(CompoundTag nbt, BlockOrder blockOrder, String name) {
        if (blockOrder.getBlockList().isEmpty()) {
            return nbt;
        }
        ListTag tagsList = new ListTag();
        Map<Integer, List<Block>> orderMap = blockOrder.getOrderBlockMap();
        for (Map.Entry<Integer, List<Block>> map : orderMap.entrySet()) {
            CompoundTag tags = new CompoundTag();
            tags.m_128405_("order", map.getKey().intValue());
            ListTag tagsList2 = new ListTag();
            for (Block block : map.getValue()) {
                CompoundTag tags2 = new CompoundTag();
                tags2.m_128359_("blockId", ForgeRegistries.BLOCKS.getKey((Object)block).toString());
                tagsList2.add((Object)tags2);
            }
            tags.m_128365_("blockList", (Tag)tagsList2);
            tagsList.add((Object)tags);
        }
        nbt.m_128365_(name, (Tag)tagsList);
        return nbt;
    }

    public BlockOrder loadBlockOrder(CompoundTag nbt, String name) {
        BlockOrder blockOrder = new BlockOrder();
        for (Tag tag : nbt.m_128437_(name, 10)) {
            CompoundTag tags = (CompoundTag)tag;
            int order = tags.m_128451_("order");
            for (Tag tag2 : tags.m_128437_("blockList", 10)) {
                CompoundTag tags2 = (CompoundTag)tag2;
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tags2.m_128461_("blockId")));
                blockOrder.registerMap(order, block);
            }
        }
        return blockOrder;
    }

    public List<Integer> getOrderNumber() {
        List<Integer> orderList = new ArrayList<Integer>();
        Map<Integer, List<Block>> orderBlockMap = this.blockOrder.getOrderBlockMap();
        if (!orderBlockMap.isEmpty()) {
            orderList.addAll(orderBlockMap.keySet());
            orderList = orderList.stream().sorted((s1, s2) -> this.sortOrder((int)s1, (int)s2)).toList();
        } else {
            orderList.add(0);
        }
        return orderList;
    }

    public int sortOrder(int int1, int int2) {
        if (int1 > int2) {
            return -1;
        }
        if (int1 < int2) {
            return 1;
        }
        return 0;
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AetherLamplightMenu(windowId, inv, this);
    }

    @Override
    public boolean isInfoEmpty() {
        return this.blockOrder.getBlockList().isEmpty() && this.isMFEmpty();
    }

    public class BlockOrder {
        private List<Block> blockList = new ArrayList<Block>();
        private Map<Integer, List<Block>> orderBlockMap = new HashMap<Integer, List<Block>>();

        public void registerMap(int order, Block block) {
            List<Block> blockList;
            if (!this.orderBlockMap.isEmpty() && this.orderBlockMap.get(order) != null && this.orderBlockMap.get(order).contains(block)) {
                return;
            }
            for (Integer orderNum : this.orderBlockMap.keySet()) {
                List<Block> orderNumList = this.orderBlockMap.get(orderNum);
                if (!orderNumList.contains(block)) continue;
                orderNumList.removeIf(b -> b == block);
                break;
            }
            if ((blockList = this.orderBlockMap.get(order)) == null || blockList.isEmpty()) {
                blockList = new ArrayList<Block>();
                blockList.add(block);
                this.orderBlockMap.put(order, blockList);
            } else {
                blockList.add(block);
            }
            if (!this.blockList.contains(block)) {
                this.blockList.add(block);
            }
        }

        public List<Block> getBlockList() {
            return this.blockList;
        }

        public Map<Integer, List<Block>> getOrderBlockMap() {
            return this.orderBlockMap;
        }

        public int getBlockOrder(Block block) {
            if (!this.getBlockList().contains(block)) {
                return 0;
            }
            for (Map.Entry<Integer, List<Block>> map : this.getOrderBlockMap().entrySet()) {
                if (!map.getValue().contains(block)) continue;
                return map.getKey();
            }
            return 0;
        }
    }

    public record BlockTile(Block block, TileSMMagic tile) {
    }
}

