/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.AetherLanternMenu;
import sweetmagic.init.tile.sm.TileSMMagic;

public class TileAetherLanp
extends TileSMMagic {
    private static final int MIN_RANGE = 1;
    private static final int MAX_RANGE = 16;
    public int maxMagiaFlux = 20000;
    public int range = 12;
    public int mfInsert = 0;

    public TileAetherLanp(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileAetherLanp(BlockPos pos, BlockState state) {
        super(TileInit.aetherLanp, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 20 == 0 && !this.isRSPower()) {
            this.tickTime = 0;
            this.roundMFRecive();
        }
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.tickTime % 40 == 0 && !this.isMaxMF()) {
            this.tickTime = 0;
            this.roundMFEffect();
        }
    }

    public void roundMFRecive() {
        int sumMF = 0;
        Iterable<BlockPos> posList = this.getRangePosUnder(this.m_58899_(), this.getRange());
        for (BlockPos pos : posList) {
            TileSMMagic tile;
            BlockEntity blockEntity = this.getTile(pos);
            if (!(blockEntity instanceof TileSMMagic) || (tile = (TileSMMagic)blockEntity).getReceive()) continue;
            int oldMF = this.getMF();
            this.insertMF(this, tile, this.getTickTime());
            int newMF = this.getMF();
            sumMF += newMF - oldMF;
            if (!this.isMaxMF()) continue;
            break;
        }
        this.mfInsert = sumMF > 0 ? sumMF : 0;
        this.sendPKT();
    }

    public void roundMFEffect() {
        BlockPos pos = this.m_58899_();
        Iterable<BlockPos> posArray = this.getRangePosUnder(this.m_58899_(), this.getRange());
        for (BlockPos p : posArray) {
            TileSMMagic tile;
            BlockEntity blockEntity = this.getTile(p);
            if (!(blockEntity instanceof TileSMMagic) || (tile = (TileSMMagic)blockEntity).getReceive() || tile.isMFEmpty()) continue;
            float pX = pos.m_123341_() - p.m_123341_();
            float pY = pos.m_123342_() - p.m_123342_();
            float pZ = pos.m_123343_() - p.m_123343_();
            for (int i = 0; i < 2; ++i) {
                float randX = this.getRandFloat(0.5f);
                float randY = this.getRandFloat(0.5f);
                float randZ = this.getRandFloat(0.5f);
                float x = (float)p.m_123341_() + 0.5f + randX;
                float y = (float)p.m_123342_() + 0.525f + randY;
                float z = (float)p.m_123343_() + 0.5f + randZ;
                float xSpeed = pX * 0.1175f;
                float ySpeed = pY * 0.1175f;
                float zSpeed = pZ * 0.1175f;
                this.addParticle((ParticleOptions)ParticleInit.NORMAL, x, y, z, xSpeed, ySpeed, zSpeed);
            }
        }
    }

    public void addRange(int id) {
        int addValue = 0;
        switch (id) {
            case 0: {
                addValue = 1;
                break;
            }
            case 1: {
                addValue = 10;
                break;
            }
            case 2: {
                addValue = -1;
                break;
            }
            case 3: {
                addValue = -10;
            }
        }
        this.range = Math.min(16, Math.max(1, this.range + addValue));
        this.clickButton();
        this.sendPKT();
    }

    public int getRange() {
        return this.range;
    }

    @Override
    public int getReceiveMF() {
        return 5000;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public IItemHandler getInput() {
        return null;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("range", this.range);
        tag.m_128405_("mfInsert", this.mfInsert);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("range")) {
            this.range = tag.m_128451_("range");
        }
        this.mfInsert = tag.m_128451_("mfInsert");
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AetherLanternMenu(windowId, inv, this);
    }
}

