/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.crop.MagiaFlower;
import sweetmagic.init.tile.menu.AetherPlanterMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileAetherPlanter
extends TileSMMagic {
    public boolean isMaxGlow = false;
    public int maxMagiaFlux = 20000;
    public final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());
    public ItemStack stack = ItemStack.f_41583_;

    public TileAetherPlanter(BlockPos pos, BlockState state) {
        this(TileInit.aetherPlanter, pos, state);
    }

    public TileAetherPlanter(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, OUT);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 20 != 0 || this.isRSPower()) {
            return;
        }
        if (this.isMaxGlow && world instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)world;
            this.getCropStack(sever, pos);
        } else if (this.rand.nextFloat() <= 0.1f && this.getMF() >= this.getUserMF() && world instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)world;
            this.glowPlant(sever, pos);
        }
        if (this.tickTime % 40 == 0) {
            this.tickTime = 0;
            Block block = this.getBlock(pos.m_7494_());
            this.stack = block != Blocks.f_50016_ ? new ItemStack((ItemLike)block) : ItemStack.f_41583_;
            this.sendPKT();
        }
    }

    public void glowPlant(ServerLevel world, BlockPos pos) {
        BlockPos upPos = pos.m_7494_();
        BlockState upState = world.m_8055_(upPos);
        Block upBlock = upState.m_60734_();
        BlockPos upPos2 = pos.m_6630_(2);
        BlockState upState2 = world.m_8055_(upPos2);
        Block upBlock2 = upState2.m_60734_();
        boolean isGlow = this.glowPlant(world, upPos, upState, upBlock);
        if (!isGlow) {
            isGlow = this.glowPlant(world, upPos2, upState2, upBlock2);
        } else {
            this.glowPlant(world, upPos2, upState2, upBlock2);
        }
        if (isGlow) {
            this.setMF(this.getMF() - this.getUserMF());
            for (int i = 0; i < 4; ++i) {
                double x = (double)upPos.m_123341_() + this.rand.nextDouble();
                double y = (double)upPos.m_123342_() + this.rand.nextDouble() * 0.4 + 0.2;
                double z = (double)upPos.m_123343_() + this.rand.nextDouble();
                world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 5, 0.0, 0.0, 0.0, 0.25);
            }
        }
        this.sendPKT();
    }

    public boolean glowPlant(ServerLevel world, BlockPos upPos, BlockState upState, Block upBlock) {
        boolean isGlow = false;
        if (upBlock instanceof MushroomBlock) {
            isGlow = true;
            this.isMaxGlow = true;
        } else if (upBlock instanceof BambooStalkBlock) {
            BambooStalkBlock bam = (BambooStalkBlock)upBlock;
            isGlow = true;
            this.isMaxGlow = true;
        } else if (upBlock instanceof BonemealableBlock) {
            ISMCrop smCrop;
            BonemealableBlock crop = (BonemealableBlock)upBlock;
            if (crop.m_7370_((LevelReader)world, upPos, upState, true) || upBlock instanceof ISMCrop && !(smCrop = (ISMCrop)upBlock).isMaxAge(upState)) {
                crop.m_214148_(world, world.m_213780_(), upPos, upState);
                isGlow = true;
            } else {
                this.isMaxGlow = true;
            }
        } else if (upBlock instanceof MagiaFlower) {
            MagiaFlower flower = (MagiaFlower)upBlock;
            if (flower.isMaxAge(upState)) {
                this.isMaxGlow = true;
            } else {
                if (!flower.canGlow((Level)world, world.m_46468_() % 24000L < 12000L)) {
                    return isGlow;
                }
                flower.glowUp((Level)world, upState, upPos);
                isGlow = true;
                if (flower.isMaxAge(upState)) {
                    this.isMaxGlow = true;
                }
            }
        }
        return isGlow;
    }

    public void getCropStack(ServerLevel world, BlockPos pos) {
        Object crop;
        Object crop2;
        Object crop3;
        BlockPos upPos = pos.m_7494_();
        BlockState upState = world.m_8055_(upPos);
        Block upBlock = upState.m_60734_();
        BlockPos upPos2 = pos.m_6630_(2);
        BlockState upState2 = world.m_8055_(upPos2);
        Block upBlock2 = upState2.m_60734_();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        if (upBlock instanceof MushroomBlock) {
            stackList.add(new ItemStack((ItemLike)upBlock, this.rand.nextInt(2) + 1));
            world.m_7731_(upPos2, this.getNewState(upState2), 3);
        } else if (upBlock instanceof BambooStalkBlock) {
            stackList.addAll(Block.m_49869_((BlockState)upState, (ServerLevel)world, (BlockPos)upPos, (BlockEntity)world.m_7702_(upPos)));
        } else if (upBlock instanceof StemBlock && !(crop3 = (StemBlock)upBlock).m_7370_((LevelReader)world, upPos, upState, true)) {
            stackList.addAll(Block.m_49869_((BlockState)upState, (ServerLevel)world, (BlockPos)upPos, (BlockEntity)world.m_7702_(upPos)));
            stackList.add(new ItemStack((ItemLike)crop3.m_57056_()));
            world.m_7731_(upPos, this.getNewState(upState), 3);
        } else if (upBlock2 instanceof ISMCrop && (crop2 = (ISMCrop)upBlock2).isMaxAge(upState2)) {
            stackList.addAll(Block.m_49869_((BlockState)upState2, (ServerLevel)world, (BlockPos)upPos2, (BlockEntity)world.m_7702_(upPos2)));
            world.m_7731_(upPos2, this.getNewState(upState2), 3);
        } else if (upBlock2 instanceof BonemealableBlock && !(crop = (BonemealableBlock)upBlock2).m_7370_((LevelReader)world, upPos2, upState2, true)) {
            stackList.addAll(Block.m_49869_((BlockState)upState2, (ServerLevel)world, (BlockPos)upPos2, (BlockEntity)world.m_7702_(upPos2)));
            world.m_7731_(upPos2, this.getNewState(upState2), 3);
        }
        if (upBlock instanceof ISMCrop && (crop3 = (ISMCrop)upBlock).isMaxAge(upState)) {
            stackList.addAll(Block.m_49869_((BlockState)upState, (ServerLevel)world, (BlockPos)upPos, (BlockEntity)world.m_7702_(upPos)));
            world.m_7731_(upPos, this.getNewState(upState), 3);
        } else if (upBlock instanceof BonemealableBlock && !(crop2 = (BonemealableBlock)upBlock).m_7370_((LevelReader)world, upPos, upState, true)) {
            stackList.addAll(Block.m_49869_((BlockState)upState, (ServerLevel)world, (BlockPos)upPos, (BlockEntity)world.m_7702_(upPos)));
            world.m_7731_(upPos, this.getNewState(upState), 3);
        } else if (upBlock instanceof MagiaFlower) {
            crop = (MagiaFlower)upBlock;
            stackList.addAll(Block.m_49869_((BlockState)upState, (ServerLevel)world, (BlockPos)upPos, (BlockEntity)world.m_7702_(upPos)));
            world.m_7731_(upPos, this.getNewState(upState), 3);
        }
        if (!stackList.isEmpty()) {
            ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
            for (ItemStack stack : stackList) {
                ItemStack outStack = ItemHelper.insertStack(this.getInput(), stack.m_41777_(), false);
                if (outStack.m_41619_()) continue;
                dropList.add(outStack);
            }
            if (!dropList.isEmpty()) {
                stackList = dropList;
                return;
            }
        }
        this.isMaxGlow = false;
        this.playSound(upPos, SoundEvents.f_11838_, 1.0f, 0.9f + this.getRandFloat(0.15f));
        BlockParticleOption par = new BlockParticleOption(ParticleTypes.f_123794_, upState);
        for (int i = 0; i < 8; ++i) {
            world.m_8767_((ParticleOptions)par, (double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.25, (double)upPos.m_123343_() + 0.5, 0, (double)this.getRandFloat(0.25f), 0.0, (double)this.getRandFloat(0.25f), 1.0);
        }
        this.sendPKT();
    }

    public BlockState getNewState(BlockState oldState) {
        BlockState state = oldState.m_60734_().m_49966_();
        if (oldState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            state = (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)oldState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        }
        return state;
    }

    @Override
    public int getInvSize() {
        return 27;
    }

    @Override
    public int getReceiveMF() {
        return 5000;
    }

    public int getUserMF() {
        return 50;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public boolean isInvEmpty() {
        for (int i = 0; i < this.getInvSize(); ++i) {
            if (this.getInputItem(i).m_41619_()) continue;
            return false;
        }
        return this.isMFEmpty();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128379_("isMaxGlow", this.isMaxGlow);
        tag.m_128365_("wandStack", (Tag)this.stack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.isMaxGlow = tag.m_128471_("isMaxGlow");
        this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("wandStack"));
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AetherPlanterMenu(windowId, inv, this);
    }
}

