/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.magic.PedalCreate;
import sweetmagic.init.capability.SidItemHandler;
import sweetmagic.init.capability.icap.ICapabilityResolver;
import sweetmagic.init.tile.menu.AlstroemeriaAquariumMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.recipe.RecipeHelper;
import sweetmagic.recipe.alstrameria.AlstroemeriaRecipe;
import sweetmagic.util.ItemHelper;

public class TileAlstroemeriaAquarium
extends TileSMMagic {
    public int selectId = -1;
    public ItemStack resultStack = ItemStack.f_41583_;
    public List<ItemStack> mainStackList = new ArrayList<ItemStack>();
    public List<List<ItemStack>> subStackListList = new ArrayList<List<ItemStack>>();
    public int maxMagiaFlux = 50000;
    public boolean isCraft = false;
    public List<ItemStack> outStackList = new ArrayList<ItemStack>();
    protected final TileAbstractSM.StackHandler handInv = new AlstroemeriaHandler(this, 1, true);
    protected final TileAbstractSM.StackHandler inputInv = new AlstroemeriaHandler(this, 10, false);
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileAlstroemeriaAquarium(BlockPos pos, BlockState state) {
        this(TileInit.alstroemeriaAquarium, pos, state);
    }

    public TileAlstroemeriaAquarium(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = new SMHandlerProvider(this);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        int checkTime;
        super.serverTick(world, pos, state);
        int n = checkTime = this.isCraft ? 5 : 20;
        if (this.tickTime % checkTime != 0) {
            return;
        }
        if (this.isCraft) {
            this.craftFinish();
            this.sendPKT();
        }
        if (this.isCraft || this.getHandItem().m_41619_() || this.getMF() < this.getUseMF()) {
            return;
        }
        if (this.checkRecipe()) {
            this.craftStart();
        }
    }

    public List<ItemStack> getStackList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stackList.add(this.getHandItem());
        for (int i = 0; i < 10; ++i) {
            ItemStack stack = this.getInputItem(i);
            if (stack.m_41619_()) continue;
            stackList.add(stack);
        }
        return stackList;
    }

    public boolean checkRecipe() {
        List<ItemStack> stackList = this.getStackList();
        return !AlstroemeriaRecipe.getRecipe(this.m_58904_(), stackList).isEmpty();
    }

    public void craftStart() {
        BlockItem bItem;
        List<ItemStack> stackList = this.getStackList();
        AlstroemeriaRecipe recipe = AlstroemeriaRecipe.getRecipe(this.m_58904_(), stackList).get();
        if (!this.resultStack.m_41619_() && !recipe.getResultItem().m_150930_(this.resultStack.m_41720_())) {
            return;
        }
        RecipeHelper.RecipeUtil recipeUtil = RecipeHelper.recipeSingleCraft(stackList, recipe);
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>(recipeUtil.getResultList());
        ItemStack inputStack = recipeUtil.getInputList().get(0);
        Item item = inputStack.m_41720_();
        if (item instanceof BlockItem && (bItem = (BlockItem)item).m_40614_() instanceof PedalCreate) {
            CompoundTag tags = inputStack.m_41783_();
            ((ItemStack)resultList.get(0)).m_41751_(tags);
        }
        for (ItemStack result : resultList) {
            if (ItemHelper.insertStack(this.getOutput(), result, true).m_41619_()) continue;
            return;
        }
        this.outStackList = resultList;
        this.playSound(this.m_58899_(), SoundEvents.f_11929_, 0.5f, 1.0f / (this.rand.nextFloat() * 0.4f + 1.2f) + 0.5f);
        this.isCraft = true;
        this.setMF(this.getMF() - this.getUseMF());
    }

    public void craftFinish() {
        this.outStackList.forEach(s -> ItemHelper.insertStack(this.getOutput(), s.m_41777_(), false));
        this.clearInfo();
    }

    public void clearInfo() {
        this.isCraft = false;
        this.outStackList.clear();
    }

    public List<AlstroemeriaRecipe> getAlstroemeriaRecipeList() {
        ArrayList<AlstroemeriaRecipe> alstroemeriaRecipeList = new ArrayList<AlstroemeriaRecipe>();
        for (Recipe recipe : this.m_58904_().m_7465_().m_44051_()) {
            if (!(recipe instanceof AlstroemeriaRecipe)) continue;
            AlstroemeriaRecipe als = (AlstroemeriaRecipe)recipe;
            alstroemeriaRecipeList.add(als);
        }
        return alstroemeriaRecipeList.stream().sorted((s1, s2) -> ItemHelper.sortItemStack(s1.getResultItem(), s2.getResultItem())).toList();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("handInv", (Tag)this.handInv.serializeNBT());
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128365_("resultStack", (Tag)this.resultStack.m_41739_(new CompoundTag()));
        this.saveStackList(tag, this.outStackList, "outStackList");
        this.saveStackList(tag, this.mainStackList, "mainStackList");
        this.saveStackListList(tag, this.subStackListList, "subStackListList");
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.handInv.deserializeNBT(tag.m_128469_("handInv"));
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outputInv.deserializeNBT(tag.m_128469_("outputInv"));
        this.isCraft = tag.m_128471_("isCraft");
        this.resultStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("resultStack"));
        this.outStackList = this.loadAllStack(tag, "outStackList");
        this.mainStackList = this.loadAllStack(tag, "mainStackList");
        this.subStackListList = this.loadAllStackList(tag, "subStackListList");
    }

    @Override
    public int getReceiveMF() {
        return 10000;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    public int getUseMF() {
        return 10;
    }

    @Override
    public int getInvSize() {
        return 27;
    }

    public IItemHandler getHand() {
        return this.handInv;
    }

    public ItemStack getHandItem() {
        return this.getHand().getStackInSlot(0);
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutputItem(int i) {
        return this.getOutput().getStackInSlot(i);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AlstroemeriaAquariumMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public List<ItemStack> getInvList() {
        int i;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getHandItem());
        for (i = 0; i < 10; ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        for (i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getOutputItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }

    public class AlstroemeriaHandler
    extends TileAbstractSM.StackHandler {
        public final boolean isMainSlot;
        public final TileAlstroemeriaAquarium tile;

        public AlstroemeriaHandler(TileAlstroemeriaAquarium tile, int size, boolean isMainSlot) {
            super(size);
            this.tile = tile;
            this.isMainSlot = isMainSlot;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.isMainSlot) {
                ArrayList mainStack = new ArrayList();
                this.tile.mainStackList.forEach(s -> mainStack.add(s.m_41720_()));
                if (mainStack.isEmpty() || mainStack.contains(stack.m_41720_())) {
                    return super.insertItem(slot, stack, simulate);
                }
            } else if (this.tile.subStackListList.size() > slot) {
                ArrayList subItemList = new ArrayList();
                this.tile.subStackListList.get(slot).forEach(s -> subItemList.add(s.m_41720_()));
                if (subItemList.isEmpty() || subItemList.contains(stack.m_41720_())) {
                    return super.insertItem(slot, stack, simulate);
                }
            }
            return stack;
        }
    }

    private class SMHandlerProvider
    extends SidItemHandler {
        private final TileAlstroemeriaAquarium tile;
        private final ICapabilityResolver<IItemHandler> inRes;
        private final ICapabilityResolver<IItemHandler> handRes;
        private final ICapabilityResolver<IItemHandler> inAllRes;
        private final ICapabilityResolver<IItemHandler> outRes;

        protected SMHandlerProvider(TileAlstroemeriaAquarium tile) {
            this.inRes = this.getBasicResolver((NonNullSupplier<IItemHandler>)this.getHandler((IItemHandlerModifiable)TileAlstroemeriaAquarium.this.inputInv, IN));
            this.handRes = this.getBasicResolver((NonNullSupplier<IItemHandler>)this.getHandler((IItemHandlerModifiable)TileAlstroemeriaAquarium.this.handInv, IN));
            this.inAllRes = (TileAbstractSM)TileAlstroemeriaAquarium.this.new TileAbstractSM.InOutHandlerProvider(tile.createHand(new IItemHandlerModifiable[]{TileAlstroemeriaAquarium.this.handInv, TileAlstroemeriaAquarium.this.inputInv}), tile.createHand(new IItemHandlerModifiable[]{TileAlstroemeriaAquarium.this.outputInv}));
            this.outRes = this.getBasicResolver((NonNullSupplier<IItemHandler>)this.getHandler((IItemHandlerModifiable)TileAlstroemeriaAquarium.this.outputInv, OUT));
            this.tile = tile;
        }

        @Override
        protected ICapabilityResolver<IItemHandler> getResolver(@Nullable Direction face) {
            if (face == null) {
                return this.inRes;
            }
            if (this.tile.mainStackList.isEmpty()) {
                return switch (face) {
                    case Direction.UP -> this.handRes;
                    case Direction.DOWN -> this.outRes;
                    default -> this.inRes;
                };
            }
            return switch (face) {
                case Direction.DOWN -> this.outRes;
                default -> this.inAllRes;
            };
        }

        @Override
        public void invalidateAll() {
            this.inRes.invalidateAll();
            this.handRes.invalidateAll();
            this.outRes.invalidateAll();
        }
    }
}

