/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.TileInit;
import sweetmagic.init.item.sm.SMBook;
import sweetmagic.init.tile.menu.EnchantEduceMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileEnchantEduce
extends TileSMMagic {
    public boolean isCraft = false;
    public int nowLevel = 1;
    public int craftTime = 0;
    public int maxMagiaFlux = 100000;
    private static final int MAX_CRAFT_TIME = 20;
    public ItemStack outStack = ItemStack.f_41583_;
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(1);
    protected final TileAbstractSM.StackHandler pageInv = new TileAbstractSM.StackHandler(1, true);
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(1, true);
    protected final TileAbstractSM.StackHandler bookInv = new TileAbstractSM.StackHandler(1, true){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public TileEnchantEduce(BlockPos pos, BlockState state) {
        this(TileInit.enchantEduce, pos, state);
    }

    public TileEnchantEduce(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputInv, (IItemHandlerModifiable)this.outputInv);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.tickTime % 10 != 0) {
            return;
        }
        if (this.tickTime >= 20) {
            this.tickTime = 0;
        }
        if (this.isCraft) {
            if (this.craftTime++ >= 20) {
                this.craftFinish();
            }
            this.sendPKT();
        } else if (this.getNowLevel() > 1 && this.getBookItem().m_41619_()) {
            this.nowLevel = 1;
            this.sendPKT();
        }
    }

    public void craftStart(int buttonId) {
        CompoundTag compoundtag;
        ItemStack magicBook = this.getBookItem();
        if (magicBook.m_41619_()) {
            return;
        }
        int needMF = this.getEnchantCost(buttonId, (SMBook)magicBook.m_41720_());
        if (this.getMF() < needMF) {
            return;
        }
        ItemStack book = this.getInputItem();
        if (book.m_41619_()) {
            return;
        }
        ItemStack page = this.getPageItem();
        if (page.m_41619_()) {
            return;
        }
        if (!this.getOutItem().m_41619_()) {
            return;
        }
        boolean isBook = book.m_150930_(Items.f_42517_);
        ItemStack enchaBook = isBook ? new ItemStack((ItemLike)Items.f_42690_) : book.m_41777_();
        Enchantment encha = this.getEnchant(buttonId);
        if (encha == null) {
            return;
        }
        if (isBook && (compoundtag = book.m_41783_()) != null) {
            enchaBook.m_41751_(compoundtag.m_6426_());
        }
        enchaBook.m_41764_(1);
        book.m_41774_(1);
        page.m_41774_(1);
        this.setMF(this.getMF() - needMF);
        int level = Math.min(encha.m_6586_(), this.getNowLevel());
        if (isBook) {
            this.addEnchantment(enchaBook, new EnchantmentInstance(encha, level));
        } else {
            enchaBook.m_41663_(encha, level);
        }
        this.outStack = enchaBook;
        this.isCraft = true;
        this.sendPKT();
        this.clickButton();
    }

    public void craftFinish() {
        boolean isChange = this.changeOutput && this.getInputItem().m_41619_();
        ItemHelper.insertStack(isChange ? this.getInput() : this.getOutput(), this.outStack, false);
        this.playSound(this.m_58899_(), SoundEvents.f_11887_, 0.25f, 1.0f);
        this.clearInfo();
    }

    public Enchantment getEnchant(int buttonId) {
        List<Enchantment> enchaList = this.getEnchaList();
        if (buttonId >= enchaList.size() || enchaList.isEmpty()) {
            return null;
        }
        return enchaList.get(buttonId);
    }

    public List<Enchantment> getEnchaList() {
        ItemStack stack = this.getInputItem().m_41777_();
        ArrayList<Enchantment> enchaList = new ArrayList<Enchantment>();
        if (stack.m_41619_()) {
            return enchaList;
        }
        boolean isEnchaBook = stack.m_150930_(Items.f_42690_);
        boolean flag = stack.m_150930_(Items.f_42517_) || isEnchaBook;
        ItemStack copy = isEnchaBook ? new ItemStack((ItemLike)Items.f_42517_) : stack;
        List<Enchantment> stackEncha = this.stackEnchaList(stack);
        for (Enchantment encha : BuiltInRegistries.f_256876_) {
            if (encha.m_6591_() || !encha.m_6592_() || !encha.canApplyAtEnchantingTable(copy) && (!flag || !encha.isAllowedOnBooks()) || stackEncha.contains(encha)) continue;
            enchaList.add(encha);
        }
        if (flag && !stackEncha.contains(Enchantments.f_44962_)) {
            enchaList.add(Enchantments.f_44962_);
        }
        return enchaList;
    }

    public List<Enchantment> stackEnchaList(ItemStack stack) {
        ListTag listTag = stack.m_41785_();
        ArrayList<Enchantment> enchaList = new ArrayList<Enchantment>();
        if (!listTag.isEmpty()) {
            listTag.forEach(t -> enchaList.add((Enchantment)BuiltInRegistries.f_256876_.m_6612_(this.getEnchantId(this.getTag((Tag)t))).get()));
        }
        return enchaList;
    }

    public int getEnchantCost(int id, SMBook book) {
        List<Enchantment> enchaList = this.getEnchaList();
        if (enchaList.isEmpty() || id >= enchaList.size()) {
            return 0;
        }
        Enchantment encha = enchaList.get(id);
        if (encha.equals(Enchantments.f_44962_)) {
            return this.getMaxMF();
        }
        int maxLevel = encha.m_6586_();
        int rate = 6 - Math.min(maxLevel, 5);
        int addRate = maxLevel > 1 ? this.getNowLevel() : 1;
        return (11 - encha.m_44699_().m_44716_()) * 150 * rate * rate * addRate;
    }

    @Nullable
    public ResourceLocation getEnchantId(CompoundTag id) {
        return ResourceLocation.m_135820_((String)id.m_128461_("id"));
    }

    public void addEnchantment(ItemStack stack, EnchantmentInstance encha) {
        boolean flag = true;
        ListTag listtag = this.getEnchantments(stack);
        ResourceLocation src = EnchantmentHelper.m_182432_((Enchantment)encha.f_44947_);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag tag = listtag.m_128728_(i);
            ResourceLocation src1 = EnchantmentHelper.m_182446_((CompoundTag)tag);
            if (src1 == null || !src1.equals((Object)src)) continue;
            if (EnchantmentHelper.m_182438_((CompoundTag)tag) < encha.f_44948_) {
                EnchantmentHelper.m_182440_((CompoundTag)tag, (int)encha.f_44948_);
            }
            flag = false;
            break;
        }
        if (flag) {
            listtag.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)src, (int)encha.f_44948_));
        }
        stack.m_41784_().m_128365_("StoredEnchantments", (Tag)listtag);
    }

    public ListTag getEnchantments(ItemStack stack) {
        CompoundTag tags = stack.m_41783_();
        return tags != null ? tags.m_128437_("StoredEnchantments", 10) : new ListTag();
    }

    public void clickLevelButton(int id) {
        ItemStack stack = this.getBookItem();
        if (stack.m_41619_()) {
            return;
        }
        int tier = this.getPageCount(stack);
        int minLevel = this.getMinLevel();
        int maxLevel = this.getMaxLevel(tier);
        if (id == 1 && this.getNowLevel() > minLevel) {
            --this.nowLevel;
        } else if (id == 0 && maxLevel > this.getNowLevel()) {
            ++this.nowLevel;
        } else {
            return;
        }
        this.clickButton();
        this.sendPKT();
    }

    public void clearInfo() {
        this.isCraft = false;
        this.craftTime = 0;
        this.outStack = ItemStack.f_41583_;
        this.sendPKT();
    }

    public int getMinLevel() {
        return 1;
    }

    public int getMaxLevel(int tier) {
        return tier + 1;
    }

    public int getNowLevel() {
        return this.nowLevel;
    }

    public int getPageCount(ItemStack magicBook) {
        SMBook smBook = (SMBook)magicBook.m_41720_();
        return smBook.getTier();
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 10000;
    }

    @Override
    public int getInvSize() {
        return 5;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("bookInv", (Tag)this.bookInv.serializeNBT());
        tag.m_128365_("pageInv", (Tag)this.pageInv.serializeNBT());
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("nowLevel", this.nowLevel);
        tag.m_128365_("outPutStack", (Tag)this.outStack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.bookInv.deserializeNBT(tag.m_128469_("bookInv"));
        this.pageInv.deserializeNBT(tag.m_128469_("pageInv"));
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outputInv.deserializeNBT(tag.m_128469_("outputInv"));
        this.isCraft = tag.m_128471_("isCraft");
        this.craftTime = tag.m_128451_("craftTime");
        this.nowLevel = tag.m_128451_("nowLevel");
        this.outStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("outPutStack"));
    }

    public IItemHandler getBook() {
        return this.bookInv;
    }

    public ItemStack getBookItem() {
        return this.getBook().getStackInSlot(0);
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getPage() {
        return this.pageInv;
    }

    public ItemStack getPageItem() {
        return this.getPage().getStackInSlot(0);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutItem() {
        return this.getOutput().getStackInSlot(0);
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, 20);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new EnchantEduceMenu(windowId, inv, this);
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getInputItem());
        this.addStackList(stackList, this.getOutItem());
        this.addStackList(stackList, this.getPageItem());
        this.addStackList(stackList, this.getBookItem());
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

