/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.iblock.ITileFluid;
import sweetmagic.api.iitem.IFood;
import sweetmagic.init.ItemInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.fluid.FluidTankHandler;
import sweetmagic.init.item.sm.SMBucket;
import sweetmagic.init.tile.menu.FreezerMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.recipe.feezer.FreezerRecipe;
import sweetmagic.util.ItemHelper;

public class TileFreezer
extends TileAbstractSM
implements ITileFluid {
    private static final int MAX_CRAFT_TIME = 6;
    public int craftTime = 0;
    public boolean isCraft = false;
    public Player player = null;
    public ItemStack outStack = ItemStack.f_41583_;
    public List<ItemStack> craftList = new ArrayList<ItemStack>();
    private static final int MAX_WATER_VALUE = 10000;
    private final int useWaterValue = 250;
    protected final FluidTankHandler.TankProperty fluidPro;
    public FluidStack fluid = new FluidStack(Fluids.f_76191_, 0);
    public LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.createFluidHandler());
    private static final ItemStack ICE = new ItemStack((ItemLike)Blocks.f_50126_);
    protected final TileAbstractSM.StackHandler handInv = new TileAbstractSM.StackHandler(1);
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(this.getOutSize());
    protected final TileAbstractSM.StackHandler bucketInv = new TileAbstractSM.StackHandler(1);
    protected final TileAbstractSM.StackHandler iceInv = new TileAbstractSM.StackHandler(2);

    public TileFreezer(BlockPos pos, BlockState state) {
        this(TileInit.freezer, pos, state);
    }

    public TileFreezer(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidPro = new FluidTankHandler.TankProperty(10000, true, false, f -> f.m_6212_((Fluid)Fluids.f_76193_));
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider(this.createHand(new IItemHandlerModifiable[]{this.inputInv}), this.createHand(new IItemHandlerModifiable[]{this.outputInv, this.iceInv}));
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.tickTime % 10 != 0) {
            return;
        }
        this.insertWater();
        if (this.tickTime >= 20) {
            this.tickTime = 0;
            if (this.isNeedWater()) {
                this.craftIce();
            }
        }
        if (this.isCraft) {
            if (this.craftTime++ >= 6) {
                this.craftFinish();
            }
            this.sendPKT();
        }
        if (this.isCraft || this.getHandItem().m_41619_()) {
            return;
        }
        if (this.checkRecipe()) {
            this.craftStart();
        }
    }

    public List<ItemStack> getStackList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stackList.add(this.getHandItem());
        for (int i = 0; i < this.getInvSize(); ++i) {
            ItemStack stack = this.getInputItem(i);
            if (stack.m_41619_()) continue;
            stackList.add(stack);
        }
        return stackList;
    }

    public boolean checkRecipe() {
        return !FreezerRecipe.getRecipe(this.m_58904_(), this.getStackList()).isEmpty();
    }

    public void craftStart() {
        List<ItemStack> stackList = this.getStackList();
        FreezerRecipe recipe = FreezerRecipe.getRecipe(this.m_58904_(), stackList).get();
        ItemStack resultStack = recipe.getResultItem().m_41777_();
        if (!ItemHelper.insertStack(this.getOutput(), resultStack, true).m_41619_()) {
            return;
        }
        this.craftList = new ArrayList<ItemStack>(recipe.getRequestList());
        List<ItemStack> requestList = recipe.getRequestList();
        this.outStack = this.player != null ? this.setCookQuality(this.player, resultStack) : resultStack;
        block0: for (int count = 0; count < requestList.size(); ++count) {
            ItemStack request = requestList.get(count);
            if (count == 0) {
                stackList.get(0).m_41774_(request.m_41613_());
                continue;
            }
            for (int i = 1; i < stackList.size(); ++i) {
                ItemStack stack = stackList.get(i);
                if (!request.m_150930_(stack.m_41720_())) continue;
                stack.m_41774_(request.m_41613_());
                continue block0;
            }
        }
        this.isCraft = true;
    }

    public void craftFinish() {
        ItemHelper.insertStack(this.getOutput(), this.outStack, false);
        this.playSound(this.m_58899_(), SoundInit.FREEZER_CRAFT, 0.1f, 1.0f);
        this.clearInfo();
    }

    public void insertWater() {
        FluidStack fluid;
        SMBucket bk;
        Item item;
        ItemStack bucket = this.getBucketItem();
        if (bucket.m_41619_()) {
            return;
        }
        int insertWaterValue = 0;
        ItemStack copy = bucket.m_41777_();
        if (bucket.m_150930_(Items.f_42447_)) {
            insertWaterValue = 1000;
        } else if (bucket.m_150930_(ItemInit.watercup)) {
            insertWaterValue = 250;
        } else if (bucket.m_150930_(ItemInit.alt_bucket_water) && (item = bucket.m_41720_()) instanceof SMBucket) {
            bk = (SMBucket)item;
            fluid = bk.getFluidStack(bucket);
            insertWaterValue = Math.min(1000, fluid.getAmount());
        }
        if (insertWaterValue <= 0 || !this.canInsertWater(insertWaterValue)) {
            return;
        }
        if (this.getContent().isEmpty()) {
            this.setContent(new FluidStack((Fluid)Fluids.f_76193_, insertWaterValue));
        } else {
            this.setAmount(this.getFluidValue() + insertWaterValue);
        }
        this.sendPKT();
        if (bucket.m_150930_(ItemInit.alt_bucket_water) && (fluid = bucket.m_41720_()) instanceof SMBucket) {
            bk = (SMBucket)fluid;
            fluid = bk.getFluidStack(bucket);
            fluid.shrink(insertWaterValue);
            bk.saveFluid(bucket, fluid);
            if (fluid.isEmpty() || fluid.getAmount() <= 0) {
                bucket.m_41774_(1);
                ItemHelper.insertStack(this.getBucket(), new ItemStack((ItemLike)ItemInit.alt_bucket), false);
            }
        } else {
            bucket.m_41774_(1);
        }
        if (copy.m_150930_(Items.f_42447_)) {
            ItemHelper.insertStack(this.getBucket(), new ItemStack((ItemLike)Items.f_42446_), false);
        }
    }

    public void craftIce() {
        if (!ItemHelper.insertStack(this.getIce(), ICE.m_41777_(), true).m_41619_()) {
            return;
        }
        ItemHelper.insertStack(this.getIce(), ICE.m_41777_(), false);
        this.setAmount(this.getFluidValue() - this.useWaterValue);
        this.sendPKT();
    }

    public ItemStack setCookQuality(Player player, ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof IFood)) {
            return stack;
        }
        IFood food = (IFood)item;
        float chance = this.getBaseChance();
        int level = food.setQuality(this.m_58899_(), player, stack, chance);
        food.setQualityValue(stack, level);
        return stack;
    }

    public float getBaseChance() {
        float chance = 0.0f;
        List<ItemStack> craftList = this.craftList;
        if (craftList.isEmpty()) {
            return chance;
        }
        for (ItemStack stack : craftList) {
            Item item = stack.m_41720_();
            if (!(item instanceof IFood)) continue;
            IFood food = (IFood)item;
            chance += (float)food.getQualityValue(stack) * 0.05f;
        }
        return chance;
    }

    public void clearInfo() {
        this.craftTime = 0;
        this.isCraft = false;
        this.outStack = ItemStack.f_41583_;
        this.craftList.clear();
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getDropList().isEmpty();
    }

    public List<ItemStack> getDropList() {
        int i;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getBucketItem());
        this.addStackList(stackList, this.getHandItem());
        for (i = 0; i < 2; ++i) {
            this.addStackList(stackList, this.getIceItem(i));
        }
        for (i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        for (i = 0; i < this.getOutSize(); ++i) {
            this.addStackList(stackList, this.getOutputItem(i));
        }
        stackList.addAll(this.craftList);
        return stackList;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("bucketInv", (Tag)this.bucketInv.serializeNBT());
        tag.m_128365_("iceInv", (Tag)this.iceInv.serializeNBT());
        tag.m_128365_("handInv", (Tag)this.handInv.serializeNBT());
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128405_("craftTime", this.craftTime);
        this.saveStackList(tag, this.craftList, "craftList");
        tag.m_128365_("outPutStack", (Tag)this.outStack.m_41739_(new CompoundTag()));
        CompoundTag fluidNBT = new CompoundTag();
        this.getContent().writeToNBT(fluidNBT);
        tag.m_128365_("fluid", (Tag)fluidNBT);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.bucketInv.deserializeNBT(tag.m_128469_("bucketInv"));
        this.iceInv.deserializeNBT(tag.m_128469_("iceInv"));
        this.handInv.deserializeNBT(tag.m_128469_("handInv"));
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outputInv.deserializeNBT(tag.m_128469_("outputInv"));
        this.isCraft = tag.m_128471_("isCraft");
        this.craftTime = tag.m_128451_("craftTime");
        this.craftList = this.loadAllStack(tag, "craftList");
        this.outStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("outPutStack"));
        this.setContent(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("fluid")));
        if (tag.m_128441_("waterValue")) {
            this.setContent(new FluidStack((Fluid)Fluids.f_76193_, tag.m_128451_("waterValue")));
            tag.m_128473_("waterValue");
        }
    }

    @Override
    public int getInvSize() {
        return 6;
    }

    public int getOutSize() {
        return 4;
    }

    public IItemHandler getHand() {
        return this.handInv;
    }

    public ItemStack getHandItem() {
        return this.getHand().getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutputItem(int i) {
        return this.getOutput().getStackInSlot(i);
    }

    public IItemHandler getBucket() {
        return this.bucketInv;
    }

    public ItemStack getBucketItem() {
        return this.getBucket().getStackInSlot(0);
    }

    public IItemHandler getIce() {
        return this.iceInv;
    }

    public ItemStack getIceItem(int i) {
        return this.getIce().getStackInSlot(i);
    }

    public boolean isNeedWater() {
        return this.getFluidValue() >= this.useWaterValue;
    }

    public boolean canInsertWater(int insertWaterValue) {
        return this.getFluidValue() + insertWaterValue <= this.getMaxFuildValue();
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, 6);
    }

    public int getWaterProgress(int value) {
        return this.getProgress(value, this.getFluidValue(), this.getMaxFuildValue());
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new FreezerMenu(windowId, inv, this);
    }

    @Override
    public int fluidTanks() {
        return 1;
    }

    @Override
    public IFluidHandler createFluidHandler() {
        return new FluidTankHandler(this);
    }

    @Override
    public void setContent(FluidStack fluid) {
        this.fluid = fluid;
        this.m_6596_();
    }

    @Override
    public FluidTankHandler.TankProperty getTank() {
        return this.fluidPro;
    }

    @Override
    public FluidStack getContent() {
        return this.fluid;
    }

    @Override
    public void setAmount(int amount) {
        this.fluid.setAmount(amount);
    }

    @Override
    public int getFluidValue() {
        return this.getContent().getAmount();
    }

    @Override
    public int getMaxFuildValue() {
        return 10000;
    }

    @Override
    public void sendData() {
        this.sendInfo();
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction face) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.getFluidHandler();
        }
        return super.getCapability(cap, face);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getFluidHandler() != null) {
            this.getFluidHandler().invalidate();
        }
    }
}

