/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.FurnitureTableMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.util.ItemHelper;

public class TileFurnitureTable
extends TileAbstractSM {
    public boolean isCraft = false;
    public ItemStack inputStack = ItemStack.f_41583_;
    public ItemStack outStack = ItemStack.f_41583_;
    public int selectId = 0;
    public boolean isSelect = false;
    public int setCount = 1;
    public int oldSetCount = 1;
    public boolean isSetCount = false;
    public boolean isUpdate = false;
    public final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(1);
    public final TileAbstractSM.StackHandler inputSideInv = new TileAbstractSM.StackHandler(9);
    public final TileAbstractSM.StackHandler resultInv = new TileAbstractSM.StackHandler(1);
    public final TileAbstractSM.StackHandler outInv = new TileAbstractSM.StackHandler(this.getInvSize(), true);

    public TileFurnitureTable(BlockPos pos, BlockState state) {
        super(TileInit.furnitureTable, pos, state);
    }

    public TileFurnitureTable(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputSideInv, (IItemHandlerModifiable)this.outInv);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (!this.isCraft || this.tickTime % 2 != 0) {
            return;
        }
        if (this.getInputItem().m_41619_()) {
            this.tickTime = 0;
            this.isCraft = false;
            this.outStack = ItemStack.f_41583_;
            this.sendPKT();
        } else {
            this.craftFinish();
            if (this.tickTime % 4 == 0) {
                this.playSound(pos, SoundEvents.f_12494_, 0.5f, 1.0f);
            }
        }
    }

    public void insertInput() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.getInputSideItem(i);
            if (stack.m_41619_()) continue;
            ItemStack out = ItemHelper.insertStack(this.getInput(), stack.m_41777_(), false);
            stack.m_41774_(stack.m_41613_() - out.m_41613_());
        }
    }

    public void chekcSlot() {
        if (this.getInputItem().m_41619_() && this.setCount > 0) {
            this.setCount = 1;
            this.sendPKT();
        }
    }

    public void craftStart() {
        this.tickTime = 0;
        this.isCraft = true;
        this.sendPKT();
    }

    public void craftFinish() {
        ItemStack input = this.getInputItem();
        ItemStack out = this.outStack.m_41777_();
        CompoundTag tags = input.m_41783_();
        if (out.m_41619_() || !input.m_150930_(this.inputStack.m_41720_())) {
            this.isCraft = false;
            this.sendPKT();
        }
        if (tags != null) {
            out.m_41751_(tags);
        }
        int outCount = out.m_41613_();
        int count = Math.min(64, Math.min(input.m_41613_() * outCount, this.setCount));
        out.m_41764_(count);
        int shrinkCount = out.m_41613_();
        if (!ItemHelper.insertStack(this.getOut(), out, true).m_41619_()) {
            this.isCraft = false;
            return;
        }
        ItemHelper.insertStack(this.getOut(), out, false);
        input.m_41774_(count / outCount);
        this.setCount -= shrinkCount;
        this.insertInput();
        this.sendPKT();
        if (this.getInputItem().m_41619_() || !this.getInputItem().m_150930_(this.inputStack.m_41720_()) || this.setCount <= 0) {
            this.tickTime = 0;
            this.isCraft = false;
            this.selectId = 0;
            this.setCount = 1;
            this.isSelect = false;
            this.outStack = ItemStack.f_41583_;
            this.sendPKT();
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("inputSideInv", (Tag)this.inputSideInv.serializeNBT());
        tag.m_128365_("resultInv", (Tag)this.resultInv.serializeNBT());
        tag.m_128365_("outInv", (Tag)this.outInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128379_("isSelect", this.isSelect);
        tag.m_128379_("isSetCount", this.isSetCount);
        tag.m_128379_("isUpdate", this.isUpdate);
        tag.m_128405_("selectId", this.selectId);
        tag.m_128405_("setCount", this.setCount);
        tag.m_128405_("oldSetCount", this.oldSetCount);
        tag.m_128365_("outPutStack", (Tag)this.outStack.m_41739_(new CompoundTag()));
        tag.m_128365_("inputStack", (Tag)this.inputStack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        if (tag.m_128441_("inputSideInv")) {
            this.inputSideInv.deserializeNBT(tag.m_128469_("inputSideInv"));
        }
        this.resultInv.deserializeNBT(tag.m_128469_("resultInv"));
        this.outInv.deserializeNBT(tag.m_128469_("outInv"));
        this.isCraft = tag.m_128471_("isCraft");
        this.isSelect = tag.m_128471_("isSelect");
        this.isSetCount = tag.m_128471_("isSetCount");
        this.isUpdate = tag.m_128471_("isUpdate");
        this.selectId = tag.m_128451_("selectId");
        this.setCount = tag.m_128451_("setCount");
        this.oldSetCount = tag.m_128451_("oldSetCount");
        this.outStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("outPutStack"));
        this.inputStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("inputStack"));
    }

    @Override
    public int getInvSize() {
        return 27;
    }

    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getInputSide() {
        return this.inputSideInv;
    }

    public ItemStack getInputSideItem(int i) {
        return this.getInputSide().getStackInSlot(i);
    }

    public IItemHandler getResult() {
        return this.resultInv;
    }

    public ItemStack getResultItem() {
        return this.getResult().getStackInSlot(0);
    }

    public IItemHandler getOut() {
        return this.outInv;
    }

    public ItemStack getOutItem(int i) {
        return this.getOut().getStackInSlot(i);
    }

    @Override
    public boolean isInfoEmpty() {
        int i;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getInputItem());
        for (i = 0; i < 9; ++i) {
            this.addStackList(stackList, this.getInputSideItem(i));
        }
        this.addStackList(stackList, this.getResultItem());
        for (i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getOutItem(i));
        }
        return stackList.isEmpty();
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new FurnitureTableMenu(windowId, inv, this);
    }
}

