/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MFBottlerMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileMFBottler
extends TileSMMagic {
    public int maxMagiaFlux = 500000;
    public boolean isSelect = false;
    public int selectId = -1;
    public int setCount = 1;
    public List<ItemStack> outStackList = new ArrayList<ItemStack>();
    private List<ItemStack> stackList = Arrays.asList(new ItemStack((ItemLike)ItemInit.mf_small_bottle), new ItemStack((ItemLike)ItemInit.mf_bottle), new ItemStack((ItemLike)ItemInit.magia_bottle));
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileMFBottler(BlockPos pos, BlockState state) {
        this(TileInit.mfBottler, pos, state);
    }

    public TileMFBottler(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, OUT);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (!this.isSelect || this.tickTime % 20 != 0 || this.outStackList.isEmpty() || this.isRSPower()) {
            return;
        }
        this.craftFinish();
    }

    public void craftFinish() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (ItemStack stack : this.outStackList) {
            int useMF;
            if (stack.m_41619_()) continue;
            ItemStack copy = stack.m_41777_();
            int mf = this.getMF();
            if (mf < (useMF = SweetMagicAPI.getMF(copy))) {
                this.addStackList(stackList, copy);
                continue;
            }
            int count = Math.min(copy.m_41613_(), mf / useMF);
            int difCount = copy.m_41613_() - count;
            copy.m_41764_(count);
            ItemStack insert = ItemHelper.insertStack(this.getInput(), copy, false);
            this.setMF(mf - useMF * (count - insert.m_41613_()));
            ItemStack out = new ItemStack((ItemLike)stack.m_41777_().m_41720_(), difCount += insert.m_41613_());
            this.addStackList(stackList, out);
            if (!this.isMFEmpty()) continue;
        }
        this.outStackList.clear();
        if (!stackList.isEmpty()) {
            this.outStackList = stackList;
        } else {
            this.isSelect = false;
        }
        this.sendInfo();
    }

    public List<ItemStack> getStackList() {
        return this.stackList;
    }

    @Override
    public int getInvSize() {
        return 18;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 50000;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("outInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128379_("isSelect", this.isSelect);
        tag.m_128405_("selectId", this.selectId);
        tag.m_128405_("stackCount", this.setCount);
        this.saveStackList(tag, this.outStackList, "outStackList");
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("outInv"));
        this.isSelect = tag.m_128471_("isSelect");
        this.selectId = tag.m_128451_("selectId");
        this.setCount = tag.m_128451_("stackCount");
        this.outStackList = this.loadAllStack(tag, "outStackList");
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MFBottlerMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.outStackList.isEmpty() && this.isMFEmpty();
    }
}

