/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.magic.MFPot;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.WorldHelper;

public class TileMFPot
extends TileSMMagic {
    public int maxMagiaFlux = 200000;
    public boolean isReceive = false;
    private Direction face = Direction.NORTH;
    private static final Direction[] ALLFACE = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public TileMFPot(BlockPos pos, BlockState state) {
        super(TileInit.mfpot, pos, state);
    }

    public TileMFPot(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        this.onUpdate(world, pos, false);
        if (this.tickTime % 600 == 0) {
            this.tickTime = 0;
        }
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        this.onUpdate(world, pos, true);
        if (this.tickTime % 200 == 0) {
            this.tickTime = 0;
        }
    }

    public void onUpdate(Level world, BlockPos pos, boolean isClient) {
        if (this.isMaxMF()) {
            return;
        }
        switch (this.getData(pos)) {
            case 0: {
                this.dmPot(world, pos, isClient);
                break;
            }
            case 1: {
                this.alstPot(world, pos, isClient);
                break;
            }
            case 2: {
                this.snodDropPot(world, pos, isClient);
                break;
            }
            case 4: {
                this.rosePot(world, pos, isClient);
                break;
            }
            case 5: {
                this.solidStarPot(world, pos, isClient);
                break;
            }
            case 6: {
                this.zinniaPot(world, pos, isClient);
                break;
            }
            case 7: {
                this.hydoraPot(world, pos, isClient);
                break;
            }
            case 8: {
                this.carnationPot(world, pos, isClient);
                break;
            }
            case 9: {
                this.ericsPot(world, pos, isClient);
                break;
            }
            case 10: {
                this.cosmosPot(world, pos, isClient);
            }
        }
    }

    public void dmPot(Level world, BlockPos pos, boolean isClient) {
        if (!world.m_46471_()) {
            return;
        }
        if (this.tickTime % 20 == 0 && !isClient) {
            this.setMF(this.getMF() + 20);
            this.sentClient();
        } else if (this.tickTime % 100 == 0 && isClient) {
            this.spawnParticles(world, pos);
        }
    }

    public void alstPot(Level world, BlockPos pos, boolean isClient) {
        long worldTime = world.m_8044_() % 24000L;
        if (worldTime >= 10400L && worldTime <= 14000L) {
            if (this.tickTime % 20 == 0 && !isClient) {
                this.setMF(this.getMF() + 100);
                this.sendPKT();
            }
            if (this.tickTime % 100 == 0 && isClient) {
                this.spawnParticles(world, pos);
            }
        }
    }

    public void snodDropPot(Level world, BlockPos pos, boolean isClient) {
        if (((Biome)world.m_204166_(pos).get()).m_47554_() > 0.0f && pos.m_123342_() < 120) {
            return;
        }
        if (this.tickTime % 20 == 0 && !isClient) {
            this.setMF(this.getMF() + 10);
            this.sentClient();
        }
        if (this.tickTime % 100 == 0 && isClient) {
            this.spawnParticles(world, pos);
        }
    }

    public void rosePot(Level world, BlockPos pos, boolean isClient) {
        if (isClient || this.tickTime % 600 != 0) {
            return;
        }
        BlockEntity tile = this.getTile(pos.m_7495_());
        if (tile == null || tile instanceof HopperBlockEntity || tile instanceof DropperBlockEntity) {
            return;
        }
        IItemHandler handler = this.getItemHandler(tile, Direction.UP);
        if (handler == null) {
            return;
        }
        int sumMF = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack inStack = handler.extractItem(i, Integer.MAX_VALUE, false);
            if (inStack.m_41619_()) continue;
            sumMF += inStack.m_41613_();
            inStack.m_41774_(inStack.m_41613_());
        }
        if (sumMF > 0) {
            this.setMF(this.getMF() + sumMF);
            this.sendPKT();
            this.playSound(pos, SoundEvents.f_12331_, 0.35f, 1.0f);
        }
    }

    public void zinniaPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 40 != 0) {
            return;
        }
        boolean isCharge = false;
        float sumLightValue = 0.0f;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x > -2 && x < 2 && z == -1) {
                    z = 2;
                }
                for (int y = 0; y <= 1; ++y) {
                    float power;
                    BlockState state = this.getState(WorldHelper.offset(pos, x, y, z));
                    Block block = state.m_60734_();
                    if (block == Blocks.f_50016_ || (power = (float)block.getLightEmission(state, (BlockGetter)world, pos) * 0.25f) <= 0.0f) continue;
                    if (!this.getState(WorldHelper.offset(pos, x / 2, 0.0, z / 2)).m_60795_()) {
                        return;
                    }
                    isCharge = true;
                    sumLightValue += power;
                }
            }
        }
        if (isCharge) {
            if (!isClient) {
                this.setMF((int)((float)this.getMF() + sumLightValue));
                this.sentClient();
            } else {
                this.spawnParticles(world, pos);
            }
        }
    }

    public void solidStarPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 40 != 0) {
            return;
        }
        float sumLightValue = 0.0f;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x == 0 && z == 0) continue;
                if (x > -2 && x < 2 && z == -1) {
                    z = 2;
                }
                for (int y = 0; y <= 1; ++y) {
                    BlockPos p = WorldHelper.offset(pos, x, y, z);
                    BlockState state = this.getState(p);
                    sumLightValue += state.m_60734_().getEnchantPowerBonus(state, (LevelReader)world, p);
                }
            }
        }
        if (sumLightValue > 0.0f) {
            if (!isClient) {
                this.setMF((int)((float)this.getMF() + sumLightValue));
                this.sentClient();
            } else {
                this.spawnParticles(world, pos);
            }
        }
    }

    public void hydoraPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 10 != 0) {
            return;
        }
        List<Monster> entityList = this.getEntityList(Monster.class, 16.0).stream().filter(t -> !t.m_6084_()).toList();
        if (entityList.isEmpty()) {
            return;
        }
        int sumMF = 0;
        for (Monster entity : entityList) {
            CompoundTag tags = entity.getPersistentData();
            if (tags == null || tags.m_128471_("isSMDead")) continue;
            tags.m_128379_("isSMDead", true);
            entity.m_7380_(tags);
            sumMF = (int)((float)sumMF + entity.m_21233_() * 10.0f);
        }
        if (sumMF > 0) {
            if (!isClient) {
                this.setMF(this.getMF() + sumMF);
                this.sentClient();
            } else {
                this.spawnParticles(world, pos);
            }
        }
    }

    public void carnationPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 20 != 0) {
            return;
        }
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        Iterable<BlockPos> posList = WorldHelper.getRangePos(pos, -1.0, 0.0, -1.0, 1.0, 0.0, 1.0);
        for (BlockPos p : posList) {
            ISMCrop crop;
            BlockState state;
            Block block;
            if (p.m_123341_() == 0 && p.m_123343_() == 0 || !((block = (state = this.getState(p)).m_60734_()) instanceof ISMCrop) || !(crop = (ISMCrop)block).isMaxAge(state) || !SweetMagicAPI.hasMF(crop.getCrop().m_5456_())) continue;
            stackList.addAll(crop.rightClickStack(world, state, p));
        }
        if (!stackList.isEmpty()) {
            if (!isClient) {
                int sumMF = 0;
                for (ItemStack stack : stackList) {
                    sumMF = (int)((float)sumMF + (float)SweetMagicAPI.getMF(stack) * 1.5f);
                }
                this.setMF(this.getMF() + sumMF);
                this.sendPKT();
                this.playSound(pos, SoundEvents.f_11991_, 0.25f, 0.8f + world.m_213780_().m_188501_() * 0.4f);
            } else {
                this.spawnParticles(world, pos);
            }
        }
    }

    public void ericsPot(Level world, BlockPos pos, boolean isClient) {
        long time = this.getTime();
        if (time % 7L != 0L) {
            return;
        }
        BlockPos p = pos.m_121945_(this.face);
        Block block = this.getBlock(p);
        if (block instanceof SnowLayerBlock) {
            if (!isClient) {
                this.m_58904_().m_46961_(p, false);
                this.m_58904_().m_7471_(p, false);
                this.setMF(this.getMF() + 20);
                this.sentClient();
            } else {
                this.spawnParticles(world, pos);
            }
        }
        this.face = this.face.m_122427_();
    }

    public void cosmosPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 40 != 0) {
            return;
        }
        int sumMF = 0;
        for (Direction face : ALLFACE) {
            BlockPos p = pos.m_121945_(face);
            BlockState state = this.getState(p);
            Block block = state.m_60734_();
            if (!state.m_60713_(Blocks.f_49991_) && !(block instanceof BaseFireBlock)) continue;
            if (block instanceof LiquidBlock) {
                LiquidBlock liq = (LiquidBlock)block;
                if ((Integer)state.m_61143_((Property)LiquidBlock.f_54688_) != 0) continue;
            }
            sumMF += state.m_60713_(Blocks.f_49991_) ? 4000 : 200;
            world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
            this.playSound(p, SoundEvents.f_11937_, 1.0f, 1.0f);
        }
        if (sumMF > 0) {
            if (!isClient) {
                this.setMF(this.getMF() + sumMF);
                this.sendPKT();
            } else {
                this.spawnParticles(world, pos);
            }
        }
    }

    public int getData(BlockPos pos) {
        int n;
        Block block = this.getBlock(pos);
        if (block instanceof MFPot) {
            MFPot pot = (MFPot)block;
            n = pot.getData();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public boolean getReceive() {
        return this.isReceive;
    }

    public void spawnParticles(Level world, BlockPos pos) {
        SimpleParticleType par = ParticleTypes.f_123748_;
        for (int i = 0; i < 4; ++i) {
            double x = this.rand.nextGaussian() * 0.02;
            double y = this.rand.nextGaussian() * 0.02;
            double z = this.rand.nextGaussian() * 0.02;
            world.m_7106_((ParticleOptions)par, this.getRandX(pos, this.rand, 1.0), this.getRandY(pos, this.rand), this.getRandZ(pos, this.rand, 1.0), x, y, z);
        }
    }

    @Override
    public IItemHandler getInput() {
        return null;
    }
}

