/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MFWoodCutterMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.recipe.woodcutter.WoodCutterRecipe;
import sweetmagic.util.ItemHelper;

public class TileMFWoodCutter
extends TileSMMagic {
    public int craftTime = 0;
    public int maxMagiaFlux = 10000;
    public static final int MAX_CRAFT_TIME = 20;
    public boolean isCraft = false;
    public List<ItemStack> outStackList = new ArrayList<ItemStack>();
    public List<ItemStack> outStackOverList = new ArrayList<ItemStack>();
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    protected final TileAbstractSM.StackHandler outInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileMFWoodCutter(BlockPos pos, BlockState state) {
        this(TileInit.woodCutter, pos, state);
    }

    public TileMFWoodCutter(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputInv, (IItemHandlerModifiable)this.outInv);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 10 != 0 || this.isRSPower()) {
            return;
        }
        if (!this.isCraft) {
            this.craftStart();
        } else if (this.craftTime++ >= 20) {
            this.craftEnd();
        }
        this.sendInfo();
    }

    public void craftStart() {
        if (!this.outStackOverList.isEmpty()) {
            this.craftOverInsert();
            return;
        }
        ItemHelper.compactSimpleInventory((IItemHandlerModifiable)this.inputInv);
        ItemStack stack = this.getInputItem();
        if (stack.m_41619_() || !this.canSmelt(stack)) {
            return;
        }
        WoodCutterRecipe recipe = WoodCutterRecipe.getRecipe(this.m_58904_(), Arrays.asList(stack)).get();
        this.outStackList = this.getLog(recipe, stack);
        if (this.outStackList.isEmpty()) {
            return;
        }
        this.isCraft = true;
        this.setMF(this.getMF() - recipe.getMF());
        this.sendInfo();
    }

    public void craftEnd() {
        for (ItemStack outStack : this.outStackList) {
            ItemStack stack = ItemHelper.insertStack(this.getOut(), outStack.m_41777_(), false);
            if (stack.m_41619_()) continue;
            this.outStackOverList.add(stack);
        }
        this.outStackList.clear();
        ItemStack stack = this.getInputItem();
        this.isCraft = !stack.m_41619_() && stack.m_204117_(ItemTags.f_13180_);
        this.craftTime = this.isCraft ? 10 : 0;
        this.isCraft = false;
        this.sendInfo();
        for (int i = 0; i < 4; ++i) {
            this.playSound(this.m_58899_(), SoundEvents.f_12630_, 0.5f, 0.9f + this.getRandFloat(0.15f));
        }
    }

    public boolean canSmelt(ItemStack stack) {
        return !WoodCutterRecipe.getRecipe(this.m_58904_(), Arrays.asList(stack)).isEmpty();
    }

    public List<ItemStack> getLog(WoodCutterRecipe recipe, ItemStack stack) {
        if (this.getMF() < recipe.getMF()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        List<ItemStack> outList = recipe.getResultList();
        for (int i = 0; i < outList.size(); ++i) {
            int count = recipe.getCount(this.rand, i);
            if (count <= 0) continue;
            stackList.add(new ItemStack((ItemLike)outList.get(i).m_41720_(), count));
        }
        return stackList;
    }

    public void craftOverInsert() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.outStackOverList.forEach(s -> this.addStackList(stackList, ItemHelper.insertStack(this.getOut(), s.m_41777_(), false)));
        this.outStackOverList.clear();
        if (!stackList.isEmpty()) {
            this.outStackOverList = stackList;
        }
    }

    @Override
    public int getInvSize() {
        return 27;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 5000;
    }

    public int getNeedMF() {
        return 50;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getOut() {
        return this.outInv;
    }

    public ItemStack getOutItem(int i) {
        return this.getOut().getStackInSlot(i);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outInv", (Tag)this.outInv.serializeNBT());
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128379_("isCraft", this.isCraft);
        this.saveStackList(tag, this.outStackOverList, "outStackOverList");
        this.saveStackList(tag, this.outStackList, "outStackList");
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outInv.deserializeNBT(tag.m_128469_("outInv"));
        this.craftTime = tag.m_128451_("craftTime");
        this.isCraft = tag.m_128471_("isCraft");
        this.outStackOverList = this.loadAllStack(tag, "outStackOverList");
        this.outStackList = this.loadAllStack(tag, "outStackList");
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MFWoodCutterMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, 20);
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getOutItem(i));
        }
        this.addStackList(stackList, this.getInputItem());
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

