/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.IMagicItem;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MagiaTableMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileMagiaTable
extends TileSMMagic {
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public boolean isCraft = false;
    public boolean canCraft = false;
    public int craftTime = 0;
    public int maxCraftTime = 10;
    public int maxMagiaFlux = 200000;
    public ItemStack copyMagic = ItemStack.f_41583_;
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(1, true){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(1, true);
    protected final TileAbstractSM.StackHandler subInv = new TileAbstractSM.StackHandler(6);

    public TileMagiaTable(BlockPos pos, BlockState state) {
        super(TileInit.magiaTable, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
    }

    public TileMagiaTable(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 10 != 0) {
            return;
        }
        ItemStack stack = this.getInputItem();
        if (!this.isCraft) {
            if (stack.m_41619_()) {
                return;
            }
            this.canCraft = this.craftStart(stack, true);
            this.sendInfo();
            return;
        }
        if (this.craftTime++ >= this.maxCraftTime) {
            this.craftFinish(stack);
        } else if (this.craftTime % 2 == 0 && this.craftTime <= this.maxCraftTime - 2) {
            this.playSound(pos, SoundInit.TURN_PAGE, 0.1f, 1.0f);
        }
        this.sendInfo();
    }

    public boolean craftStart(ItemStack stack, boolean isSum) {
        IMagicItem magic;
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof IMagicItem) || (magic = (IMagicItem)item).isUniqueMagic()) {
            return false;
        }
        if (!ItemHelper.insertStack(this.getOutput(), stack.m_41777_(), true).m_41619_()) {
            return false;
        }
        MagicInfo info = new MagicInfo(stack);
        if (this.getMF() < this.getRequestMF(info)) {
            return false;
        }
        List<ItemStack> requestList = this.getRequestList(info);
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            ItemStack sub = this.getSubItem(i);
            if (sub.m_41619_()) continue;
            stackList.add(sub);
        }
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>();
        ArrayList<Integer> slotIdList = new ArrayList<Integer>();
        for (ItemStack ingStack : requestList) {
            boolean isChecked = false;
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack s;
                if (slotIdList.contains(i) || !ingStack.m_150930_((s = (ItemStack)stackList.get(i)).m_41720_()) || s.m_41613_() < ingStack.m_41613_()) continue;
                slotIdList.add(i);
                resultList.add(ingStack);
                isChecked = true;
                break;
            }
            if (isChecked) continue;
            return false;
        }
        if (isSum) {
            return true;
        }
        this.isCraft = true;
        this.craftTime = 0;
        this.maxCraftTime = this.getMaxCraftTime(info);
        this.setMF(this.getMF() - this.getRequestMF(info));
        this.copyMagic = stack.m_41777_();
        this.copyMagic.m_41764_(1);
        this.clickButton();
        this.sendPKT();
        for (ItemStack ingStack : resultList) {
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack s = (ItemStack)stackList.get(i);
                if (!ingStack.m_150930_(s.m_41720_()) || s.m_41613_() < ingStack.m_41613_()) continue;
                s.m_41774_(ingStack.m_41613_());
            }
        }
        return true;
    }

    public void craftFinish(ItemStack stack) {
        if (!ItemHelper.insertStack(this.getOutput(), this.copyMagic, true).m_41619_()) {
            return;
        }
        ItemHelper.insertStack(this.getOutput(), this.copyMagic, false);
        this.isCraft = false;
        this.craftTime = 0;
        this.copyMagic = ItemStack.f_41583_;
        this.playSound(this.m_58899_(), SoundInit.WRITE, 0.1f, 1.0f);
        this.sendPKT();
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        this.oOpen = this.open;
        this.open += this.isCraft ? 0.1f : -0.1f;
        this.open = Mth.m_14036_((float)this.open, (float)0.0f, (float)1.0f);
        ++this.time;
        this.oFlip = this.flip;
        float f = (this.flipT - this.flip) * 0.4f;
        f = Mth.m_14036_((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.flip += this.flipA;
        if (this.isCraft && this.tickTime % 2 == 0) {
            this.spawnParticle(world, pos);
            if (this.tickTime % 20 == 0) {
                this.flip = -2.0f;
            }
        }
    }

    public void spawnParticle(Level world, BlockPos pos) {
        int i;
        float posX = (float)pos.m_123341_() + 0.5f;
        float posY = (float)pos.m_123342_() + 1.25f;
        float posZ = (float)pos.m_123343_() + 0.5f;
        SimpleParticleType par = ParticleInit.CYCLE_LIGHT;
        for (i = 0; i < 8; ++i) {
            this.spawnParticleCycle(world, (ParticleOptions)par, posX, posY, (double)posZ, 0.67, (float)i * 32.0f);
        }
        par = ParticleInit.DIVINE;
        for (i = 0; i < 2; ++i) {
            world.m_7106_((ParticleOptions)par, (double)(posX + this.getRandFloat(0.2f)), (double)posY, (double)(posZ + this.getRandFloat(0.2f)), (double)this.getRandFloat(0.075f), (double)0.1f, (double)this.getRandFloat(0.075f));
        }
    }

    protected void spawnParticleCycle(Level world, ParticleOptions par, double x, double y, double z, double range, double angle) {
        world.m_7106_(par, x, y, z, (double)Direction.UP.m_122411_(), range, angle + 6.0 - (double)(this.tickTime * 5));
    }

    public Item getMainRequestItem(MagicInfo info) {
        return switch (info.getMagicItem().getElement()) {
            case SMElement.FLAME -> ItemInit.fire_nasturtium_petal;
            case SMElement.FROST -> ItemInit.unmeltable_ice;
            case SMElement.CYCLON -> ItemInit.tiny_feather;
            case SMElement.LIGHTNING -> ItemInit.electronic_orb;
            case SMElement.EARTH -> ItemInit.sugarbell;
            case SMElement.SHINE -> ItemInit.prizmium;
            case SMElement.DARK -> ItemInit.stray_soul;
            case SMElement.WATER -> ItemInit.dm_flower;
            case SMElement.GRAVITY -> ItemInit.grav_powder;
            case SMElement.BLAST -> ItemInit.magic_meal;
            case SMElement.TOXIC -> ItemInit.poison_bottle;
            case SMElement.TIME -> ItemInit.clero_petal;
            case SMElement.ALL -> ItemInit.mf_small_bottle;
            default -> ItemInit.aether_crystal;
        };
    }

    public int getMainRequestSize(MagicInfo info) {
        return switch (info.getMagicItem().getTier()) {
            case 0 -> 3;
            case 1 -> 8;
            case 2 -> 12;
            case 3 -> 24;
            default -> 32;
        };
    }

    public int getMaxCraftTime(MagicInfo info) {
        return switch (info.getMagicItem().getTier()) {
            case 0 -> 6;
            case 1 -> 10;
            case 2 -> 16;
            case 3 -> 24;
            default -> 40;
        };
    }

    public List<ItemStack> getRequestList(MagicInfo info) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stackList.add(new ItemStack((ItemLike)this.getMainRequestItem(info), this.getMainRequestSize(info)));
        switch (info.getMagicItem().getTier()) {
            case 0: {
                stackList.add(new ItemStack((ItemLike)ItemInit.blank_magic));
                stackList.add(new ItemStack((ItemLike)ItemInit.blank_page));
                break;
            }
            case 1: {
                stackList.add(new ItemStack((ItemLike)ItemInit.blank_magic));
                stackList.add(new ItemStack((ItemLike)ItemInit.blank_page, 2));
                break;
            }
            case 2: {
                stackList.add(new ItemStack((ItemLike)ItemInit.blank_magic, 2));
                stackList.add(new ItemStack((ItemLike)ItemInit.blank_page, 4));
                break;
            }
            case 3: {
                stackList.add(new ItemStack((ItemLike)ItemInit.blank_magic, 3));
                stackList.add(new ItemStack((ItemLike)ItemInit.blank_page, 6));
                break;
            }
            case 4: {
                stackList.add(new ItemStack((ItemLike)ItemInit.blank_magic, 4));
                stackList.add(new ItemStack((ItemLike)ItemInit.blank_page, 8));
                stackList.add(new ItemStack((ItemLike)BlockInit.magiaflux_block));
            }
        }
        return stackList;
    }

    public int getRequestMF(MagicInfo info) {
        return switch (info.getMagicItem().getTier()) {
            case 0 -> 2000;
            case 1 -> 5000;
            case 2 -> 25000;
            case 3 -> 100000;
            default -> 200000;
        };
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, this.maxCraftTime);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128365_("subInv", (Tag)this.subInv.serializeNBT());
        tag.m_128365_("copyMagic", (Tag)this.copyMagic.m_41739_(new CompoundTag()));
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("maxCraftTime", this.maxCraftTime);
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128379_("canCraft", this.canCraft);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outputInv.deserializeNBT(tag.m_128469_("outputInv"));
        this.subInv.deserializeNBT(tag.m_128469_("subInv"));
        this.copyMagic = ItemStack.m_41712_((CompoundTag)tag.m_128469_("copyMagic"));
        this.craftTime = tag.m_128451_("craftTime");
        this.maxCraftTime = tag.m_128451_("maxCraftTime");
        this.isCraft = tag.m_128471_("isCraft");
        this.canCraft = tag.m_128471_("canCraft");
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 25000;
    }

    @Override
    public int getInvSize() {
        return 6;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutItem() {
        return this.getOutput().getStackInSlot(0);
    }

    public IItemHandler getSub() {
        return this.subInv;
    }

    public ItemStack getSubItem(int i) {
        return this.getSub().getStackInSlot(i);
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getInputItem());
        this.addStackList(stackList, this.getOutItem());
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getSubItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MagiaTableMenu(windowId, inv, this);
    }
}

