/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.api.iblock.ITileMF;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.tile.sm.TileAbstractSM;

public abstract class TileSMMagic
extends TileAbstractSM
implements ITileMF {
    public int magiaFlux = 0;
    public boolean isReceive = true;
    public Set<BlockPos> posList = new HashSet<BlockPos>();
    public final String POST = "pos";

    public TileSMMagic(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getTickTime() % 20 == 0 && !this.posList.isEmpty()) {
            this.sendRecivehandler();
        }
    }

    @Override
    public void clientTick(Level world, BlockPos p, BlockState state) {
        super.clientTick(world, p, state);
        if (this.getTickTime() % 80 != 0 || this.posList.isEmpty() || this.isMaxMF()) {
            return;
        }
        for (BlockPos pos : this.posList) {
            BlockEntity tile = this.getEntity(pos);
            if (!(tile instanceof ITileMF) || !this.checkDistance(pos) || ((ITileMF)tile).isMFEmpty()) continue;
            float pX = this.m_58899_().m_123341_() - pos.m_123341_();
            float pY = this.m_58899_().m_123342_() - pos.m_123342_();
            float pZ = this.m_58899_().m_123343_() - pos.m_123343_();
            for (int i = 0; i < 4; ++i) {
                float randX = this.getRandFloat(0.5f);
                float randY = this.getRandFloat(0.5f);
                float randZ = this.getRandFloat(0.5f);
                float x = (float)pos.m_123341_() + 0.5f + randX;
                float y = (float)pos.m_123342_() + 0.525f + randY;
                float z = (float)pos.m_123343_() + 0.5f + randZ;
                float xSpeed = pX * 0.1175f;
                float ySpeed = pY * 0.1175f;
                float zSpeed = pZ * 0.1175f;
                world.m_7106_((ParticleOptions)ParticleInit.NORMAL, (double)x, (double)y, (double)z, (double)xSpeed, (double)ySpeed, (double)zSpeed);
            }
        }
    }

    @Override
    public BlockEntity getTile() {
        return this;
    }

    @Override
    public Set<BlockPos> getPosList() {
        return this.posList;
    }

    @Override
    public void addPosList(BlockPos pos) {
        this.posList.add(pos);
    }

    @Override
    public BlockPos getTilePos() {
        return this.m_58899_();
    }

    @Override
    public Level getTileWorld() {
        return this.m_58904_();
    }

    @Override
    public int getTickTime() {
        return this.tickTime;
    }

    @Override
    public void setTickTime(int tickTime) {
        this.tickTime = tickTime;
    }

    @Override
    public boolean getReceive() {
        return this.isReceive;
    }

    @Override
    public int getMF() {
        return this.magiaFlux;
    }

    @Override
    public void setMF(int mf) {
        this.magiaFlux = mf;
    }

    public String getMFPercent() {
        return this.format((float)this.getMF() / (float)this.getMaxMF() * 100.0f) + "%";
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("magiaFlux", this.magiaFlux);
        if (!this.posList.isEmpty()) {
            this.savePosList(tag, this.getPosList(), this.POST);
        }
        this.saveNBT(tag);
    }

    public void saveNBT(CompoundTag tags) {
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setMF(tag.m_128451_("magiaFlux"));
        this.posList = this.loadAllPos(tag, this.POST);
        this.loadNBT(tag);
    }

    public void loadNBT(CompoundTag tags) {
    }

    public abstract IItemHandler getInput();

    @Override
    public boolean isInfoEmpty() {
        return this.isMFEmpty();
    }
}

