/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.init.PotionInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.monster.boss.AncientFairy;
import sweetmagic.init.entity.monster.boss.Arlaune;
import sweetmagic.init.entity.monster.boss.BlitzWizardMaster;
import sweetmagic.init.entity.monster.boss.BraveSkeleton;
import sweetmagic.init.entity.monster.boss.BullFight;
import sweetmagic.init.entity.monster.boss.DemonsBelial;
import sweetmagic.init.entity.monster.boss.ElshariaCurious;
import sweetmagic.init.entity.monster.boss.GemFrog;
import sweetmagic.init.entity.monster.boss.HolyAngel;
import sweetmagic.init.entity.monster.boss.IgnisKnight;
import sweetmagic.init.entity.monster.boss.QueenFrost;
import sweetmagic.init.entity.monster.boss.SilverLandRoad;
import sweetmagic.init.entity.monster.boss.StellaWizardMaster;
import sweetmagic.init.entity.monster.boss.TwilightHora;
import sweetmagic.init.entity.monster.boss.WhiteButler;
import sweetmagic.init.entity.monster.boss.WindWitchMaster;
import sweetmagic.init.entity.monster.boss.WitchSandryon;
import sweetmagic.init.tile.sm.TileSMSpawner;

public class TileSMSpawnerBoss
extends TileSMSpawner {
    public int breakCrystal = 0;
    public float overHealth = 0.0f;

    public TileSMSpawnerBoss(BlockPos pos, BlockState state) {
        super(TileInit.smSpawnerBoss, pos, state);
    }

    public TileSMSpawnerBoss(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean checkTick() {
        return this.tickTime % 20 != 0;
    }

    @Override
    public boolean checkPlayer(Level world, double range) {
        return !this.getEntityListUp(Player.class, e -> e.m_6084_() && !e.m_7500_() && !e.m_5833_(), range).isEmpty();
    }

    @Override
    public void doSpawnEntity(Level world, BlockPos pos, Random rand) {
        block3: {
            block2: {
                if (!(world instanceof ServerLevel)) break block2;
                ServerLevel server = (ServerLevel)world;
                if (this.checkPlayer(world, this.getRange())) break block3;
            }
            return;
        }
        AbstractSMBoss entity = (AbstractSMBoss)this.getEntity(false);
        entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5);
        entity.spawnAction();
        this.setEntityBuff(entity);
        this.startInfo(entity);
        world.m_7967_((Entity)entity);
        entity.m_21373_();
        world.m_46961_(pos, false);
        world.m_7471_(pos, false);
        this.startInfo(entity);
    }

    public void setEntityBuff(AbstractSMBoss entity) {
        int level = this.getMobLevel() - 1;
        this.addPotion((LivingEntity)entity, PotionInit.resistance_blow, 99999, 4);
        if (level <= 0) {
            return;
        }
        this.addPotion((LivingEntity)entity, PotionInit.reflash_effect, 99999, 0);
        entity.setHealthArmorCount(entity.getHealthArmorCount() + level);
    }

    @Override
    public void setMobType() {
        this.setMobType(this.rand.nextInt(this.maxMobType() - 2));
        this.randFlag = true;
    }

    public Mob getEntity(boolean isRender) {
        Level world = this.m_58904_();
        AbstractSMBoss entity = null;
        AbstractSMBoss sub = null;
        List<Player> playerList = this.getEntityList(Player.class, e -> e.m_6084_() && !e.m_7500_() && !e.m_5833_(), 32.0);
        int summonMobSize = this.getEntityList(AbstractSummonMob.class, e -> e.m_6084_(), 80.0).size() - 1;
        float addHealth = 1.0f + (float)summonMobSize * 0.1f;
        switch (this.getMobType()) {
            case 0: {
                entity = new BullFight(world);
                this.setMaxHealth(entity, entity.m_21233_(), playerList, addHealth);
                break;
            }
            case 1: {
                entity = new AncientFairy(world);
                this.setMaxHealth(entity, entity.m_21233_(), playerList, addHealth);
                break;
            }
            case 2: {
                entity = new Arlaune(world);
                this.setMaxHealth(entity, entity.m_21233_(), playerList, addHealth);
                break;
            }
            case 3: {
                entity = new SilverLandRoad(world);
                this.setMaxHealth(entity, entity.m_21233_(), playerList, addHealth);
                ((SilverLandRoad)entity).setAlive(true);
                sub = this.addSpawn(isRender);
                break;
            }
            case 4: {
                entity = new TwilightHora(world);
                this.setMaxHealth(entity, entity.m_21233_(), playerList, addHealth);
                break;
            }
            case 5: {
                entity = new BraveSkeleton(world);
                this.setMaxHealth(entity, entity.m_21233_(), playerList, addHealth);
                if (isRender) break;
                sub = ((BraveSkeleton)entity).spawnHorse((LevelAccessor)world, this.m_58899_().m_7494_());
                break;
            }
            case 6: {
                entity = new ElshariaCurious(world);
                this.setMaxHealth(entity, entity.m_21233_(), playerList, addHealth);
                break;
            }
            case 7: {
                entity = new WitchSandryon(world);
                this.setMaxHealth(entity, entity.m_21233_(), playerList, addHealth);
                break;
            }
            case 8: {
                entity = new QueenFrost(world);
                this.setMaxHealth(entity, 512.0f, playerList, addHealth);
                break;
            }
            case 9: {
                entity = new HolyAngel(world);
                this.setMaxHealth(entity, 512.0f, playerList, addHealth);
                break;
            }
            case 10: {
                entity = new IgnisKnight(world);
                this.setMaxHealth(entity, 512.0f, playerList, addHealth);
                break;
            }
            case 11: {
                entity = new WindWitchMaster(world);
                this.setMaxHealth(entity, 512.0f, playerList, addHealth);
                break;
            }
            case 12: {
                entity = new BlitzWizardMaster(world);
                this.setMaxHealth(entity, entity.m_21233_(), playerList, addHealth);
                break;
            }
            case 13: {
                entity = new StellaWizardMaster(world);
                entity.m_21051_(Attributes.f_22276_).m_22100_(768.0 * (double)(1.0f + (float)playerList.size() * 0.15f) * (double)addHealth);
                entity.m_21153_(entity.m_21233_());
                ((StellaWizardMaster)entity).setDemons(!this.randFlag);
                ((StellaWizardMaster)entity).setGimmick(this.breakCrystal);
                ((StellaWizardMaster)entity).setHealthArmorCount(4);
                break;
            }
            case 14: {
                entity = new DemonsBelial(world);
                break;
            }
            case 15: {
                entity = new GemFrog(world);
            }
        }
        if (sub != null && sub instanceof AbstractSMBoss) {
            AbstractSMBoss boss = sub;
            boss.setOwnerID((LivingEntity)entity);
            entity.setOwnerID((LivingEntity)boss);
        }
        return entity;
    }

    public void setMaxHealth(AbstractSMBoss entity, float mobHealth, List<Player> playerList, float addHealth) {
        double setHealth = mobHealth * (1.0f + (float)playerList.size() * 0.15f) * addHealth;
        this.overHealth = setHealth > 1024.0 ? (float)setHealth - 1024.0f : 0.0f;
        entity.m_21051_(Attributes.f_22276_).m_22100_(setHealth);
        entity.m_21153_(entity.m_21233_());
    }

    @Override
    public void startInfo(AbstractSMBoss mob) {
        mob.startInfo();
    }

    public AbstractSMBoss addSpawn(boolean isRender) {
        if (isRender) {
            return null;
        }
        WhiteButler entity = null;
        Level world = this.m_58904_();
        List<Player> playerList = this.getEntityList(Player.class, e -> e.m_6084_() && !e.m_7500_() && !e.m_5833_(), 32.0);
        int summonMobSize = this.getEntityList(AbstractSummonMob.class, e -> e.m_6084_(), 80.0).size();
        float addHealth = 1.0f + (float)summonMobSize * 0.1f;
        switch (this.getMobType()) {
            case 3: {
                entity = new WhiteButler(world);
                this.setMaxHealth(entity, entity.m_21233_(), playerList, addHealth);
                entity.setAlive(true);
            }
        }
        BlockPos pos = this.m_58899_();
        entity.m_6034_((double)pos.m_123341_() + 1.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5);
        this.setEntityBuff(entity);
        ((AbstractSMBoss)entity).startInfo();
        world.m_7967_((Entity)entity);
        entity.m_21373_();
        ((AbstractSMBoss)entity).startInfo();
        return entity;
    }

    @Override
    public void buttonEntity() {
        this.entity = this.getEntity(true);
    }

    @Override
    public LivingEntity getRenderEntity() {
        if (this.entity == null) {
            this.entity = this.getEntity(true);
        }
        return this.entity;
    }

    @Override
    public int maxMobType() {
        return 16;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("breakCrystal", this.breakCrystal);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.breakCrystal = tag.m_128451_("breakCrystal");
    }
}

