/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.sm.BossFigurine;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.item.sm.SMItem;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileBossFigurine;

public class TileSummonPedal
extends TileAbstractSM {
    private int summonTick = 0;
    private boolean isWarning = false;
    private static final int MAX_SUMMONTICK = 20;
    private static final AABB FULL = Shapes.m_83144_().m_83215_();
    private static final List<Direction> ALL_FACE = Arrays.asList(Direction.UP, Direction.NORTH, Direction.EAST);

    public TileSummonPedal(BlockPos pos, BlockState state) {
        super(TileInit.summonPedal, pos, state);
    }

    public TileSummonPedal(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 10 != 0 || this.isPeaceful(world)) {
            return;
        }
        Block block = this.getBlock(pos = pos.m_7494_());
        if (block instanceof BossFigurine) {
            boolean isBad = false;
            try {
                Iterable<BlockPos> posList = this.getRangePosUnder(pos, 5);
                for (BlockPos p : posList) {
                    AABB aabb;
                    if (world.m_46859_(p) || !FULL.equals((Object)(aabb = this.getState(p).m_60812_((BlockGetter)world, p).m_83215_()))) continue;
                    isBad = true;
                    SimpleParticleType par = ParticleInit.CYCLE_ORB;
                    if (this.tickTime % 30 != 0 || !(world instanceof ServerLevel)) continue;
                    ServerLevel server = (ServerLevel)world;
                    double range = aabb.m_82340_(Direction.Axis.X);
                    range = range > 1.0 - aabb.m_82374_(Direction.Axis.X) ? 1.0 - aabb.m_82374_(Direction.Axis.X) : range;
                    range = range > aabb.m_82340_(Direction.Axis.Z) ? aabb.m_82340_(Direction.Axis.Z) : range;
                    range = range > 1.0 - aabb.m_82374_(Direction.Axis.Z) ? 1.0 - aabb.m_82374_(Direction.Axis.Z) : range;
                    range = 0.85 - range;
                    for (int i = 0; i < 16; ++i) {
                        for (Direction face : ALL_FACE) {
                            this.spawnParticleCycle(server, p, (ParticleOptions)par, face, range, (double)i * 22.5);
                        }
                    }
                }
            }
            catch (Exception e) {
                isBad = false;
            }
            if (isBad) {
                try {
                    this.sendPlayerMSG(world);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (this.summonTick++ >= 20) {
                this.summonBoss((TileBossFigurine)this.getTile(TileBossFigurine::new, pos), world, pos);
                this.isWarning = false;
            } else {
                this.spawnParticle(world, pos);
            }
        } else {
            this.summonTick = 0;
            this.isWarning = false;
        }
    }

    public void sendPlayerMSG(Level world) {
        if (this.isWarning) {
            return;
        }
        List<Player> playerList = this.getEntityList(Player.class, e -> e.m_6084_() && !e.m_5833_(), 24.0);
        playerList.forEach(p -> p.m_213846_((Component)this.getText("noempty_block", new Object[]{5}).m_130940_(RED)));
        this.isWarning = true;
    }

    public void summonBoss(TileBossFigurine tile, Level world, BlockPos pos) {
        if (tile == null) {
            return;
        }
        AbstractSMBoss entity = tile.getEntity();
        entity.setLectern(false);
        entity.m_6034_((double)pos.m_123341_() + 2.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5);
        entity.startInfo();
        world.m_7967_((Entity)entity);
        entity.m_21373_();
        world.m_46961_(pos, false);
        world.m_7471_(pos, false);
        entity.startInfo();
        this.summonTick = 0;
    }

    public void spawnParticle(Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        SimpleParticleType par = ParticleInit.NORMAL;
        for (int i = 0; i < this.summonTick; ++i) {
            float randX = this.getRand(this.rand, 4);
            float randY = this.getRand(this.rand, 4);
            float randZ = this.getRand(this.rand, 4);
            float x = (float)pos.m_123341_() + 0.5f + randX;
            float y = (float)pos.m_123342_() + 0.75f + randY;
            float z = (float)pos.m_123343_() + 0.5f + randZ;
            float xSpeed = -randX * 0.115f;
            float ySpeed = -randY * 0.115f;
            float zSpeed = -randZ * 0.115f;
            server.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 1.0);
        }
    }

    public void spawnParticleCycle(ServerLevel server, BlockPos pos, ParticleOptions par, Direction face, double range, double angle) {
        float x = (float)pos.m_123341_() + 0.5f;
        float y = (float)pos.m_123342_() + 0.5f;
        float z = (float)pos.m_123343_() + 0.5f;
        server.m_8767_(par, (double)x, (double)y, (double)z, 0, (double)face.m_122411_(), range, angle + (double)SMItem.SPEED, 1.0);
    }

    protected int getRand(Random rand, int range) {
        return rand.nextInt(range) - rand.nextInt(range);
    }
}

