/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.WandReconstructMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileWandReconstruct
extends TileSMMagic {
    public List<SMElement> elementList = Arrays.asList(SMElement.NON, SMElement.FLAME, SMElement.FROST, SMElement.CYCLON, SMElement.LIGHTNING, SMElement.EARTH, SMElement.SHINE, SMElement.DARK, SMElement.WATER, SMElement.GRAVITY, SMElement.BLAST, SMElement.TOXIC, SMElement.TIME, SMElement.ALL);
    public boolean isCraft = false;
    public boolean canCraft = false;
    public int mainSelectId = -1;
    public int subSelectId = -1;
    public int nowTick = 0;
    public int craftTime = 0;
    public int maxCraftTime = 10;
    public int maxMagiaFlux = 1000000;
    public ItemStack copyMagic = ItemStack.f_41583_;
    public ItemStack mainMagic = ItemStack.f_41583_;
    public ItemStack subMagic = ItemStack.f_41583_;
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(1, true){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(1, false);
    protected final TileAbstractSM.StackHandler subInv = new TileAbstractSM.StackHandler(2);

    public TileWandReconstruct(BlockPos pos, BlockState state) {
        super(TileInit.wandReconstruct, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
    }

    public TileWandReconstruct(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.isCraft) {
            ++this.nowTick;
            this.sendPKT();
        }
        if (this.tickTime % 10 != 0) {
            return;
        }
        ItemStack stack = this.getInputItem();
        if (!this.isCraft) {
            if (stack.m_41619_()) {
                if (this.mainSelectId == -1 || this.subSelectId == -1) {
                    this.mainSelectId = -1;
                    this.subSelectId = -1;
                }
                return;
            }
            this.canCraft = this.craftStart(stack, true);
            this.sendInfo();
            return;
        }
        if (this.craftTime + 4 < this.maxCraftTime && world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            for (int i = 0; i < 4; ++i) {
                float randX = this.getRandFloat();
                float randY = this.getRandFloat(0.25f);
                float randZ = this.getRandFloat();
                float x = (float)pos.m_123341_() + 0.5f + randX;
                float y = (float)pos.m_123342_() + 0.5f + randY;
                float z = (float)pos.m_123343_() + 0.5f + randZ;
                float xSpeed = -randX * 0.1175f;
                float ySpeed = -(randY * 0.025f - 0.075f);
                float zSpeed = -randZ * 0.1175f;
                server.m_8767_((ParticleOptions)ParticleInit.DIVINE, (double)x, (double)y, (double)z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 1.0);
            }
        }
        if (this.craftTime++ >= this.maxCraftTime) {
            this.craftFinish(stack);
        } else if (this.craftTime % 2 == 0 && this.craftTime <= this.maxCraftTime - 2) {
            this.playSound(pos, SoundInit.STARDUST, 1.0f, 0.9f + this.rand.nextFloat() * 0.3f);
        }
        this.sendInfo();
    }

    public boolean craftStart(ItemStack stack, boolean isSum) {
        ItemStack s;
        int i;
        if (stack.m_41619_() || this.mainSelectId == -1 && this.subSelectId == -1) {
            return false;
        }
        if (!(stack.m_41720_() instanceof IWand)) {
            return false;
        }
        if (!ItemHelper.insertStack(this.getOutput(), stack.m_41777_(), true).m_41619_()) {
            return false;
        }
        int setValue = this.mainSelectId > -1 ? 1 : 0;
        setValue = this.subSelectId > -1 ? setValue++ : setValue;
        WandInfo info = new WandInfo(stack);
        if (this.getMF() < this.getRequestMF(setValue)) {
            return false;
        }
        List<ItemStack> requestList = this.getRequestList(info);
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i2 = 0; i2 < 2; ++i2) {
            ItemStack sub = this.getSubItem(i2);
            if (sub.m_41619_()) continue;
            stackList.add(sub);
        }
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>();
        ArrayList<Integer> slotIdList = new ArrayList<Integer>();
        for (ItemStack ingStack : requestList) {
            boolean isChecked = false;
            for (i = 0; i < stackList.size(); ++i) {
                if (slotIdList.contains(i) || !ingStack.m_150930_((s = (ItemStack)stackList.get(i)).m_41720_()) || s.m_41613_() < ingStack.m_41613_()) continue;
                slotIdList.add(i);
                resultList.add(ingStack);
                isChecked = true;
                break;
            }
            if (isChecked) continue;
            return false;
        }
        if (isSum) {
            return true;
        }
        IWand wand = info.getWand();
        if (this.mainSelectId != -1) {
            wand.setElement(stack, this.getSelectElement(this.mainSelectId).name());
        }
        if (this.subSelectId != -1) {
            wand.setSubElement(stack, this.getSelectElement(this.subSelectId).name());
        }
        this.mainSelectId = -1;
        this.subSelectId = -1;
        this.isCraft = true;
        this.craftTime = 0;
        this.maxCraftTime = this.getMaxCraftTime();
        this.setMF(this.getMF() - this.getRequestMF(setValue));
        this.copyMagic = stack.m_41777_();
        this.copyMagic.m_41764_(1);
        stack.m_41774_(1);
        this.mainMagic = this.getSubItem(0).m_41777_();
        this.subMagic = this.getSubItem(1).m_41777_();
        this.clickButton();
        this.sendPKT();
        for (ItemStack ingStack : resultList) {
            for (i = 0; i < stackList.size(); ++i) {
                s = (ItemStack)stackList.get(i);
                if (!ingStack.m_150930_(s.m_41720_()) || s.m_41613_() < ingStack.m_41613_()) continue;
                s.m_41774_(ingStack.m_41613_());
            }
        }
        return true;
    }

    public void craftFinish(ItemStack stack) {
        if (!ItemHelper.insertStack(this.getOutput(), this.copyMagic, true).m_41619_()) {
            return;
        }
        ItemHelper.insertStack(this.getOutput(), this.copyMagic.m_41777_(), false);
        this.canCraft = false;
        this.isCraft = false;
        this.craftTime = 0;
        this.nowTick = 0;
        this.mainMagic = this.subMagic = ItemStack.f_41583_;
        this.copyMagic = this.subMagic;
        this.playSound(this.getTilePos(), SoundEvents.f_12275_, 1.0f, 1.3f);
        this.m_58904_().m_46796_(2003, this.m_58899_().m_6630_(1), 0);
        this.sendPKT();
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
    }

    public void spawnParticle(Level world, BlockPos pos) {
        int i;
        float posX = (float)pos.m_123341_() + 0.5f;
        float posY = (float)pos.m_123342_() + 1.25f;
        float posZ = (float)pos.m_123343_() + 0.5f;
        SimpleParticleType par = ParticleInit.CYCLE_LIGHT;
        for (i = 0; i < 8; ++i) {
            this.spawnParticleCycle(world, (ParticleOptions)par, posX, posY, (double)posZ, 0.67, (float)i * 32.0f);
        }
        par = ParticleInit.DIVINE;
        for (i = 0; i < 2; ++i) {
            world.m_7106_((ParticleOptions)par, (double)(posX + this.getRandFloat(0.2f)), (double)posY, (double)(posZ + this.getRandFloat(0.2f)), (double)this.getRandFloat(0.075f), (double)0.1f, (double)this.getRandFloat(0.075f));
        }
    }

    protected void spawnParticleCycle(Level world, ParticleOptions par, double x, double y, double z, double range, double angle) {
        world.m_7106_(par, x, y, z, (double)Direction.UP.m_122411_(), range, angle + 6.0 - (double)(this.tickTime * 5));
    }

    public ItemStack getRequestStack(int selectID) {
        return new ItemStack((ItemLike)this.getMainRequestItem(this.getSelectElement(selectID)), this.getRequestSize());
    }

    public Item getMainRequestItem(SMElement ele) {
        return switch (ele) {
            case SMElement.FLAME -> ItemInit.fire_nasturtium_petal;
            case SMElement.FROST -> ItemInit.unmeltable_ice;
            case SMElement.CYCLON -> ItemInit.tiny_feather;
            case SMElement.LIGHTNING -> ItemInit.electronic_orb;
            case SMElement.EARTH -> ItemInit.sugarbell;
            case SMElement.SHINE -> ItemInit.prizmium;
            case SMElement.DARK -> ItemInit.stray_soul;
            case SMElement.WATER -> ItemInit.dm_flower;
            case SMElement.GRAVITY -> ItemInit.grav_powder;
            case SMElement.BLAST -> ItemInit.magic_meal;
            case SMElement.TOXIC -> ItemInit.poison_bottle;
            case SMElement.TIME -> ItemInit.clero_petal;
            case SMElement.ALL -> ItemInit.mf_bottle;
            default -> ItemInit.aether_crystal;
        };
    }

    public SMElement getSelectElement(int selectID) {
        return switch (selectID) {
            case 1 -> SMElement.FLAME;
            case 2 -> SMElement.FROST;
            case 3 -> SMElement.CYCLON;
            case 4 -> SMElement.LIGHTNING;
            case 5 -> SMElement.EARTH;
            case 6 -> SMElement.SHINE;
            case 7 -> SMElement.DARK;
            case 8 -> SMElement.WATER;
            case 9 -> SMElement.GRAVITY;
            case 10 -> SMElement.BLAST;
            case 11 -> SMElement.TOXIC;
            case 12 -> SMElement.TIME;
            case 13 -> SMElement.ALL;
            default -> SMElement.NON;
        };
    }

    public int getRequestSize() {
        return 64;
    }

    public int getMaxCraftTime() {
        return 40;
    }

    public List<ItemStack> getRequestList(WandInfo info) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.setRequestList(stackList, info, this.mainSelectId);
        this.setRequestList(stackList, info, this.subSelectId);
        return stackList;
    }

    public void setRequestList(List<ItemStack> stackList, WandInfo info, int selectID) {
        if (selectID == -1) {
            return;
        }
        stackList.add(new ItemStack((ItemLike)this.getMainRequestItem(this.getSelectElement(selectID)), this.getRequestSize()));
    }

    public int getRequestMF(int setValue) {
        return setValue == 2 ? this.getMaxMF() : this.getMaxMF() / 2;
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, this.maxCraftTime);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128365_("subInv", (Tag)this.subInv.serializeNBT());
        tag.m_128365_("copyMagic", (Tag)this.copyMagic.m_41739_(new CompoundTag()));
        tag.m_128365_("mainMagic", (Tag)this.mainMagic.m_41739_(new CompoundTag()));
        tag.m_128365_("subMagic", (Tag)this.subMagic.m_41739_(new CompoundTag()));
        tag.m_128405_("nowTick", this.nowTick);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("maxCraftTime", this.maxCraftTime);
        tag.m_128405_("mainSelectId", this.mainSelectId);
        tag.m_128405_("subSelectId", this.subSelectId);
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128379_("canCraft", this.canCraft);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outputInv.deserializeNBT(tag.m_128469_("outputInv"));
        this.subInv.deserializeNBT(tag.m_128469_("subInv"));
        this.copyMagic = ItemStack.m_41712_((CompoundTag)tag.m_128469_("copyMagic"));
        this.mainMagic = ItemStack.m_41712_((CompoundTag)tag.m_128469_("mainMagic"));
        this.subMagic = ItemStack.m_41712_((CompoundTag)tag.m_128469_("subMagic"));
        this.nowTick = tag.m_128451_("nowTick");
        this.craftTime = tag.m_128451_("craftTime");
        this.maxCraftTime = tag.m_128451_("maxCraftTime");
        this.mainSelectId = tag.m_128451_("mainSelectId");
        this.subSelectId = tag.m_128451_("subSelectId");
        this.isCraft = tag.m_128471_("isCraft");
        this.canCraft = tag.m_128471_("canCraft");
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 50000;
    }

    @Override
    public int getInvSize() {
        return 2;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutItem() {
        return this.getOutput().getStackInSlot(0);
    }

    public IItemHandler getSub() {
        return this.subInv;
    }

    public ItemStack getSubItem(int i) {
        return this.getSub().getStackInSlot(i);
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getInputItem());
        this.addStackList(stackList, this.getOutItem());
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getSubItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new WandReconstructMenu(windowId, inv, this);
    }
}

