/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.plugin.jade;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.sm.FruitLeaves;
import sweetmagic.init.tile.sm.TileSMMagic;

public class JadeDataProvider
implements IBlockComponentProvider,
ISMTip {
    public static final ResourceLocation PROVIDER = SweetMagicCore.getSRC("mf_provider");
    static final JadeDataProvider INSTANCE = new JadeDataProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor acce, IPluginConfig config) {
        BlockState state = acce.getBlockState();
        Block block = acce.getBlock();
        BlockEntity bEntity = acce.getBlockEntity();
        if (bEntity != null && bEntity instanceof TileSMMagic) {
            TileSMMagic tile = (TileSMMagic)bEntity;
            tooltip.add(tooltip.getElementHelper().item(new ItemStack((ItemLike)ItemInit.aether_crystal), 0.67f));
            tooltip.append((Component)this.getLabel("MF: " + this.format(tile.getMF()), GREEN));
        } else if (block instanceof ISMCrop) {
            ISMCrop crop = (ISMCrop)block;
            if (!(block instanceof FruitLeaves)) {
                this.addMaturityTooltip(tooltip, (float)((Integer)state.m_61143_((Property)crop.getSMMaxAge())).intValue() / (float)crop.getMaxBlockState());
            }
        }
    }

    private void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.crop_growth", (Object[])new Object[]{String.format("%.0f%%", Float.valueOf(growthValue))}));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.crop_growth", (Object[])new Object[]{this.getTip("tooltip.jade.crop_mature").m_130940_(GREEN)}));
        }
    }

    public ResourceLocation getUid() {
        return PROVIDER;
    }
}

