/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.plugin.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.plugin.jei.AbstractCategory;
import sweetmagic.plugin.jei.SMJeiPlugin;
import sweetmagic.recipe.feezer.FreezerRecipe;

public class FreezerCategory
extends AbstractCategory
implements IRecipeCategory<FreezerRecipe> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_freezer.png");
    private final IDrawableAnimated arrow;

    public FreezerCategory(IGuiHelper helper) {
        IDrawableStatic background = helper.createDrawable(TEX, 0, 0, 176, 106);
        IDrawable icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockInit.freezer));
        this.recipeType = helper.createDrawable(TEX, 0, 181, 176, 4);
        this.arrow = helper.drawableBuilder(TEX, 211, 14, 22, 15).buildAnimated(60, IDrawableAnimated.StartDirection.LEFT, false);
        this.setInfo((IDrawable)background, icon, "freezer");
    }

    public RecipeType<FreezerRecipe> getRecipeType() {
        return SMJeiPlugin.FREEZER;
    }

    public void setRecipe(IRecipeLayoutBuilder build, FreezerRecipe recipe, IFocusGroup focusGroup) {
        int i;
        List<Ingredient> ingredList = recipe.getIngredList();
        List<ItemStack> resultList = recipe.getResultList();
        int handCount = recipe.getCountList().get(0);
        ArrayList<ItemStack> handList = new ArrayList<ItemStack>();
        List<ItemStack> ingHandList = Arrays.asList(ingredList.get(0).m_43908_());
        for (ItemStack stack : ingHandList) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(handCount);
            handList.add(copy);
        }
        build.addSlot(RecipeIngredientRole.INPUT, 62, 11).addItemStacks(handList);
        for (i = 1; i < ingredList.size(); ++i) {
            int value = i - 1;
            boolean isSecond = value >= 3;
            int x = 53 + (isSecond ? 1 : 0) * 18;
            int y = 44 + (isSecond ? value - 3 : value) * 18;
            int count = recipe.getCountList().get(i);
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            List<ItemStack> ingStackList = Arrays.asList(ingredList.get(i).m_43908_());
            for (ItemStack stack : ingStackList) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(count);
                stackList.add(copy);
            }
            build.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(stackList);
        }
        for (i = 0; i < resultList.size(); ++i) {
            ItemStack stack = resultList.get(i);
            build.addSlot(RecipeIngredientRole.OUTPUT, 134, 8 + i * 18).addItemStack(stack);
        }
    }

    public void draw(FreezerRecipe recipe, IRecipeSlotsView slotsView, GuiGraphics pose, double mouseX, double mouseY) {
        this.recipeType.draw(pose, 0, 102);
        this.arrow.draw(pose, 99, 36);
    }
}

