/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.plugin.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.plugin.jei.AbstractCategory;
import sweetmagic.plugin.jei.SMJeiPlugin;
import sweetmagic.recipe.obmagia.ObMagiaRecipe;

public class ObMagiaCategory
extends AbstractCategory
implements IRecipeCategory<ObMagiaRecipe> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_obmagia.png");
    private final IDrawableAnimated arrow;

    public ObMagiaCategory(IGuiHelper helper) {
        IDrawableStatic background = helper.createDrawable(TEX, 0, 0, 178, 109);
        IDrawable icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockInit.obmagia));
        this.arrow = helper.drawableBuilder(TEX, 193, 1, 33, 13).buildAnimated(60, IDrawableAnimated.StartDirection.LEFT, false);
        this.setInfo((IDrawable)background, icon, "obmagia");
    }

    public RecipeType<ObMagiaRecipe> getRecipeType() {
        return SMJeiPlugin.OBMAGIA;
    }

    public void setRecipe(IRecipeLayoutBuilder build, ObMagiaRecipe recipe, IFocusGroup group) {
        Ingredient pageList = recipe.getPageList();
        Ingredient baseList = recipe.getBaseList();
        List<Ingredient> ingredList = recipe.getIngredList();
        ItemStack resultStack = recipe.getResultItem();
        this.addSlot(build, 126, 5, pageList);
        this.addSlot(build, 106, 5, baseList);
        this.addSlotList(build, 43, 49, recipe, ingredList, 0);
        this.addSlotList(build, 43, 11, recipe, ingredList, 1);
        this.addSlotList(build, 71, 21, recipe, ingredList, 2);
        this.addSlotList(build, 80, 49, recipe, ingredList, 3);
        this.addSlotList(build, 71, 76, recipe, ingredList, 4);
        this.addSlotList(build, 43, 86, recipe, ingredList, 5);
        this.addSlotList(build, 16, 76, recipe, ingredList, 6);
        this.addSlotList(build, 6, 49, recipe, ingredList, 7);
        this.addSlotList(build, 16, 21, recipe, ingredList, 8);
        build.addSlot(RecipeIngredientRole.OUTPUT, 148, 47).addItemStack(resultStack);
    }

    public void addSlotList(IRecipeLayoutBuilder builder, int x, int y, ObMagiaRecipe recipe, List<Ingredient> ingredList, int count) {
        if (count >= ingredList.size()) {
            return;
        }
        Ingredient ing = ingredList.get(count);
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        int handCount = recipe.getCountList().get(count);
        for (ItemStack stack : ing.m_43908_()) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(handCount);
            stackList.add(copy);
        }
        this.addSlot(builder, x, y, stackList);
    }

    public void addSlot(IRecipeLayoutBuilder build, int x, int y, Ingredient ing) {
        if (ing.m_43947_()) {
            return;
        }
        build.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(Arrays.asList(ing.m_43908_()));
    }

    public void addSlot(IRecipeLayoutBuilder builder, int x, int y, List<ItemStack> stackList) {
        if (stackList.isEmpty()) {
            return;
        }
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(stackList);
    }

    public void draw(ObMagiaRecipe recipe, IRecipeSlotsView view, GuiGraphics pose, double mouseX, double mouseY) {
        this.arrow.draw(pose, 105, 49);
        Font font = Minecraft.m_91087_().f_91062_;
        pose.m_280430_(font, (Component)this.getTipArray(this.getText("craft_time"), ":" + (float)recipe.getCraftTime() / 2.0f + "s"), 98, 80, 0xFFFFFF);
    }
}

