/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.plugin.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.MenuInit;
import sweetmagic.init.RecipeTypeInit;
import sweetmagic.init.tile.menu.SMBookMenu;
import sweetmagic.plugin.jei.AetherCraftTableInfo;
import sweetmagic.plugin.jei.AlstroemeriaCategory;
import sweetmagic.plugin.jei.BottleCategory;
import sweetmagic.plugin.jei.FreezerCategory;
import sweetmagic.plugin.jei.FrypanCategory;
import sweetmagic.plugin.jei.FurnitureCategory;
import sweetmagic.plugin.jei.IrisCategory;
import sweetmagic.plugin.jei.JuiceMakerCategory;
import sweetmagic.plugin.jei.MillRecipeCategory;
import sweetmagic.plugin.jei.ObMagiaCategory;
import sweetmagic.plugin.jei.OvenCategory;
import sweetmagic.plugin.jei.PedalCategory;
import sweetmagic.plugin.jei.PotCategory;
import sweetmagic.plugin.jei.RecyclerCategory;
import sweetmagic.plugin.jei.SMRecipes;
import sweetmagic.plugin.jei.TankCategory;
import sweetmagic.plugin.jei.TradeCategory;
import sweetmagic.plugin.jei.WoddCutterCategory;
import sweetmagic.recipe.alstrameria.AlstroemeriaRecipe;
import sweetmagic.recipe.bottle.BottleRecipe;
import sweetmagic.recipe.feezer.FreezerRecipe;
import sweetmagic.recipe.frypan.FrypanRecipe;
import sweetmagic.recipe.furniture.FurnitureRecipe;
import sweetmagic.recipe.iris.IrisRecipe;
import sweetmagic.recipe.juice_maker.JuiceMakerRecipe;
import sweetmagic.recipe.mill.MillRecipe;
import sweetmagic.recipe.obmagia.ObMagiaRecipe;
import sweetmagic.recipe.oven.OvenRecipe;
import sweetmagic.recipe.pedal.PedalRecipe;
import sweetmagic.recipe.pot.PotRecipe;
import sweetmagic.recipe.recycler.RecyclerRecipe;
import sweetmagic.recipe.tank.TankRecipe;
import sweetmagic.recipe.trade.TradeRecipe;
import sweetmagic.recipe.woodcutter.WoodCutterRecipe;

@JeiPlugin
public class SMJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = SweetMagicCore.getSRC("sm_jei");
    public static final RecipeType<AlstroemeriaRecipe> ALSTROEMERIA = SMJeiPlugin.create("alstroemeria", AlstroemeriaRecipe.class);
    public static final RecipeType<ObMagiaRecipe> OBMAGIA = SMJeiPlugin.create("obmagia", ObMagiaRecipe.class);
    public static final RecipeType<IrisRecipe> IRIS = SMJeiPlugin.create("iris", IrisRecipe.class);
    public static final RecipeType<MillRecipe> MILL = SMJeiPlugin.create("mill", MillRecipe.class);
    public static final RecipeType<OvenRecipe> OVEN = SMJeiPlugin.create("oven", OvenRecipe.class);
    public static final RecipeType<BottleRecipe> BOTTLE = SMJeiPlugin.create("bottle", BottleRecipe.class);
    public static final RecipeType<FrypanRecipe> FRYPAN = SMJeiPlugin.create("frypan", FrypanRecipe.class);
    public static final RecipeType<PotRecipe> POT = SMJeiPlugin.create("pot", PotRecipe.class);
    public static final RecipeType<PedalRecipe> PEDAL = SMJeiPlugin.create("pedal", PedalRecipe.class);
    public static final RecipeType<TankRecipe> TANK = SMJeiPlugin.create("tank", TankRecipe.class);
    public static final RecipeType<FreezerRecipe> FREEZER = SMJeiPlugin.create("freezer", FreezerRecipe.class);
    public static final RecipeType<JuiceMakerRecipe> JUICEMAKER = SMJeiPlugin.create("juicemaker", JuiceMakerRecipe.class);
    public static final RecipeType<FurnitureRecipe> FURNITURE = SMJeiPlugin.create("furniture", FurnitureRecipe.class);
    public static final RecipeType<RecyclerRecipe> RECYCLER = SMJeiPlugin.create("recycler", RecyclerRecipe.class);
    public static final RecipeType<WoodCutterRecipe> WOODCUTTER = SMJeiPlugin.create("woodcutter", WoodCutterRecipe.class);
    public static final RecipeType<TradeRecipe> TRADE = SMJeiPlugin.create("trade", TradeRecipe.class);

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new AlstroemeriaCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ObMagiaCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new IrisCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MillRecipeCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new OvenCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BottleCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FrypanCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PotCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PedalCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new TankCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FreezerCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new JuiceMakerCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FurnitureCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RecyclerCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new WoddCutterCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new TradeCategory(helper)});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        SMRecipes recipe = new SMRecipes();
        registry.addRecipes(ALSTROEMERIA, recipe.getRecipe(RecipeTypeInit.ALSTROMERIA));
        registry.addRecipes(OBMAGIA, recipe.getRecipe(RecipeTypeInit.OBMAGIA));
        registry.addRecipes(MILL, recipe.getRecipe(RecipeTypeInit.MILL));
        registry.addRecipes(OVEN, recipe.getRecipe(RecipeTypeInit.OVEN));
        registry.addRecipes(BOTTLE, recipe.getRecipe(RecipeTypeInit.BOTTLE));
        registry.addRecipes(FRYPAN, recipe.getRecipe(RecipeTypeInit.FRYPAN));
        registry.addRecipes(POT, recipe.getRecipe(RecipeTypeInit.POT));
        registry.addRecipes(IRIS, recipe.getRecipe(RecipeTypeInit.IRIS));
        registry.addRecipes(PEDAL, recipe.getRecipe(RecipeTypeInit.PEDAL));
        registry.addRecipes(TANK, recipe.getRecipe(RecipeTypeInit.TANK));
        registry.addRecipes(FREEZER, recipe.getRecipe(RecipeTypeInit.FREEZER));
        registry.addRecipes(JUICEMAKER, recipe.getRecipe(RecipeTypeInit.JUICEMAKER));
        registry.addRecipes(FURNITURE, recipe.getRecipe(RecipeTypeInit.FURNITURE));
        registry.addRecipes(RECYCLER, recipe.getRecipe(RecipeTypeInit.RECYCLER));
        registry.addRecipes(WOODCUTTER, recipe.getRecipe(RecipeTypeInit.WOODCUTTER));
        registry.addRecipes(TRADE, recipe.getRecipe(RecipeTypeInit.TRADE));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.twilight_alstroemeria), new RecipeType[]{ALSTROEMERIA});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.obmagia), new RecipeType[]{OBMAGIA});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.iris_creation), new RecipeType[]{IRIS});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.oven), new RecipeType[]{OVEN});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.mill), new RecipeType[]{MILL});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.bottle), new RecipeType[]{BOTTLE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.frypan_r), new RecipeType[]{FRYPAN});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.pot_w), new RecipeType[]{POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.single_pot_r), new RecipeType[]{POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.pedestal_creat), new RecipeType[]{PEDAL});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.altar_creat), new RecipeType[]{PEDAL});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.altar_creation_star), new RecipeType[]{PEDAL});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.mftank), new RecipeType[]{TANK});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.mftank_adavance), new RecipeType[]{TANK});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.mftank_master), new RecipeType[]{TANK});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.mftank_creative), new RecipeType[]{TANK});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.freezer), new RecipeType[]{FREEZER});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.juice_maker), new RecipeType[]{JUICEMAKER});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.furniture_processing_table), new RecipeType[]{FURNITURE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.aether_recycler), new RecipeType[]{RECYCLER});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.mf_woodcutter), new RecipeType[]{WOODCUTTER});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.note_pc_b), new RecipeType[]{TRADE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.chopping_board), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.mffurnace), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockInit.furniture_processing_table), new RecipeType[]{RecipeTypes.STONECUTTING});
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public static <T> RecipeType<T> create(String name, Class<? extends T> recipeClass) {
        return RecipeType.create((String)"sweetmagic", (String)name, recipeClass);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration regist) {
        regist.addRecipeTransferHandler(SMBookMenu.class, MenuInit.bookMenu, RecipeTypes.CRAFTING, 1, 9, 10, 36);
        regist.addRecipeTransferHandler((IRecipeTransferInfo)new AetherCraftTableInfo());
    }
}

