/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.plugin.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.api.iitem.IMagicItem;
import sweetmagic.api.iitem.ITier;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.plugin.jei.AbstractCategory;
import sweetmagic.plugin.jei.SMJeiPlugin;
import sweetmagic.recipe.trade.TradeRecipe;

public class TradeCategory
extends AbstractCategory
implements IRecipeCategory<TradeRecipe> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_pc.png");
    private IDrawable tradeType;
    private final IGuiHelper helper;
    private static final ItemStack SEED = new ItemStack((ItemLike)ItemInit.sugarbell);
    private static final ItemStack MAGIC = new ItemStack((ItemLike)ItemInit.aether_crystal);
    private static final ItemStack FURNITURE = new ItemStack((ItemLike)BlockInit.wood_chest);
    private static final ItemStack VANILLA = new ItemStack((ItemLike)Items.f_151049_);
    private static final ItemStack SEASONING = new ItemStack((ItemLike)ItemInit.flour);

    public TradeCategory(IGuiHelper helper) {
        IDrawableStatic background = helper.createDrawable(TEX, 0, 0, 88, 28);
        IDrawable icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockInit.note_pc_b));
        this.helper = helper;
        this.setInfo((IDrawable)background, icon, "trade");
    }

    public RecipeType<TradeRecipe> getRecipeType() {
        return SMJeiPlugin.TRADE;
    }

    public void setRecipe(IRecipeLayoutBuilder build, TradeRecipe recipe, IFocusGroup group) {
        List<Ingredient> ingredList = recipe.getIngredList();
        ArrayList<ItemStack> handList = new ArrayList<ItemStack>();
        int count = recipe.getCountList().get(0);
        for (ItemStack hand : ingredList.get(0).m_43908_()) {
            ItemStack copy = hand.m_41777_();
            copy.m_41764_(count);
            handList.add(copy);
        }
        ((IRecipeSlotBuilder)build.addSlot(RecipeIngredientRole.OUTPUT, 66, 6).addItemStacks(handList)).addTooltipCallback((view, tip) -> {
            int min = this.getMin(recipe, (ItemStack)view.getDisplayedItemStack().get());
            tip.add(1, this.getText("trade_price", this.format(min)).m_130940_(GOLD));
        });
    }

    public void draw(TradeRecipe recipe, IRecipeSlotsView view, GuiGraphics pose, double mouseX, double mouseY) {
        this.tradeType = this.helper.createDrawableItemStack(this.getStack(recipe.getTradeType()));
        this.tradeType.draw(pose, 6, 6);
    }

    public List<Component> getTooltipStrings(TradeRecipe recipe, IRecipeSlotsView view, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (this.isRender(mouseX, mouseY, 6, 6, 24, 24)) {
            tooltip.add((Component)this.getText("trade_tab", this.getText("trade_" + recipe.getTradeType()).getString()));
        }
        return tooltip;
    }

    public boolean isRender(double mouseX, double mouseY, int minX, int minY, int maxX, int maxY) {
        return (double)minX <= mouseX && mouseX <= (double)maxX && (double)minY <= mouseY && mouseY <= (double)maxY;
    }

    public int getMin(TradeRecipe recipe, ItemStack stack) {
        int value = recipe.getValueList().get(0);
        return switch (recipe.getTradeType()) {
            case "furniture" -> this.getMagicMin(stack, 1.0f, value);
            case "magic" -> this.getMagicMin(stack, 1.5f, value);
            case "vanilla" -> this.getVanila(stack, value);
            case "seed" -> this.getSeed(stack, value);
            default -> value;
        };
    }

    public int getMagicMin(ItemStack stack, float rate, int price) {
        Item item = stack.m_41720_();
        int mf = SweetMagicAPI.getMF(stack) + price;
        if (mf <= 0 && item instanceof ITier) {
            ITier ti = (ITier)item;
            int addRate = item instanceof IMagicItem ? Math.max(3, ti.getTier()) : 1;
            mf = 100 + (150 + price) * ti.getTier() * ti.getTier() * addRate;
        }
        return (int)((float)mf * rate);
    }

    public int getVanila(ItemStack stack, int price) {
        Item item = stack.m_41720_();
        if (SweetMagicAPI.hasMF(item)) {
            return SweetMagicAPI.getMF(stack) + price;
        }
        return price;
    }

    public int getSeed(ItemStack stack, int price) {
        ITier ti;
        Item item = stack.m_41720_();
        if (item instanceof ITier && (ti = (ITier)item).getTier() > 0) {
            return 1000 + price + 500 * ti.getTier() * ti.getTier();
        }
        return price;
    }

    public ItemStack getStack(String tradeType) {
        return switch (tradeType) {
            case "furniture" -> FURNITURE;
            case "magic" -> MAGIC;
            case "seasoning" -> SEASONING;
            case "vanilla" -> VANILLA;
            default -> SEED;
        };
    }
}

