/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.base;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import sweetmagic.recipe.RecipeInfo;
import sweetmagic.recipe.RecipeMathCheck;

public abstract class AbstractRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected List<Ingredient> resultIngList;
    protected final List<ItemStack> resultList;
    protected List<ItemStack> requestStackList = new ArrayList<ItemStack>();
    protected boolean tagResult = false;

    public AbstractRecipe(ResourceLocation id, List<ItemStack> resultList, List<Ingredient> ingredList, List<Integer> countList) {
        this.id = id;
        this.resultList = resultList;
        this.setingredList(new ArrayList<Ingredient>(ingredList));
        this.setCountList(countList);
        if (resultList.isEmpty()) {
            throw new IllegalArgumentException("Recipe has no result: " + id.toString());
        }
        if (ingredList.isEmpty()) {
            throw new IllegalArgumentException("Recipe has no ingredients: " + id.toString());
        }
    }

    public AbstractRecipe(ResourceLocation id, List<Ingredient> ingredList, List<Integer> countList, boolean flag) {
        this.id = id;
        this.resultList = new ArrayList<ItemStack>();
        this.setingredList(new ArrayList<Ingredient>(ingredList));
        this.setCountList(countList);
        this.tagResult = true;
        if (ingredList.isEmpty()) {
            throw new IllegalArgumentException("Recipe has no ingredients: " + id.toString());
        }
    }

    public AbstractRecipe(ResourceLocation id, List<Ingredient> ingredList) {
        this.id = id;
        this.resultList = new ArrayList<ItemStack>();
        this.setingredList(new ArrayList<Ingredient>(ingredList));
        if (ingredList.isEmpty()) {
            throw new IllegalArgumentException("Recipe has no ingredients: " + id.toString());
        }
    }

    public boolean m_5818_(Container con, Level world) {
        throw new UnsupportedOperationException("Use a method that takes a List<ItemStack> as an argument.");
    }

    public ItemStack m_5874_(Container con, RegistryAccess acce) {
        throw new UnsupportedOperationException("Use a method that takes a List<ItemStack> as an argument.");
    }

    public boolean m_8004_(int width, int height) {
        throw new UnsupportedOperationException();
    }

    public boolean matches(List<ItemStack> stackList) {
        boolean isComplet;
        RecipeInfo recipeInfo = RecipeMathCheck.checkRecipe(stackList, this.getIngredList(), this.getCountList());
        boolean bl = isComplet = recipeInfo != null && recipeInfo.isCompleted();
        if (isComplet) {
            this.requestStackList = recipeInfo.getStackList();
        }
        return isComplet;
    }

    public List<ItemStack> getResultList() {
        return new ArrayList<ItemStack>(this.resultList);
    }

    public void setResultIngList(List<Ingredient> ingreadList) {
        this.resultIngList = ingreadList;
    }

    public List<Ingredient> getResultIngList() {
        return new ArrayList<Ingredient>(this.resultIngList);
    }

    public ItemStack m_8043_(RegistryAccess acce) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.resultList.get(0).m_41777_();
    }

    public List<ItemStack> getRequestList() {
        return this.requestStackList;
    }

    public abstract List<Ingredient> getIngredList();

    public abstract void setingredList(List<Ingredient> var1);

    public abstract List<Integer> getCountList();

    public abstract void setCountList(List<Integer> var1);

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean isTagResult() {
        return this.tagResult;
    }

    public static <C extends Container, T extends Recipe<C>> Stream<T> getRecipe(Level world, RecipeType<T> recipeType) {
        return world.m_7465_().m_44013_(recipeType).stream();
    }

    public abstract RecipeSerializer<?> m_7707_();

    public abstract RecipeType<?> m_6671_();
}

