/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.mill;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import sweetmagic.recipe.base.AbstractRecipeSerializer;
import sweetmagic.recipe.mill.MillRecipe;

public class MillRecipeSeria
extends AbstractRecipeSerializer
implements RecipeSerializer<MillRecipe> {
    public MillRecipe fromJson(ResourceLocation id, JsonObject json) {
        List<ItemStack> resultList = this.readResultList(json, "result");
        List<Float> chanceList = this.readChanceList(json, "result");
        List<Ingredient> ingredList = this.readIngredList(json, "ingredients");
        List<Integer> countList = this.readCountList(json, "ingredients");
        return new MillRecipe(id, resultList, chanceList, ingredList, countList);
    }

    @Nullable
    public MillRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        List<ItemStack> resultList = this.loadStackList(buf);
        List<Float> chanceList = this.loadFltList(buf);
        List<Ingredient> ingredList = this.loadIngList(buf);
        List<Integer> countList = this.loadIntList(buf);
        return new MillRecipe(id, resultList, chanceList, ingredList, countList);
    }

    public void toNetwork(FriendlyByteBuf buf, MillRecipe recipe) {
        this.saveStackList(buf, recipe.getResultList());
        this.saveFltList(buf, recipe.getChanceList());
        this.saveIngList(buf, recipe.getIngredList());
        this.saveIntList(buf, recipe.getCountList());
    }
}

