/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.obmagia;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import sweetmagic.init.RecipeSerializerInit;
import sweetmagic.init.RecipeTypeInit;
import sweetmagic.recipe.RecipeInfo;
import sweetmagic.recipe.RecipeMathCheck;
import sweetmagic.recipe.base.AbstractRecipe;

public class ObMagiaRecipe
extends AbstractRecipe {
    protected List<Ingredient> ingredList;
    protected List<Integer> countList;
    protected Ingredient pageList;
    protected Ingredient baseList;
    protected ItemStack requestPage;
    protected ItemStack requestBase;
    protected int craftTime;

    public ObMagiaRecipe(ResourceLocation id, ItemStack result, Ingredient pageList, Ingredient baseList, List<Ingredient> ingredList, List<Integer> countList, int craftTime) {
        super(id, Arrays.asList(result), ingredList, countList);
        this.pageList = pageList;
        this.baseList = baseList;
        this.setCraftTime(craftTime);
    }

    public static Optional<ObMagiaRecipe> getRecipe(Level world, List<ItemStack> ingredList, ItemStack page, ItemStack base) {
        return AbstractRecipe.getRecipe(world, RecipeTypeInit.OBMAGIA).filter(t -> t.matches(ingredList, page, base)).findFirst();
    }

    public boolean matches(List<ItemStack> stackList, ItemStack page, ItemStack base) {
        boolean isComplet;
        RecipeInfo recipeInfo = RecipeMathCheck.checkObMagiaRecipe(stackList, page, base, this.getIngredList(), this.getCountList(), this.pageList, this.baseList);
        boolean bl = isComplet = recipeInfo != null && recipeInfo.isCompleted();
        if (isComplet) {
            this.requestStackList = recipeInfo.getStackList();
            this.setPage(recipeInfo.getPage());
            this.setBase(recipeInfo.getBase());
        }
        return isComplet;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializerInit.OBMAGIA;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RecipeTypeInit.OBMAGIA;
    }

    @Override
    public List<Ingredient> getIngredList() {
        return this.ingredList;
    }

    @Override
    public void setingredList(List<Ingredient> ingreadList) {
        this.ingredList = ingreadList;
    }

    @Override
    public List<Integer> getCountList() {
        return this.countList;
    }

    @Override
    public void setCountList(List<Integer> countList) {
        this.countList = countList;
    }

    public Ingredient getPageList() {
        return this.pageList;
    }

    public ItemStack getPage() {
        return this.requestPage;
    }

    public void setPage(ItemStack page) {
        this.requestPage = page;
    }

    public Ingredient getBaseList() {
        return this.baseList;
    }

    public ItemStack getBase() {
        return this.requestBase;
    }

    public void setBase(ItemStack base) {
        this.requestBase = base;
    }

    public int getCraftTime() {
        return this.craftTime;
    }

    public void setCraftTime(int craftTime) {
        this.craftTime = craftTime;
    }
}

