/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.obmagia;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import sweetmagic.recipe.base.AbstractRecipeSerializer;
import sweetmagic.recipe.obmagia.ObMagiaRecipe;

public class ObMagiaRecipeSeria
extends AbstractRecipeSerializer
implements RecipeSerializer<ObMagiaRecipe> {
    public ObMagiaRecipe fromJson(ResourceLocation id, JsonObject json) {
        ItemStack result = this.readStack(json, "result");
        Ingredient page = this.readIngredList(json, "page").get(0);
        Ingredient base = this.readIngredList(json, "base").get(0);
        int craftTime = this.readIntValue(json, 10, "crafttime", "time");
        List<Ingredient> ingredList = this.readIngredList(json, "ingredients");
        List<Integer> countList = this.readCountList(json, "ingredients");
        return new ObMagiaRecipe(id, result, page, base, ingredList, countList, craftTime);
    }

    @Nullable
    public ObMagiaRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        ItemStack result = buf.m_130267_();
        Ingredient page = Ingredient.m_43940_((FriendlyByteBuf)buf);
        Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buf);
        List<Ingredient> ingredList = this.loadIngList(buf);
        List<Integer> countList = this.loadIntList(buf);
        int craftTime = buf.m_130242_();
        return new ObMagiaRecipe(id, result, page, base, ingredList, countList, craftTime);
    }

    public void toNetwork(FriendlyByteBuf buf, ObMagiaRecipe recipe) {
        buf.m_130055_(recipe.getResultItem());
        recipe.pageList.m_43923_(buf);
        recipe.baseList.m_43923_(buf);
        this.saveIngList(buf, recipe.getIngredList());
        this.saveIntList(buf, recipe.getCountList());
        buf.m_130130_(recipe.getCraftTime());
    }
}

