/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.recycler;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import sweetmagic.init.RecipeSerializerInit;
import sweetmagic.init.RecipeTypeInit;
import sweetmagic.recipe.base.AbstractRecipe;

public class RecyclerRecipe
extends AbstractRecipe {
    protected List<Ingredient> ingredList;
    protected List<Integer> countList;
    protected List<Float> chanceList;

    public RecyclerRecipe(ResourceLocation id, List<Ingredient> resultIngList, List<Float> chanceList, List<Ingredient> ingredList, List<Integer> countList) {
        super(id, ingredList, countList, true);
        this.setResultIngList((List<Ingredient>)ImmutableList.copyOf(resultIngList));
        this.setChanceList(chanceList);
        if (resultIngList.isEmpty()) {
            throw new IllegalArgumentException("Recipe has no result: " + id.toString());
        }
    }

    public static Optional<RecyclerRecipe> getRecipe(Level world, List<ItemStack> ingredList) {
        return AbstractRecipe.getRecipe(world, RecipeTypeInit.RECYCLER).filter(t -> t.matches(ingredList)).findFirst();
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializerInit.RECYCLER;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RecipeTypeInit.RECYCLER;
    }

    @Override
    public ItemStack getResultItem() {
        return this.getResultIngList().get(0).m_43908_()[0].m_41777_();
    }

    public List<Float> getChanceList() {
        return this.chanceList;
    }

    public void setChanceList(List<Float> chanceList) {
        this.chanceList = chanceList;
    }

    @Override
    public List<Ingredient> getIngredList() {
        return this.ingredList;
    }

    @Override
    public void setingredList(List<Ingredient> ingreadList) {
        this.ingredList = ingreadList;
    }

    @Override
    public List<Integer> getCountList() {
        return this.countList;
    }

    @Override
    public void setCountList(List<Integer> countList) {
        this.countList = countList;
    }
}

