/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.recycler;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import sweetmagic.recipe.base.AbstractRecipeSerializer;
import sweetmagic.recipe.recycler.RecyclerRecipe;

public class RecyclerRecipeSeria
extends AbstractRecipeSerializer
implements RecipeSerializer<RecyclerRecipe> {
    public RecyclerRecipe fromJson(ResourceLocation id, JsonObject json) {
        List<Ingredient> resultList = this.readIngredList(json, "result");
        List<Float> chanceList = this.readChanceList(json, "result");
        List<Ingredient> ingredList = this.readIngredList(json, "ingredients");
        List<Integer> countList = this.readCountList(json, "ingredients");
        return new RecyclerRecipe(id, resultList, chanceList, ingredList, countList);
    }

    @Nullable
    public RecyclerRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        List<Ingredient> resultList = this.loadIngList(buf);
        List<Float> resultChanceList = this.loadFltList(buf);
        List<Ingredient> ingredList = this.loadIngList(buf);
        List<Integer> countList = this.loadIntList(buf);
        return new RecyclerRecipe(id, resultList, resultChanceList, ingredList, countList);
    }

    public void toNetwork(FriendlyByteBuf buf, RecyclerRecipe recipe) {
        this.saveIngList(buf, recipe.getResultIngList());
        this.saveFltList(buf, recipe.getChanceList());
        this.saveIngList(buf, recipe.getIngredList());
        this.saveIntList(buf, recipe.getCountList());
    }
}

