/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.tank;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import sweetmagic.recipe.base.AbstractRecipeSerializer;
import sweetmagic.recipe.tank.TankRecipe;

public class TankRecipeSeria
extends AbstractRecipeSerializer
implements RecipeSerializer<TankRecipe> {
    public TankRecipe fromJson(ResourceLocation id, JsonObject json) {
        List<ItemStack> resultList = this.readResultList(json, "result");
        List<Ingredient> ingredList = this.readIngredList(json, "ingredients");
        List<Integer> countList = this.readCountList(json, "ingredients");
        List<Integer> mfList = this.readIntList(json, "result", "mf", 0);
        return new TankRecipe(id, resultList, ingredList, countList, mfList);
    }

    @Nullable
    public TankRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        List<ItemStack> resultList = this.loadStackList(buf);
        List<Ingredient> ingredList = this.loadIngList(buf);
        List<Integer> countList = this.loadIntList(buf);
        List<Integer> mfList = this.loadIntList(buf);
        return new TankRecipe(id, resultList, ingredList, countList, mfList);
    }

    public void toNetwork(FriendlyByteBuf buf, TankRecipe recipe) {
        this.saveStackList(buf, recipe.getResultList());
        this.saveIngList(buf, recipe.getIngredList());
        this.saveIntList(buf, recipe.getCountList());
        this.saveIntList(buf, recipe.getMFList());
    }
}

