/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.util;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.magic.SturdustCrystal;
import sweetmagic.init.block.sm.MagiaPortal;
import sweetmagic.util.WorldHelper;

public record DimentionTeleporter(Block portal, Block flame, Direction.Axis face, boolean isZ) implements ITeleporter
{
    private static final Direction[] FACE_ARRAY = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public boolean isVanilla() {
        return false;
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
        destWorld.m_5594_((Player)player, player.m_20183_(), SoundEvents.f_12287_, SoundSource.BLOCKS, 0.25f, 1.0f);
        return false;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel world, Function<ServerLevel, PortalInfo> info) {
        ServerPlayer player;
        BlockPos resPawnpos;
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity living = (LivingEntity)entity;
        living.m_20091_();
        ChunkPos chunk = new ChunkPos(entity.m_20183_());
        int chunkX = chunk.f_45578_;
        int chunkZ = chunk.f_45579_;
        int min = world.m_141937_();
        int max = world.m_151558_();
        for (int currentX = chunkX - 2; currentX < chunkX + 2; ++currentX) {
            for (int currentZ = chunkZ - 2; currentZ < chunkZ + 2; ++currentZ) {
                BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
                int baseX = currentX * 16;
                int baseZ = currentZ * 16;
                for (int y = min; y < max; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            BlockPos.MutableBlockPos mut2 = mut.m_122178_(baseX + x, y, baseZ + z);
                            if (world.m_46859_((BlockPos)mut2) || !world.m_8055_((BlockPos)mut2).m_60713_(this.portal) || !this.isCenter((Level)world, mut2)) continue;
                            BlockState state = world.m_8055_((BlockPos)mut2);
                            float addY = state.m_61138_(MagiaPortal.AXIS) && state.m_61143_(MagiaPortal.AXIS) == Direction.Axis.Y ? 1.5f : 0.0f;
                            return new PortalInfo(new Vec3((double)mut2.m_123341_() + entity.m_20185_() % 1.0, (double)((float)(mut2.m_123342_() - (this.isBlockPortal(world, mut2.m_123341_(), mut2.m_123342_() - 1, mut2.m_123343_()) ? 1 : 0)) + addY), (double)mut2.m_123343_() + entity.m_20189_() % 1.0), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
                        }
                    }
                }
            }
        }
        if (entity instanceof ServerPlayer && (resPawnpos = (player = (ServerPlayer)entity).m_8961_()) != null && player.m_8963_() == world.m_46472_()) {
            return new PortalInfo(new Vec3((double)resPawnpos.m_123341_(), (double)resPawnpos.m_123342_(), (double)resPawnpos.m_123343_()), Vec3.f_82478_, player.m_8962_(), player.m_8962_());
        }
        BlockPos entityPos = entity.m_20183_();
        BlockPos.MutableBlockPos pos = new BlockPos(entityPos.m_123341_(), world.m_141928_() - 8, entityPos.m_123343_()).m_122032_();
        while (world.m_46859_((BlockPos)pos)) {
            pos.m_122173_(Direction.DOWN);
        }
        pos.m_122173_(Direction.UP);
        for (int addX = -3; addX < 3; ++addX) {
            for (int addY = -1; addY < 5; ++addY) {
                for (int addZ = -2; addZ < 3; ++addZ) {
                    BlockPos targetPos;
                    BlockPos blockPos = targetPos = this.isZ ? WorldHelper.offset((BlockPos)pos, addX, addY, addZ) : WorldHelper.offset((BlockPos)pos, addZ, addY, addX);
                    if (world.m_8055_(targetPos).m_60713_(BlockInit.sturdust_crystal)) continue;
                    world.m_46961_((BlockPos)pos, false);
                    world.m_7471_((BlockPos)pos, false);
                }
            }
        }
        Map<BlockPos, BlockState> posMap = this.isZ ? SturdustCrystal.getZPosMap((BlockPos)pos) : SturdustCrystal.getXPosMap((BlockPos)pos);
        posMap.forEach((key, val) -> world.m_7731_(key, val, 3));
        pos = pos.m_122173_(Direction.WEST);
        if (this.face == Direction.Axis.Y) {
            pos.m_6630_(2);
        }
        return new PortalInfo(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    public boolean isBlockPortal(ServerLevel world, int x, int y, int z) {
        return world.m_8055_(new BlockPos(x, y, z)).m_60734_() == this.portal;
    }

    public boolean isCenter(Level world, BlockPos.MutableBlockPos pos) {
        return world.m_8055_(pos.m_121945_(FACE_ARRAY[0])).m_60713_(this.portal) && world.m_8055_(pos.m_121945_(FACE_ARRAY[1])).m_60713_(this.portal) || world.m_8055_(pos.m_121945_(FACE_ARRAY[2])).m_60713_(this.portal) && world.m_8055_(pos.m_121945_(FACE_ARRAY[3])).m_60713_(this.portal);
    }
}

