/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.util;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.block.sm.MagiaPortal;

public record FaceAABB(double x1, double y1, double z1, double x2, double y2, double z2) {
    public static VoxelShape[] create(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new FaceAABB(x1, y1, z1, x2, y2, z2).getRotatedBounds();
    }

    public static VoxelShape getAABB(VoxelShape[] aabbArray, BlockState state) {
        return aabbArray[((Direction)state.m_61143_((Property)BaseFaceBlock.FACING)).m_122411_() - 2];
    }

    public static VoxelShape getAABBUP(VoxelShape[] aabbArray, BlockState state) {
        return aabbArray[((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122411_() - 2];
    }

    public static VoxelShape getAABB(VoxelShape[] aabbArray, VoxelShape aabb, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(MagiaPortal.AXIS);
        int value = 0;
        switch (axis) {
            case X: {
                value = 2;
                break;
            }
            case Y: {
                return aabb;
            }
        }
        return aabbArray[value];
    }

    public VoxelShape[] getRotatedBounds() {
        VoxelShape north = this.getBlockAABB(Direction.NORTH, this);
        VoxelShape south = this.getBlockAABB(Direction.SOUTH, this);
        VoxelShape west = this.getBlockAABB(Direction.WEST, this);
        VoxelShape east = this.getBlockAABB(Direction.EAST, this);
        return new VoxelShape[]{north, south, west, east};
    }

    public VoxelShape getBlockAABB(Direction face, FaceAABB aabb) {
        double[] fixeAABB = this.fixRot(face, aabb.x1, aabb.z1, aabb.x2, aabb.z2);
        return Block.m_49796_((double)fixeAABB[0], (double)aabb.y1, (double)fixeAABB[1], (double)fixeAABB[2], (double)aabb.y2, (double)fixeAABB[3]);
    }

    private double[] fixRot(Direction face, double var1, double var2, double var3, double var4) {
        switch (face) {
            case SOUTH: {
                double sVar1 = var1;
                double sVar2 = var2;
                var1 = 16.0 - var3;
                var2 = 16.0 - var4;
                var3 = 16.0 - sVar1;
                var4 = 16.0 - sVar2;
                break;
            }
            case WEST: {
                double wVar1 = var1;
                var1 = var2;
                var2 = 16.0 - var3;
                var3 = var4;
                var4 = 16.0 - wVar1;
                break;
            }
            case EAST: {
                double eVar1 = var1;
                double eVar2 = var2;
                double eVar3 = var3;
                var1 = 16.0 - var4;
                var2 = eVar1;
                var3 = 16.0 - eVar2;
                var4 = eVar3;
            }
        }
        return new double[]{var1, var2, var3, var4};
    }
}

