/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ItemHelper {
    public static final Comparator<ItemStack> ITEMSTACK_ASCENDING = (s1, s2) -> {
        if (s1.m_41619_() && s2.m_41619_()) {
            return 0;
        }
        if (s1.m_41619_()) {
            return 1;
        }
        if (s2.m_41619_()) {
            return -1;
        }
        if (s1.m_41720_() != s2.m_41720_()) {
            return s1.m_41613_() - s2.m_41613_();
        }
        return Item.m_41393_((Item)s1.m_41720_()) - Item.m_41393_((Item)s2.m_41720_());
    };

    public static boolean compactInventory(IItemHandlerModifiable inv) {
        List<ItemStack> stackList = new ArrayList();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stackList.add(stack);
            inv.setStackInSlot(i, ItemStack.f_41583_);
        }
        stackList = stackList.stream().sorted((s1, s2) -> ItemHelper.sortItemStack(s1, s2)).toList();
        stackList.forEach(s -> ItemHelper.insertStack((IItemHandler)inv, s, false));
        return stackList.isEmpty();
    }

    public static ItemStack insertStack(IItemHandler inv, ItemStack stack, boolean simulate) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)simulate);
    }

    public static void inventoryInput(Player player, IItemHandlerModifiable inv) {
        ItemHelper.inventoryInput(player, inv, false);
    }

    public static void inventoryInput(Player player, IItemHandlerModifiable inv, boolean flag) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stackList.add(stack);
            itemList.add(stack.m_41720_());
        }
        List<ItemStack> pInveList = player.m_150109_().f_35974_.stream().filter(s -> itemList.contains(s.m_41720_())).toList();
        if (flag) {
            pInveList = pInveList.stream().filter(s -> !s.m_150930_(player.m_21205_().m_41720_())).toList();
        }
        for (ItemStack s2 : pInveList) {
            ItemStack st = ItemHelper.insertStack((IItemHandler)inv, s2.m_41777_(), false);
            s2.m_41764_(st.m_41613_());
        }
    }

    public static void inventoryOutput(Player player, IItemHandlerModifiable inv) {
        ArrayList<ItemStack> pInveList = new ArrayList<ItemStack>();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_()) continue;
            pInveList.add(stack);
            itemList.add(stack.m_41720_());
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack;
            stack = inv.getStackInSlot(i);
            if (stack.m_41619_() || !itemList.contains(stack.m_41720_())) continue;
            stackList.add(stack);
        }
        PlayerMainInvWrapper pInv = new PlayerMainInvWrapper(player.m_150109_());
        for (ItemStack s : stackList) {
            ItemStack st = ItemHelper.insertStack((IItemHandler)pInv, s.m_41777_(), false);
            s.m_41764_(st.m_41613_());
        }
    }

    public static boolean compactSimpleInventory(IItemHandlerModifiable inv) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stackList.add(stack);
            inv.setStackInSlot(i, ItemStack.f_41583_);
        }
        stackList.forEach(s -> ItemHelper.insertStack((IItemHandler)inv, s, false));
        return stackList.isEmpty();
    }

    public static int sortInt(int i1, int i2) {
        if (i1 == i2) {
            return 0;
        }
        if (i1 > i2) {
            return 1;
        }
        if (i1 < i2) {
            return -1;
        }
        return 0;
    }

    public static int sortItemStack(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return 0;
        }
        int stackId1 = Item.m_41393_((Item)stack1.m_41720_());
        int stackId2 = Item.m_41393_((Item)stack2.m_41720_());
        if (stackId1 == 0 || stackId2 == 0) {
            return 0;
        }
        if (stackId1 > stackId2) {
            return 1;
        }
        if (stackId1 < stackId2) {
            return -1;
        }
        return 0;
    }

    public static int sortSlot(Slot slot1, Slot slot2, boolean notRreverse) {
        ItemStack stack1 = slot1.m_7993_();
        ItemStack stack2 = slot2.m_7993_();
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return 0;
        }
        int stackId1 = Item.m_41393_((Item)stack1.m_41720_());
        int stackId2 = Item.m_41393_((Item)stack2.m_41720_());
        if (stackId1 == 0 || stackId2 == 0) {
            return 0;
        }
        if (stackId1 > stackId2) {
            return notRreverse ? 1 : -1;
        }
        if (stackId1 < stackId2) {
            return notRreverse ? -1 : 1;
        }
        return 0;
    }

    public static int sortName(Slot slot1, Slot slot2, boolean notRreverse) {
        String stackName2;
        ItemStack stack1 = slot1.m_7993_();
        ItemStack stack2 = slot2.m_7993_();
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return 0;
        }
        String stackName1 = stack1.m_41786_().getString();
        if (stackName1.equals(stackName2 = stack2.m_41786_().getString())) {
            return 0;
        }
        String[] nameArray = new String[]{stackName1, stackName2};
        Arrays.sort(nameArray, String.CASE_INSENSITIVE_ORDER);
        String sortedName1 = nameArray[0];
        String sortedName2 = nameArray[1];
        if (sortedName2.equals(stackName1)) {
            return notRreverse ? 1 : -1;
        }
        if (sortedName1.equals(stackName1)) {
            return notRreverse ? -1 : 1;
        }
        return 0;
    }

    public static void compactItemListNoStacksize(List<ItemStack> stackList) {
        for (int x = 0; x < stackList.size(); ++x) {
            ItemStack stack = stackList.get(x);
            if (stack.m_41619_()) continue;
            for (int z = x + 1; z < stackList.size(); ++z) {
                ItemStack s1 = stackList.get(z);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)s1)) continue;
                stack.m_41769_(s1.m_41613_());
                stackList.set(z, ItemStack.f_41583_);
            }
        }
        stackList.removeIf(ItemStack::m_41619_);
        stackList.sort(ITEMSTACK_ASCENDING);
    }

    public static int simulateFit(NonNullList<ItemStack> inv, ItemStack stack) {
        int stackSize = stack.m_41613_();
        for (ItemStack invStack : inv) {
            int amountSlot;
            if (invStack.m_41619_()) {
                return 0;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack) || (amountSlot = invStack.m_41741_() - invStack.m_41613_()) <= 0) continue;
            if (stackSize <= amountSlot) {
                return 0;
            }
            stackSize -= amountSlot;
        }
        return stackSize;
    }
}

