/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.worldgen.tree.featuer;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.worldgen.tree.featuer.AbstractTreeFeatuer;

public class SMTreeFeatuer
extends AbstractTreeFeatuer {
    private static final Direction[] ALLFACE = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private final int data;

    public SMTreeFeatuer(int data) {
        this.data = data;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> con) {
        int z;
        int x;
        BlockPos pos = con.m_159777_();
        WorldGenLevel world = con.m_159774_();
        if (!this.checkBlock(world.m_8055_(pos.m_7495_()).m_60734_())) {
            return false;
        }
        for (int y = 1; y <= 8; ++y) {
            if (world.m_46859_(pos.m_6630_(y))) continue;
            return false;
        }
        Random rand = new Random();
        BlockState log = this.getLog();
        BlockState leave = this.getLeave();
        this.m_5974_((LevelWriter)world, pos, AIR);
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                this.m_5974_((LevelWriter)world, this.offset(pos, x, 3.0, z), leave);
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -2; z <= 2; ++z) {
                this.m_5974_((LevelWriter)world, this.offset(pos, x, 4.0, z), leave);
                this.m_5974_((LevelWriter)world, this.offset(pos, z, 4.0, x), leave);
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                this.m_5974_((LevelWriter)world, this.offset(pos, x, 5.0, z), leave);
            }
        }
        for (int z2 = -1; z2 <= 1; ++z2) {
            this.m_5974_((LevelWriter)world, this.offset(pos, 0.0, 6.0, z2), leave);
            this.m_5974_((LevelWriter)world, this.offset(pos, z2, 6.0, 0.0), leave);
        }
        for (int y = 0; y <= 5; ++y) {
            this.m_5974_((LevelWriter)world, this.offset(pos, 0.0, y, 0.0), log);
        }
        if (leave.m_60734_() == BlockInit.chestnut_leaves) {
            BlockState chestnut = (BlockState)BlockInit.chestnut_plant.m_49966_().m_61124_((Property)ISMCrop.AGE2, (Comparable)Integer.valueOf(2));
            pos = pos.m_6630_(2);
            this.m_5974_((LevelWriter)world, pos.m_122013_(2), chestnut);
            this.m_5974_((LevelWriter)world, pos.m_122025_(2), chestnut);
            this.m_5974_((LevelWriter)world, pos.m_122020_(2), chestnut);
            this.m_5974_((LevelWriter)world, pos.m_122030_(2), chestnut);
        } else if (leave.m_60734_() == BlockInit.cherry_blossoms_leaves) {
            BlockState cherry_blossoms = BlockInit.cherry_blossoms_leaves_carpet.m_49966_();
            for (x = -4; x <= 4; ++x) {
                for (int z3 = -4; z3 <= 4; ++z3) {
                    float chance;
                    float f = chance = Math.abs(x) <= 2 && Math.abs(z3) <= 2 ? 0.725f : 0.275f;
                    if (x == 0 && z3 == 0 || rand.nextFloat() >= chance) continue;
                    this.setSMBlock(world, this.offset(pos, x, 0.0, z3), cherry_blossoms);
                }
            }
        } else if (leave.m_60734_() == BlockInit.maple_leaves) {
            BlockState cherry_blossoms = (BlockState)BlockInit.maple_leaves_carpet.m_49966_().m_61124_((Property)ISMCrop.AGE5, (Comparable)((Integer)leave.m_61143_((Property)ISMCrop.AGE5)));
            for (x = -4; x <= 4; ++x) {
                for (int z4 = -4; z4 <= 4; ++z4) {
                    float chance;
                    float f = chance = Math.abs(x) <= 2 && Math.abs(z4) <= 2 ? 0.725f : 0.275f;
                    if (x == 0 && z4 == 0 || rand.nextFloat() >= chance) continue;
                    this.setSMBlock(world, this.offset(pos, x, 0.0, z4), cherry_blossoms);
                }
            }
            if (world.m_213780_().m_188501_() >= 0.33f) {
                world.m_7731_(pos.m_6630_(1), (BlockState)BlockInit.maple_hole_log.m_49966_().m_61124_((Property)BaseFaceBlock.FACING, (Comparable)ALLFACE[world.m_213780_().m_188503_(4)]), 3);
            }
        }
        return true;
    }

    @Override
    public BlockState getLog() {
        return switch (this.data) {
            case 1 -> BlockInit.lemon_log.m_49966_();
            case 2 -> BlockInit.orange_log.m_49966_();
            case 3 -> BlockInit.estor_log.m_49966_();
            case 4 -> BlockInit.peach_log.m_49966_();
            case 5 -> BlockInit.cherry_blossoms_log.m_49966_();
            case 6 -> BlockInit.maple_log.m_49966_();
            default -> BlockInit.chestnut_log.m_49966_();
        };
    }

    @Override
    public BlockState getLeave() {
        return switch (this.data) {
            case 1 -> (BlockState)BlockInit.lemon_leaves.m_49966_().m_61124_((Property)ISMCrop.AGE2, (Comparable)Integer.valueOf(2));
            case 2 -> (BlockState)BlockInit.orange_leaves.m_49966_().m_61124_((Property)ISMCrop.AGE2, (Comparable)Integer.valueOf(2));
            case 3 -> (BlockState)BlockInit.estor_leaves.m_49966_().m_61124_((Property)ISMCrop.AGE2, (Comparable)Integer.valueOf(2));
            case 4 -> (BlockState)BlockInit.peach_leaves.m_49966_().m_61124_((Property)ISMCrop.AGE2, (Comparable)Integer.valueOf(2));
            case 5 -> (BlockState)((BlockState)BlockInit.cherry_blossoms_leaves.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
            case 6 -> (BlockState)((BlockState)((BlockState)BlockInit.maple_leaves.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1))).m_61124_((Property)ISMCrop.AGE5, (Comparable)Integer.valueOf(new Random().nextInt(6)));
            default -> (BlockState)((BlockState)BlockInit.chestnut_leaves.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
        };
    }

    public void setSMBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (world.m_46859_(pos) && this.checkBlock(world.m_8055_(pos.m_7495_()).m_60734_())) {
            this.m_5974_((LevelWriter)world, pos, state);
        } else {
            BlockPos targetPos;
            int y;
            for (y = 1; y < 4; ++y) {
                targetPos = pos.m_6625_(y);
                if (!world.m_46859_(targetPos) || !this.checkBlock(world.m_8055_(targetPos.m_7495_()).m_60734_())) continue;
                this.m_5974_((LevelWriter)world, targetPos, state);
                return;
            }
            for (y = 1; y < 2; ++y) {
                targetPos = pos.m_6630_(y);
                if (!world.m_46859_(targetPos) || !this.checkBlock(world.m_8055_(targetPos.m_7495_()).m_60734_())) continue;
                this.m_5974_((LevelWriter)world, targetPos, state);
                return;
            }
        }
    }

    protected void m_5974_(LevelWriter world, BlockPos pos, BlockState state) {
        world.m_7731_(pos, state, 3);
    }
}

