/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sweetmagic.util.WorldHelper;

public abstract class AbstractChopTaskEvent {
    public final Level world;
    public final Player player;
    public final boolean isCreative;
    public final BlockPos start;
    public final int blockTick;
    public List<BlockPos> targetblockList = new ArrayList<BlockPos>();
    public Set<BlockPos> posSet = new HashSet<BlockPos>();
    public final Direction[] allFace = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public AbstractChopTaskEvent(BlockPos start, Player player, int blockTick) {
        this.world = player.m_9236_();
        this.player = player;
        this.isCreative = player.m_7500_();
        this.blockTick = blockTick;
        this.start = start;
        this.targetblockList.add(start);
    }

    @SubscribeEvent
    public void chopChop(TickEvent.ServerTickEvent event) {
        if (event.side.isClient()) {
            this.finish();
            return;
        }
        int tick = this.blockTick;
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        boolean isFirst = this.posSet.isEmpty();
        while (tick > 0) {
            if (this.targetblockList.isEmpty()) {
                this.finish();
                return;
            }
            BlockPos pos = this.targetblockList.get(0);
            this.targetblockList.remove(0);
            if (isFirst) {
                if (!this.isCreative) {
                    dropList.addAll(Block.m_49874_((BlockState)this.world.m_8055_(this.start), (ServerLevel)((ServerLevel)this.world), (BlockPos)pos, (BlockEntity)this.world.m_7702_(pos), (Entity)this.player, (ItemStack)this.player.m_21205_()));
                }
                this.world.m_46961_(pos, false);
                for (Direction face : this.allFace) {
                    BlockPos posFace = pos.m_121945_(face);
                    if (!this.checkBlock(this.world, posFace)) continue;
                    this.targetblockList.add(posFace);
                    this.posSet.add(posFace);
                }
                isFirst = false;
                continue;
            }
            if (!this.checkBlock(this.world, pos)) continue;
            BlockState state = this.world.m_8055_(pos);
            if (!this.isCreative) {
                dropList.addAll(Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)this.world), (BlockPos)pos, (BlockEntity)this.world.m_7702_(pos), (Entity)this.player, (ItemStack)this.player.m_21205_()));
            }
            this.world.m_46961_(pos, false);
            for (Direction face : this.allFace) {
                BlockPos posFace = pos.m_121945_(face);
                this.checkPos(posFace);
                if (face == Direction.UP) continue;
                this.checkPos(posFace.m_7494_());
            }
            --tick;
        }
        WorldHelper.createLootDrop(dropList, this.world, this.player.f_19854_, this.player.f_19855_, this.player.f_19856_);
    }

    public void checkPos(BlockPos pos) {
        if (!this.posSet.contains(pos) && this.checkBlock(this.world, pos)) {
            this.targetblockList.add(pos);
            this.posSet.add(pos);
        }
    }

    public void finish() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public LootContext.Builder getLoot(Level world, BlockPos pos, ItemStack stack) {
        return new LootContext.Builder((ServerLevel)world).m_230911_(world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)stack).m_78984_(LootContextParams.f_81462_, (Object)world.m_7702_(pos));
    }

    public abstract boolean checkBlock(Level var1, BlockPos var2);
}

