/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.iblock;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.api.SweetMagicAPI;

public interface ITileMF {
    public BlockEntity getTile();

    public Set<BlockPos> getPosList();

    public void addPosList(BlockPos var1);

    public BlockPos getTilePos();

    public Level getTileWorld();

    public int getTickTime();

    public void setTickTime(int var1);

    public boolean getReceive();

    public int getMF();

    public void setMF(int var1);

    public int getMaxMF();

    default public boolean isMFEmpty() {
        return this.getMF() <= 0;
    }

    default public boolean isMaxMF() {
        return this.getMF() >= this.getMaxMF();
    }

    default public int getReceiveMF() {
        return 5000;
    }

    default public int getShrinkMF() {
        return 2000;
    }

    default public boolean hasNeedMF() {
        return this.getMF() >= this.getShrinkMF();
    }

    default public int getMFProgressScaled(int value) {
        return this.isMFEmpty() ? 0 : Math.min(value, (int)((float)value * (float)this.getMF() / (float)this.getMaxMF()));
    }

    default public int outputMF(int mf) {
        if (mf > this.getMF()) {
            mf = this.getMF();
        }
        this.setMF(this.getMF() - mf);
        return mf;
    }

    default public int outPutItemMF(ItemStack stack) {
        int mf = this.getMaxMF() - this.getMF();
        int count = 0;
        if (mf < this.getItemMF(stack.m_41720_()) * stack.m_41613_()) {
            count = (this.getItemMF(stack.m_41720_()) * stack.m_41613_() - mf) / this.getItemMF(stack.m_41720_());
        }
        return count;
    }

    default public boolean isMFAPIItem(ItemStack stack) {
        return SweetMagicAPI.hasMF(stack);
    }

    default public int getItemMF(Item item) {
        return SweetMagicAPI.getMF(new ItemStack((ItemLike)item));
    }

    default public void sendRecivehandler() {
        Level world = this.getTileWorld();
        for (BlockPos tilePos : this.getPosList()) {
            BlockEntity tile;
            if (tilePos.m_123341_() == this.getTilePos().m_123341_() && tilePos.m_123342_() == this.getTilePos().m_123342_() && tilePos.m_123343_() == this.getTilePos().m_123343_() || !((tile = world.m_7702_(tilePos)) instanceof ITileMF)) continue;
            ITileMF mfBase = (ITileMF)tile;
            if (!this.getReceive()) continue;
            this.insertMF(this, mfBase, this.getTickTime());
        }
    }

    default public void insertMF(ITileMF reci, ITileMF tran, int tickTime) {
        int reciMF = reci.getMF();
        int maxMF = reci.getMaxMF() <= 0 ? 100000 : reci.getMaxMF();
        int tranMF = tran.getMF();
        int receiveMF = Math.min(reci.getReceiveMF(), reci.getMaxMF() - reci.getMF());
        if (reciMF >= maxMF) {
            this.maxMFInsert(tran);
            return;
        }
        if (tranMF <= 0) {
            return;
        }
        if (receiveMF > tranMF && !tran.isCreative()) {
            reci.setMF(reci.getMF() + tranMF);
            reci.sentClient();
            tran.setMF(0);
            tran.sentClient();
        } else {
            reci.setMF(reciMF + receiveMF);
            reci.sentClient();
            if (!tran.isCreative()) {
                tran.setMF(tranMF - receiveMF);
                tran.sentClient();
            }
        }
        reci.recipedMFInsert();
    }

    default public void maxMFInsert(ITileMF tran) {
    }

    default public void recipedMFInsert() {
    }

    default public CompoundTag savePosList(CompoundTag nbt, Set<BlockPos> posList, String name) {
        if (posList == null || posList.isEmpty()) {
            return nbt;
        }
        ListTag tagsList = new ListTag();
        for (BlockPos pos : posList) {
            if (pos == null) continue;
            CompoundTag tags = new CompoundTag();
            tags.m_128405_("X", pos.m_123341_());
            tags.m_128405_("Y", pos.m_123342_());
            tags.m_128405_("Z", pos.m_123343_());
            tagsList.add((Object)tags);
        }
        nbt.m_128365_(name, (Tag)tagsList);
        return nbt;
    }

    default public Set<BlockPos> loadAllPos(CompoundTag nbt, String name) {
        ListTag tagsList = nbt.m_128437_(name, 10);
        HashSet<BlockPos> list = new HashSet<BlockPos>();
        for (int i = 0; i < tagsList.size(); ++i) {
            CompoundTag tags = tagsList.m_128728_(i);
            list.add(new BlockPos(tags.m_128451_("X"), tags.m_128451_("Y"), tags.m_128451_("Z")));
        }
        return list;
    }

    default public boolean checkDistance(BlockPos pos) {
        double dis = 15.0;
        double pX = Math.abs(this.getTilePos().m_123341_() - pos.m_123341_());
        double pY = Math.abs(this.getTilePos().m_123342_() - pos.m_123342_());
        double pZ = Math.abs(this.getTilePos().m_123343_() - pos.m_123343_());
        return pX <= dis && pY <= dis && pZ <= dis;
    }

    default public int getItemMF(ItemStack stack) {
        return !SweetMagicAPI.hasMF(stack) ? 0 : SweetMagicAPI.getMF(stack) * stack.m_41613_();
    }

    default public boolean isCreative() {
        return false;
    }

    default public void sentClient() {
        this.markDirty();
    }

    default public void markDirty() {
        Level world = this.getTileWorld();
        if (world == null) {
            return;
        }
        BlockPos pos = this.getTilePos();
        BlockState state = world.m_8055_(pos);
        if (world.m_46805_(pos)) {
            world.m_46745_(pos).m_8092_(true);
        }
        world.m_7260_(this.getTilePos(), state, state, 2);
    }
}

