/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.ientity;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import sweetmagic.config.SMConfig;
import sweetmagic.init.DimentionInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.BelialSword;
import sweetmagic.init.entity.projectile.EvilArrow;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.SMDamage;
import sweetmagic.util.WorldHelper;

public interface ISMMob {
    public static final EntityDataSerializer<Boolean> BOOLEAN = EntityDataSerializers.f_135035_;
    public static final EntityDataSerializer<Integer> INT = EntityDataSerializers.f_135028_;
    public static final EntityDataSerializer<Float> FLOAT = EntityDataSerializers.f_135029_;
    public static final BossEvent.BossBarColor BC_BLUE = BossEvent.BossBarColor.BLUE;
    public static final BossEvent.BossBarColor BC_RED = BossEvent.BossBarColor.RED;
    public static final BossEvent.BossBarColor BC_GREEN = BossEvent.BossBarColor.GREEN;
    public static final BossEvent.BossBarOverlay NOTCHED_6 = BossEvent.BossBarOverlay.NOTCHED_6;

    default public float getDamageAmount(Level world, DamageSource src, float dame, float rate) {
        Entity entity = src.m_7640_();
        if (entity instanceof Warden) {
            Warden entity2 = (Warden)entity;
            entity2.m_6469_(SMDamage.f_19319_, dame);
            entity2.f_19802_ = 0;
            dame *= 0.1f * rate;
        }
        if (!this.isLowRank()) {
            return dame;
        }
        if (this.isSMDimension(world)) {
            return this.isSMDamage(src) ? dame * 0.875f * rate : dame * 0.25f * rate;
        }
        return this.isSMDamage(src) ? dame * 2.0f : dame;
    }

    default public boolean isSMDimension(Level world) {
        return world.m_46472_() == DimentionInit.SweetMagicWorld;
    }

    default public float getBossDamageAmount(Level world, int defTime, DamageSource src, float amount, float cap) {
        SMDamage smDame;
        Entity attacker = src.m_7640_();
        if (src instanceof SMDamage && (smDame = (SMDamage)src).isDebuffFlag()) {
            amount *= 0.25f;
        } else if (attacker instanceof Warden) {
            Warden entity = (Warden)attacker;
            entity.m_6469_(SMDamage.f_19319_, amount);
            entity.f_19802_ = 0;
            amount = 0.0f;
        }
        if (attacker instanceof AbstractSummonMob || src.m_7639_() instanceof AbstractSummonMob) {
            amount = Math.min(cap * 0.5f, amount) * 0.5f;
        } else {
            if (attacker instanceof EvilArrow || attacker instanceof BelialSword) {
                return amount;
            }
            if (attacker instanceof AbstractMagicShot) {
                AbstractMagicShot magic = (AbstractMagicShot)attacker;
                if (magic.getCritical()) {
                    cap *= magic.getCriticalDamage();
                }
                if (magic.getCapRelaxationDamage() > 0.0f) {
                    cap += magic.getCapRelaxationDamage();
                }
            } else {
                return Math.min(amount, cap) * 0.25f;
            }
        }
        float defTimeDamage = src == SMDamage.addDamage ? cap / 5.0f : 0.0f;
        return Math.min(defTime <= 0 ? cap : defTimeDamage, amount);
    }

    default public boolean isSMDamage(DamageSource src) {
        Entity entity = src.m_7640_();
        return src instanceof SMDamage || entity instanceof AbstractMagicShot;
    }

    default public boolean notMagicDamage(Entity attacker, Entity attackEntity) {
        return attacker != null && attackEntity != null && !(attackEntity instanceof AbstractMagicShot) && !(attackEntity instanceof AbstractSummonMob);
    }

    default public boolean checkBossDamage(DamageSource src) {
        return !this.isSMDamage(src);
    }

    default public <T extends Entity> List<T> getEntityList(Class<T> enClass, Entity entity, double range) {
        return WorldHelper.getEntityList(entity, enClass, this.getAABB(entity, range));
    }

    default public <T extends Entity> List<T> getEntityList(Class<T> enClass, Entity entity, Predicate<T> filter, double range) {
        return WorldHelper.getEntityList(entity, enClass, filter, this.getAABB(entity, range));
    }

    default public <T extends Entity> List<T> getEntityList(Class<T> enClass, Entity entity, Predicate<T> filter, BlockPos pos, double range) {
        return WorldHelper.getEntityList(entity, enClass, filter, this.getAABB(pos, range));
    }

    default public AABB getAABB(Entity entity, double range) {
        return entity.m_20191_().m_82377_(range, range / 2.0, range);
    }

    default public AABB getAABB(Entity entity, double x, double y, double z) {
        return entity.m_20191_().m_82377_(x, y, z);
    }

    default public AABB getAABB(BlockPos pos, double range) {
        return new AABB((double)pos.m_123341_() - range, (double)pos.m_123342_() - range, (double)pos.m_123343_() - range, (double)pos.m_123341_() + range, (double)pos.m_123342_() + range, (double)pos.m_123343_() + range);
    }

    public SynchedEntityData getData();

    default public <T> T get(EntityDataAccessor<T> value) {
        return (T)this.getData().m_135370_(value);
    }

    default public <T> void set(EntityDataAccessor<T> value, T par) {
        this.getData().m_135381_(value, par);
    }

    default public <T> void define(EntityDataAccessor<T> value, T par) {
        this.getData().m_135372_(value, par);
    }

    public static <T> EntityDataAccessor<T> setData(Class<? extends Mob> entity, EntityDataSerializer<T> seria) {
        return SynchedEntityData.m_135353_(entity, seria);
    }

    default public int sortEntity(Entity mob, Entity entity1, Entity entity2) {
        double distance2;
        if (entity1 == null || entity2 == null) {
            return 0;
        }
        double distance1 = mob.m_20280_(entity1);
        if (distance1 > (distance2 = mob.m_20280_(entity2))) {
            return 1;
        }
        if (distance1 < distance2) {
            return -1;
        }
        return 0;
    }

    default public void playSound(Level world, LivingEntity entity, SoundEvent sound, float vol, float pitch) {
        world.m_5594_(null, entity.m_20183_(), sound, SoundSource.HOSTILE, vol, pitch);
    }

    default public boolean isTarget() {
        return false;
    }

    default public boolean isHard(Level world) {
        return world.m_46791_().equals((Object)Difficulty.HARD);
    }

    default public boolean isHalfHealth(LivingEntity entity) {
        return (double)entity.m_21223_() <= (double)entity.m_21233_() * 0.5;
    }

    default public boolean isLeader(LivingEntity entity) {
        return entity.m_21023_(PotionInit.leader_flag);
    }

    default public int getPotionLevel(LivingEntity entity, MobEffect potion) {
        return entity.m_21023_(potion) ? 1 : 0;
    }

    public static boolean isOverworld(ServerLevelAccessor world, BlockPos pos) {
        return world.m_204166_(pos).m_203656_(BiomeTags.f_215817_);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor world, BlockPos pos, RandomSource rand) {
        if (!(((Boolean)SMConfig.spawnSMMob.get()).booleanValue() || world.m_45517_(LightLayer.SKY, pos) <= rand.m_188503_(32) && (ISMMob.isOverworld(world, pos) && ISMMob.isSkyView(world, pos) || world.m_204166_(pos).m_203656_(TagInit.IS_SWEETMAGIC)))) {
            return false;
        }
        DimensionType dim = world.m_6042_();
        int i = dim.m_223570_();
        if (i < 15 && world.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = world.m_6018_().m_46470_() ? world.m_46849_(pos, 10) : world.m_46803_(pos);
        return j <= dim.m_223569_().m_214085_(rand);
    }

    public static boolean isDarkEnoughToSpawnSM(ServerLevelAccessor world, BlockPos pos, RandomSource rand) {
        if (world.m_45517_(LightLayer.SKY, pos) > rand.m_188503_(32) || !world.m_204166_(pos).m_203656_(TagInit.IS_SWEETMAGIC)) {
            return false;
        }
        DimensionType dim = world.m_6042_();
        int i = dim.m_223570_();
        if (i < 15 && world.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = world.m_6018_().m_46470_() ? world.m_46849_(pos, 10) : world.m_46803_(pos);
        return j <= dim.m_223569_().m_214085_(rand);
    }

    default public int getDate(Level world) {
        return (int)(world.m_8044_() / 24000L);
    }

    default public float getDateRate(Level world, float minRate) {
        float rate = 1.0f;
        Difficulty dif = world.m_46791_();
        if (dif.equals((Object)Difficulty.HARD) || this.isSMDimension(world)) {
            return 1.0f;
        }
        if (dif.equals((Object)Difficulty.EASY)) {
            rate = 4.0f;
        } else if (dif.equals((Object)Difficulty.NORMAL)) {
            rate = 2.0f;
        }
        int date = Math.max(0, this.getDate(world) - this.getMaxSpawnDate());
        return minRate + Math.min(1.0f, (float)date / ((float)this.getMaxSpawnDate() * rate)) * (1.0f - minRate);
    }

    default public void initMobData(LivingEntity entity, DifficultyInstance dif) {
        if (entity.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            LocalDate date = LocalDate.now();
            int d = date.get(ChronoField.DAY_OF_MONTH);
            int m = date.get(ChronoField.MONTH_OF_YEAR);
            RandomSource rand = entity.m_217043_();
            if (m == 10 && d == 31 && rand.m_188501_() < 0.25f) {
                entity.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(rand.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
            }
        }
        if (!this.isLowRank()) {
            return;
        }
        switch (dif.m_19048_()) {
            case EASY: {
                entity.m_21051_(Attributes.f_22276_).m_22100_((double)(entity.m_21233_() * 0.75f));
                break;
            }
            case NORMAL: {
                entity.m_21051_(Attributes.f_22276_).m_22100_((double)(entity.m_21233_() * 0.9f));
            }
        }
        entity.m_21153_(entity.m_21233_());
    }

    default public boolean isLowRank() {
        return true;
    }

    default public int getMaxSpawnDate() {
        return (Integer)SMConfig.spawnDate.get();
    }

    default public Vector3f getShotVector(Mob entity, Vec3 vec, float shake) {
        Vec3 vec1 = vec.m_82541_();
        Vec3 vec2 = vec1.m_82537_(new Vec3(0.0, 1.0, 0.0));
        if (vec2.m_82556_() <= 1.0E-7) {
            vec2 = vec1.m_82537_(entity.m_20289_(1.0f));
        }
        Quaternion qua1 = new Quaternion(new Vector3f(vec2), 90.0f, true);
        Vector3f vecf1 = new Vector3f(vec1);
        vecf1.m_122251_(qua1);
        Quaternion qua2 = new Quaternion(vecf1, shake, true);
        Vector3f vecf2 = new Vector3f(vec1);
        vecf2.m_122251_(qua2);
        return vecf2;
    }

    public static boolean isDayElapse(ServerLevelAccessor world, int day) {
        if (((Boolean)SMConfig.spawnSMMob.get()).booleanValue()) {
            return true;
        }
        return switch (world.m_46791_()) {
            case Difficulty.EASY -> {
                if (world.m_8044_() > (long)(day * 36000)) {
                    yield true;
                }
                yield false;
            }
            case Difficulty.NORMAL -> {
                if (world.m_8044_() > (long)(day * 24000)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public static boolean isSkyView(ServerLevelAccessor world, BlockPos pos) {
        return world.m_45527_(pos) || (Boolean)SMConfig.spawnCave.get() != false && pos.m_123342_() <= 30 && Math.min(1.0f, (30.0f - (float)pos.m_123342_()) * 0.0333f) > world.m_213780_().m_188501_();
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Mob> enType, ServerLevelAccessor world, MobSpawnType spType, BlockPos pos, RandomSource rand) {
        return !WorldHelper.isPeace((LevelAccessor)world) && ISMMob.isDarkEnoughToSpawn(world, pos, rand) && Mob.m_217057_(enType, (LevelAccessor)world, (MobSpawnType)spType, (BlockPos)pos, (RandomSource)rand) && ISMMob.isDayElapse(world, (Integer)SMConfig.spawnDate.get());
    }

    public static boolean checkMonsterSpawnRulesSM(EntityType<? extends Mob> enType, ServerLevelAccessor world, MobSpawnType spType, BlockPos pos, RandomSource rand) {
        return !WorldHelper.isPeace((LevelAccessor)world) && ISMMob.isDarkEnoughToSpawnSM(world, pos, rand) && Mob.m_217057_(enType, (LevelAccessor)world, (MobSpawnType)spType, (BlockPos)pos, (RandomSource)rand);
    }

    default public void addPotion(LivingEntity entity, MobEffect potion, int time, int level) {
        PlayerHelper.setPotion(entity, potion, level, time);
    }

    default public ItemStack getStack() {
        return ItemStack.f_41583_;
    }

    public void refreshInfo();

    default public Iterable<BlockPos> getPosList(BlockPos pos, double range) {
        return WorldHelper.getRangePos(pos, range);
    }

    default public Iterable<BlockPos> getPosRangeList(BlockPos pos, double range) {
        return WorldHelper.getRangePos(pos, -range, 0.0, -range, range, 0.0, range);
    }

    default public boolean isPlayer(Entity entity) {
        return entity instanceof Player || entity instanceof AbstractSummonMob;
    }

    default public Predicate<LivingEntity> getTargetEntity() {
        return e -> e instanceof Player || e instanceof AbstractSummonMob;
    }

    public record SpawnInfo(ServerLevelAccessor world, DifficultyInstance dif, MobSpawnType spawn, SpawnGroupData data, CompoundTag tag) {
    }

    public static class RandomMoveGoal
    extends Goal {
        private final Mob mob;

        public RandomMoveGoal(Mob mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean m_8036_() {
            return !this.mob.m_21566_().m_24995_() && this.mob.m_9236_().m_213780_().m_188503_(RandomMoveGoal.m_186073_((int)1)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos pos = this.mob.m_20183_();
            RandomSource rand = this.mob.m_9236_().m_213780_();
            for (int i = 0; i < 3; ++i) {
                BlockPos pos1 = WorldHelper.offset(pos, rand.m_188503_(15) - 7, rand.m_188503_(11) - 5, rand.m_188503_(15) - 7);
                if (!this.mob.m_9236_().m_46859_(pos1)) continue;
                this.mob.m_21566_().m_6849_((double)pos1.m_123341_() + 0.5, (double)pos1.m_123342_() + 0.5, (double)pos1.m_123343_() + 0.5, 0.25);
                if (this.mob.m_5448_() != null) break;
                this.mob.m_21563_().m_24950_((double)pos1.m_123341_() + 0.5, (double)pos1.m_123342_() + 0.5, (double)pos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    public static class SMMoveControl
    extends MoveControl {
        private final Mob mob;

        public SMMoveControl(Mob mob) {
            super(mob);
            this.mob = mob;
        }

        public void m_8126_() {
            AbstractSummonMob su;
            Mob mob;
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                return;
            }
            Vec3 vec = new Vec3(this.f_24975_ - this.mob.m_20185_(), this.f_24976_ - this.mob.m_20186_(), this.f_24977_ - this.mob.m_20189_());
            double d0 = vec.m_82553_();
            if (d0 < this.mob.m_20191_().m_82309_() || (mob = this.mob) instanceof AbstractSummonMob && (su = (AbstractSummonMob)mob).getShit()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.mob.m_20256_(this.mob.m_20184_().m_82490_(0.5));
            } else {
                this.mob.m_20256_(this.mob.m_20184_().m_82549_(vec.m_82490_(this.f_24978_ * 0.05 / d0)));
                if (this.mob.m_5448_() == null) {
                    Vec3 vec1 = this.mob.m_20184_();
                    this.mob.m_146922_(-((float)Mth.m_14136_((double)vec1.f_82479_, (double)vec1.f_82481_)) * 57.295776f);
                    this.mob.f_20883_ = this.mob.m_146908_();
                } else {
                    double d2 = this.mob.m_5448_().m_20185_() - this.mob.m_20185_();
                    double d1 = this.mob.m_5448_().m_20189_() - this.mob.m_20189_();
                    this.mob.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                    this.mob.f_20883_ = this.mob.m_146908_();
                }
            }
        }
    }
}

