/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.iitem;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import sweetmagic.api.emagic.SMAcceType;
import sweetmagic.api.emagic.SMDropType;
import sweetmagic.api.iitem.info.AcceInfo;
import sweetmagic.api.iitem.info.PorchInfo;
import sweetmagic.api.util.ISMTip;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.WorldHelper;

public interface IAcce
extends ISMTip {
    public static final String STACKCOUNT = "stackCount";

    default public boolean canUseEffect(Level world, Player player, AcceInfo info) {
        return !player.m_36335_().m_41519_(info.getItem());
    }

    default public void onUpdate(Level world, Player player, AcceInfo info) {
    }

    default public void onClientUpdate(Level world, Player player, AcceInfo info) {
    }

    default public void onMultiUpdate(Level world, Player player, AcceInfo info, PorchInfo pInfo) {
    }

    public void magicToolTip(List<MutableComponent> var1, ItemStack var2);

    default public void debuffRemovalTip(List<MutableComponent> toolTip) {
    }

    default public void dropMobTip(List<MutableComponent> toolTip) {
    }

    default public MutableComponent getHowGetTip() {
        return this.getText(this.getDropType().getName());
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeMap(Level world, Player player, AcceInfo info, PorchInfo pInfo) {
        return ImmutableMultimap.of();
    }

    public SMAcceType getAcceType();

    public void setAcceType(SMAcceType var1);

    public SMDropType getDropType();

    public void setDropType(SMDropType var1);

    public int getTier();

    default public boolean isUpdateType(Level world, Player player, AcceInfo info) {
        return this.getAcceType().is(SMAcceType.UPDATE);
    }

    default public void addPotion(LivingEntity target, MobEffect effect, int level, int time) {
        PlayerHelper.setPotion(target, effect, level, time);
    }

    default public void addPotion(LivingEntity target, MobEffect effect, int level, int time, boolean flag) {
        PlayerHelper.setPotion(target, effect, level, time, flag);
    }

    default public <T extends Entity> List<T> getEntityList(Class<T> enClass, Entity entity, double range) {
        return WorldHelper.getEntityList(entity, enClass, this.getAABB(entity, range));
    }

    default public <T extends Entity> List<T> getEntityList(Class<T> enClass, Entity entity, Predicate<T> filter, double range) {
        return WorldHelper.getEntityList(entity, enClass, filter, this.getAABB(entity, range));
    }

    default public AABB getAABB(Entity entity, double range) {
        return entity.m_20191_().m_82377_(range, range, range);
    }

    default public AABB getAABB(Entity entity, double x, double y, double z) {
        return entity.m_20191_().m_82377_(x, y, z);
    }

    default public void playSound(Level world, LivingEntity entity, SoundEvent sound, float vol, float pitch) {
        world.m_5594_(null, entity.m_20183_(), sound, SoundSource.PLAYERS, vol, pitch);
    }

    default public boolean isDuplication() {
        return false;
    }

    default public boolean isSwitch() {
        return false;
    }

    default public int getStackCount(AcceInfo info) {
        return !this.isDuplication() ? 1 : info.getNBT().m_128451_(STACKCOUNT);
    }

    default public int getMaxStackCount() {
        return 1;
    }

    default public boolean canAddStackCount(AcceInfo info) {
        return this.getStackCount(info) < this.getMaxStackCount();
    }

    default public void addStackCount(AcceInfo info) {
        if (!this.canAddStackCount(info)) {
            return;
        }
        CompoundTag tags = this.getNBT(info.getStack());
        tags.m_128405_(STACKCOUNT, tags.m_128451_(STACKCOUNT) + 1);
    }

    default public CompoundTag getNBT(ItemStack stack) {
        CompoundTag tags = stack.m_41783_();
        if (tags == null) {
            tags = new CompoundTag();
            tags.m_128405_(STACKCOUNT, 1);
            stack.m_41751_(tags);
        }
        if (!tags.m_128441_(STACKCOUNT)) {
            tags.m_128405_(STACKCOUNT, 1);
        }
        return tags;
    }

    public static IAcce getAcce(ItemStack stack) {
        return (IAcce)stack.m_41720_();
    }
}

